/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.AndEvaluator;
import org.apache.directory.server.xdbm.search.impl.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.NotEvaluator;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.impl.OrEvaluator;
import org.apache.directory.server.xdbm.search.impl.PresenceEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeEvaluator;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.filter.SubstringNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorBuilder {
    private final Store<ServerEntry> db;
    private final Registries registries;

    public EvaluatorBuilder(Store<ServerEntry> db, Registries registries) throws Exception {
        this.db = db;
        this.registries = registries;
    }

    public Evaluator<? extends ExprNode, ServerEntry> build(ExprNode node) throws Exception {
        switch (node.getAssertionType()) {
            case APPROXIMATE: {
                return new ApproximateEvaluator((ApproximateNode)node, this.db, this.registries);
            }
            case EQUALITY: {
                return new EqualityEvaluator((EqualityNode)node, this.db, this.registries);
            }
            case GREATEREQ: {
                return new GreaterEqEvaluator((GreaterEqNode)node, this.db, this.registries);
            }
            case LESSEQ: {
                return new LessEqEvaluator((LessEqNode)node, this.db, this.registries);
            }
            case PRESENCE: {
                return new PresenceEvaluator((PresenceNode)node, this.db, this.registries);
            }
            case SCOPE: {
                if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                    return new OneLevelScopeEvaluator<ServerEntry>(this.db, (ScopeNode)node);
                }
                return new SubtreeScopeEvaluator<ServerEntry>(this.db, (ScopeNode)node);
            }
            case SUBSTRING: {
                return new SubstringEvaluator((SubstringNode)node, this.db, this.registries);
            }
            case AND: {
                return this.buildAndEvaluator((AndNode)node);
            }
            case NOT: {
                return new NotEvaluator((NotNode)node, this.build(((NotNode)node).getFirstChild()));
            }
            case OR: {
                return this.buildOrEvaluator((OrNode)node);
            }
            case ASSERTION: 
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalStateException("Unknown assertion type: " + node.getAssertionType());
    }

    AndEvaluator buildAndEvaluator(AndNode node) throws Exception {
        List children = node.getChildren();
        ArrayList<Evaluator<? extends ExprNode, ServerEntry>> evaluators = new ArrayList<Evaluator<? extends ExprNode, ServerEntry>>(children.size());
        for (ExprNode child : children) {
            evaluators.add(this.build(child));
        }
        return new AndEvaluator(node, evaluators);
    }

    OrEvaluator buildOrEvaluator(OrNode node) throws Exception {
        List children = node.getChildren();
        ArrayList<Evaluator<? extends ExprNode, ServerEntry>> evaluators = new ArrayList<Evaluator<? extends ExprNode, ServerEntry>>(children.size());
        for (ExprNode child : children) {
            evaluators.add(this.build(child));
        }
        return new OrEvaluator(node, evaluators);
    }
}

