/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.xdbm.AbstractTupleCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NoDupsCursor<K, V>
extends AbstractTupleCursor<K, V> {
    private final JdbmTable<K, V> table;
    private jdbm.helper.Tuple jdbmTuple = new jdbm.helper.Tuple();
    private Tuple<K, V> returnedTuple = new Tuple();
    private TupleBrowser browser;
    private boolean valueAvailable;

    public NoDupsCursor(JdbmTable<K, V> table) throws IOException {
        this.table = table;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.jdbmTuple.setKey(null);
        this.jdbmTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        this.checkNotClosed("beforeKey()");
        this.browser = this.table.getBTree().browse(key);
        this.clearValue();
    }

    public void afterKey(K key) throws Exception {
        this.browser = this.table.getBTree().browse(key);
        while (this.browser.getNext(this.jdbmTuple)) {
            this.checkNotClosed("afterKey()");
            Object next = this.jdbmTuple.getKey();
            int nextCompared = this.table.getKeyComparator().compare(next, key);
            if (nextCompared <= 0) continue;
            this.browser.getPrevious(this.jdbmTuple);
            this.clearValue();
            return;
        }
        this.clearValue();
    }

    public void beforeValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    public void afterValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    public void before(Tuple<K, V> element) throws Exception {
        this.beforeKey(element.getKey());
    }

    public void after(Tuple<K, V> element) throws Exception {
        this.afterKey(element.getKey());
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.browser = this.table.getBTree().browse();
        this.clearValue();
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.browser = this.table.getBTree().browse(null);
        this.clearValue();
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.afterLast();
        }
        if (this.browser.getPrevious(this.jdbmTuple)) {
            if (this.returnedTuple.getKey() != null && this.table.getKeyComparator().compare(this.jdbmTuple.getKey(), this.returnedTuple.getKey()) == 0) {
                this.browser.getPrevious(this.jdbmTuple);
            }
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.jdbmTuple.getValue());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.beforeFirst();
        }
        if (this.browser.getNext(this.jdbmTuple)) {
            if (this.returnedTuple.getKey() != null && this.table.getKeyComparator().compare(this.jdbmTuple.getKey(), this.returnedTuple.getKey()) == 0) {
                this.browser.getNext(this.jdbmTuple);
            }
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.jdbmTuple.getValue());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public boolean isElementReused() {
        return true;
    }
}

