/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmStore<E>
implements Store<E> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmStore.class);
    static final int DEFAULT_CACHE_SIZE = 10000;
    private RecordManager recMan;
    private LdapDN normSuffix;
    private LdapDN upSuffix;
    private File workingDirectory;
    private JdbmMasterTable<ServerEntry> master;
    private Map<String, Index<?, E>> userIndices = new HashMap();
    private Map<String, Index<?, E>> systemIndices = new HashMap();
    private boolean initialized;
    private boolean isSyncOnWrite = true;
    private JdbmIndex<String, E> ndnIdx;
    private JdbmIndex<String, E> updnIdx;
    private JdbmIndex<String, E> presenceIdx;
    private JdbmIndex<String, E> aliasIdx;
    private JdbmIndex<Long, E> subLevelIdx;
    private JdbmIndex<Long, E> oneLevelIdx;
    private JdbmIndex<Long, E> oneAliasIdx;
    private JdbmIndex<Long, E> subAliasIdx;
    private JdbmIndex<String, E> objectClassIdx;
    private JdbmIndex<String, E> entryCsnIdx;
    private JdbmIndex<byte[], E> entryUuidIdx;
    private static AttributeType OBJECT_CLASS_AT;
    private static AttributeType ENTRY_CSN_AT;
    private static AttributeType ENTRY_UUID_AT;
    private static AttributeType ALIASED_OBJECT_NAME_AT;
    private AttributeTypeRegistry attributeTypeRegistry;
    private OidRegistry oidRegistry;
    private String suffixDn;
    private int cacheSize = 10000;
    private String name;

    private void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set jdbm store property " + property + " after initialization.");
        }
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.protect("workingDirectory");
        this.workingDirectory = workingDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setSuffixDn(String suffixDn) {
        this.protect("suffixDn");
        this.suffixDn = suffixDn;
    }

    public String getSuffixDn() {
        return this.suffixDn;
    }

    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.protect("syncOnWrite");
        this.isSyncOnWrite = isSyncOnWrite;
    }

    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite;
    }

    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setName(String name) {
        this.protect("name");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void init(Registries registries) throws Exception {
        this.oidRegistry = registries.getOidRegistry();
        this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        OBJECT_CLASS_AT = this.attributeTypeRegistry.lookup("objectClass");
        ALIASED_OBJECT_NAME_AT = this.attributeTypeRegistry.lookup("aliasedObjectName");
        ENTRY_CSN_AT = this.attributeTypeRegistry.lookup("entryCSN");
        ENTRY_UUID_AT = this.attributeTypeRegistry.lookup("entryUUID");
        this.upSuffix = new LdapDN(this.suffixDn);
        this.normSuffix = LdapDN.normalize((LdapDN)this.upSuffix, (Map)this.attributeTypeRegistry.getNormalizerMapping());
        this.workingDirectory.mkdirs();
        String path = this.workingDirectory.getPath() + File.separator + "master";
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.name);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", (Object)this.cacheSize, (Object)this.name);
        }
        this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(this.cacheSize));
        this.master = new JdbmMasterTable(this.recMan, registries);
        this.setupSystemIndices();
        this.setupUserIndices();
        this.initialized = true;
    }

    private void setupSystemIndices() throws Exception {
        if (this.systemIndices.size() > 0) {
            HashMap tmp = new HashMap();
            for (Index<?, E> index : this.systemIndices.values()) {
                String oid = this.oidRegistry.getOid(index.getAttributeId());
                tmp.put(oid, index);
                ((JdbmIndex)index).init(this.attributeTypeRegistry.lookup(oid), this.workingDirectory);
            }
            this.systemIndices = tmp;
        }
        if (this.ndnIdx == null) {
            this.ndnIdx = new JdbmIndex();
            this.ndnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.1");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.1", this.ndnIdx);
            this.ndnIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.1"), this.workingDirectory);
        }
        if (this.updnIdx == null) {
            this.updnIdx = new JdbmIndex();
            this.updnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.2");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.2", this.updnIdx);
            this.updnIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.2"), this.workingDirectory);
        }
        if (this.presenceIdx == null) {
            this.presenceIdx = new JdbmIndex();
            this.presenceIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.3");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.3", this.presenceIdx);
            this.presenceIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.3"), this.workingDirectory);
        }
        if (this.oneLevelIdx == null) {
            this.oneLevelIdx = new JdbmIndex();
            this.oneLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.4");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.4", this.oneLevelIdx);
            this.oneLevelIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.4"), this.workingDirectory);
        }
        if (this.oneAliasIdx == null) {
            this.oneAliasIdx = new JdbmIndex();
            this.oneAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.5");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.5", this.oneAliasIdx);
            this.oneAliasIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.5"), this.workingDirectory);
        }
        if (this.subAliasIdx == null) {
            this.subAliasIdx = new JdbmIndex();
            this.subAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.6");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.6", this.subAliasIdx);
            this.subAliasIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.6"), this.workingDirectory);
        }
        if (this.aliasIdx == null) {
            this.aliasIdx = new JdbmIndex();
            this.aliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.7", this.aliasIdx);
            this.aliasIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.7"), this.workingDirectory);
        }
        if (this.subLevelIdx == null) {
            this.subLevelIdx = new JdbmIndex();
            this.subLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.43");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.43", this.subLevelIdx);
            this.subLevelIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.43"), this.workingDirectory);
        }
        if (this.entryCsnIdx == null) {
            this.entryCsnIdx = new JdbmIndex();
            this.entryCsnIdx.setAttributeId("1.3.6.1.4.1.4203.666.1.7");
            this.systemIndices.put("1.3.6.1.4.1.4203.666.1.7", this.entryCsnIdx);
            this.entryCsnIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.4203.666.1.7"), this.workingDirectory);
        }
        if (this.entryUuidIdx == null) {
            this.entryUuidIdx = new JdbmIndex();
            this.entryUuidIdx.setAttributeId("1.3.6.1.1.16.4");
            this.systemIndices.put("1.3.6.1.1.16.4", this.entryUuidIdx);
            this.entryUuidIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.1.16.4"), this.workingDirectory);
        }
        if (this.objectClassIdx == null) {
            this.objectClassIdx = new JdbmIndex();
            this.objectClassIdx.setAttributeId("2.5.4.0");
            this.systemIndices.put("2.5.4.0", this.objectClassIdx);
            this.objectClassIdx.init(this.attributeTypeRegistry.lookup("2.5.4.0"), this.workingDirectory);
        }
    }

    private void setupUserIndices() throws Exception {
        if (this.userIndices != null && this.userIndices.size() > 0) {
            HashMap tmp = new HashMap();
            for (Index<?, E> index : this.userIndices.values()) {
                String oid = this.oidRegistry.getOid(index.getAttributeId());
                if (this.systemIndices.containsKey(oid)) continue;
                AttributeType attributeType = this.attributeTypeRegistry.lookup(oid);
                MatchingRule mr = attributeType.getEquality();
                if (mr != null) {
                    ((JdbmIndex)index).init(this.attributeTypeRegistry.lookup(oid), this.workingDirectory);
                    tmp.put(oid, index);
                    continue;
                }
                LOG.error("Cannot build an index for attribute '{}', no EQUALITY MatchingRule defined", (Object)attributeType.getName());
            }
            this.userIndices = tmp;
        } else {
            this.userIndices = new HashMap();
        }
    }

    public synchronized void destroy() throws Exception {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        ArrayList array = new ArrayList();
        array.addAll(this.userIndices.values());
        array.addAll(this.systemIndices.values());
        MultiException errors = new MultiException("Errors encountered on destroy()");
        for (Index index : array) {
            try {
                index.close();
                LOG.debug("Closed {} index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error("Failed to close an index.", t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close();
            LOG.debug("Closed master table for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error("Failed to close the master.", t);
            errors.addThrowable(t);
        }
        try {
            this.recMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error("Failed to close the record manager", t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw errors;
        }
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void sync() throws Exception {
        if (!this.initialized) {
            return;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.addAll(this.userIndices.values());
        array.add(this.ndnIdx);
        array.add(this.updnIdx);
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.oneLevelIdx);
        array.add(this.presenceIdx);
        array.add(this.subLevelIdx);
        array.add(this.entryCsnIdx);
        array.add(this.entryUuidIdx);
        array.add(this.objectClassIdx);
        for (Index index : array) {
            index.sync();
        }
        this.master.sync();
        this.recMan.commit();
    }

    private <K> JdbmIndex<K, E> convertIndex(Index<K, E> index) {
        if (index instanceof JdbmIndex) {
            return (JdbmIndex)index;
        }
        LOG.warn("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.", index);
        JdbmIndex jdbmIndex = new JdbmIndex(index.getAttributeId());
        jdbmIndex.setCacheSize(index.getCacheSize());
        jdbmIndex.setNumDupLimit(512);
        jdbmIndex.setWkDirPath(index.getWkDirPath());
        return jdbmIndex;
    }

    public void setUserIndices(Set<Index<?, E>> userIndices) {
        this.protect("userIndices");
        for (Index<?, E> index : userIndices) {
            this.userIndices.put(index.getAttributeId(), this.convertIndex(index));
        }
    }

    public Set<Index<?, E>> getUserIndices() {
        return new HashSet(this.userIndices.values());
    }

    public void addIndex(Index<?, E> index) throws Exception {
        this.userIndices.put(index.getAttributeId(), this.convertIndex(index));
    }

    public Index<String, E> getPresenceIndex() {
        return this.presenceIdx;
    }

    public void setPresenceIndex(Index<String, E> index) throws Exception {
        this.protect("presenceIndex");
        this.presenceIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.presenceIdx);
    }

    public Index<Long, E> getOneLevelIndex() {
        return this.oneLevelIdx;
    }

    public void setOneLevelIndex(Index<Long, E> index) throws Exception {
        this.protect("hierarchyIndex");
        this.oneLevelIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.oneLevelIdx);
    }

    public Index<String, E> getAliasIndex() {
        return this.aliasIdx;
    }

    public void setAliasIndex(Index<String, E> index) throws NamingException {
        this.protect("aliasIndex");
        this.aliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.aliasIdx);
    }

    public Index<Long, E> getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    public void setOneAliasIndex(Index<Long, E> index) throws NamingException {
        this.protect("oneAliasIndex");
        this.oneAliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.oneAliasIdx);
    }

    public Index<Long, E> getSubAliasIndex() {
        return this.subAliasIdx;
    }

    public void setSubAliasIndex(Index<Long, E> index) throws NamingException {
        this.protect("subAliasIndex");
        this.subAliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.subAliasIdx);
    }

    public Index<String, E> getUpdnIndex() {
        return this.updnIdx;
    }

    public void setUpdnIndex(Index<String, E> index) throws NamingException {
        this.protect("updnIndex");
        this.updnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.updnIdx);
    }

    public Index<String, E> getNdnIndex() {
        return this.ndnIdx;
    }

    public void setNdnIndex(Index<String, E> index) throws NamingException {
        this.protect("ndnIndex");
        this.ndnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.ndnIdx);
    }

    public Index<Long, E> getSubLevelIndex() {
        return this.subLevelIdx;
    }

    public void setSubLevelIndex(Index<Long, E> index) throws NamingException {
        this.protect("subLevelIndex");
        this.subLevelIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.subLevelIdx);
    }

    public Index<String, E> getObjectClassIndex() {
        return this.objectClassIdx;
    }

    public void setObjectClassIndex(Index<String, E> index) throws NamingException {
        this.protect("objectClassIndex");
        this.objectClassIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.objectClassIdx);
    }

    public Index<byte[], E> getEntryUuidIndex() {
        return this.entryUuidIdx;
    }

    public void setEntryUuidIndex(Index<byte[], E> index) throws NamingException {
        this.protect("entryUuidIndex");
        this.entryUuidIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.entryUuidIdx);
    }

    public Index<String, E> getEntryCsnIndex() {
        return this.entryCsnIdx;
    }

    public void setEntryCsnIndex(Index<String, E> index) throws NamingException {
        this.protect("entryCsnIndex");
        this.entryCsnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.entryCsnIdx);
    }

    public Iterator<String> userIndices() {
        return this.userIndices.keySet().iterator();
    }

    public Iterator<String> systemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    public boolean hasUserIndexOn(String id) throws NamingException {
        return this.userIndices.containsKey(this.oidRegistry.getOid(id));
    }

    public boolean hasSystemIndexOn(String id) throws NamingException {
        return this.systemIndices.containsKey(this.oidRegistry.getOid(id));
    }

    public Index<?, E> getUserIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            LOG.error("Failed to identify OID for: " + id, (Throwable)e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, (Throwable)e);
        }
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        throw new IndexNotFoundException("A user index on attribute " + id + " (" + this.name + ") does not exist!");
    }

    public Index<?, E> getSystemIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            LOG.error("Failed to identify OID for: " + id, (Throwable)e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, (Throwable)e);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException("A system index on attribute " + id + " (" + this.name + ") does not exist!");
    }

    public Long getEntryId(String dn) throws Exception {
        return this.ndnIdx.forwardLookup(dn);
    }

    public String getEntryDn(Long id) throws Exception {
        return this.ndnIdx.reverseLookup(id);
    }

    public Long getParentId(String dn) throws Exception {
        Long childId = this.ndnIdx.forwardLookup(dn);
        return this.oneLevelIdx.reverseLookup(childId);
    }

    public Long getParentId(Long childId) throws Exception {
        return this.oneLevelIdx.reverseLookup(childId);
    }

    public String getEntryUpdn(Long id) throws Exception {
        return this.updnIdx.reverseLookup(id);
    }

    public String getEntryUpdn(String dn) throws Exception {
        Long id = this.ndnIdx.forwardLookup(dn);
        return this.updnIdx.reverseLookup(id);
    }

    public int count() throws Exception {
        return this.master.count();
    }

    private void dropAliasIndices(Long aliasId) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN aliasDN = new LdapDN(aliasDn);
        LdapDN ancestorDn = (LdapDN)aliasDN.clone();
        ancestorDn.remove(aliasDN.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.toNormName());
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.normSuffix) && ancestorDn.size() > this.normSuffix.size()) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    private void addAliasIndices(Long aliasId, LdapDN aliasDn, String aliasTarget) throws Exception {
        LdapDN normalizedAliasTargetDn = new LdapDN(aliasTarget);
        normalizedAliasTargetDn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        if (aliasDn.startsWith((Name)normalizedAliasTargetDn)) {
            if (aliasDn.equals((Object)normalizedAliasTargetDn)) {
                String msg = "[36] aliasDereferencingProblem - attempt to create alias to itself.";
                ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
                LdapNamingException e = new LdapNamingException(msg, rc);
                e.setResolvedName((Name)aliasDn);
                throw e;
            }
            String msg = "[36] aliasDereferencingProblem - attempt to create alias with cycle to relative " + aliasTarget + " not allowed from descendent alias " + aliasDn;
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName((Name)aliasDn);
            throw e;
        }
        if (!normalizedAliasTargetDn.startsWith((Name)this.normSuffix)) {
            String msg = "[36] aliasDereferencingProblem -  the alias points to an entry outside of the " + this.upSuffix.getUpName() + " namingContext to an object whose existence cannot be determined.";
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName((Name)aliasDn);
            throw e;
        }
        Long targetId = this.ndnIdx.forwardLookup(normalizedAliasTargetDn.toNormName());
        if (null == targetId) {
            String msg = "[33] aliasProblem - the alias '" + aliasDn.getUpName() + "' when dereferenced would not name a known object." + "The aliased ObjectName '" + aliasTarget + "' must be set to a valid existing entry.";
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName((Name)aliasDn);
            throw e;
        }
        if (null != this.aliasIdx.reverseLookup(targetId)) {
            String msg = "[36] aliasDereferencingProblem -  the alias points to another alias.  Alias chaining is not supported by this backend.";
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName((Name)aliasDn);
            throw e;
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        LdapDN ancestorDn = (LdapDN)aliasDn.clone();
        ancestorDn.remove(aliasDn.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.toNormName());
        LdapDN normalizedAliasTargetParentDn = (LdapDN)normalizedAliasTargetDn.clone();
        normalizedAliasTargetParentDn.remove(normalizedAliasTargetDn.size() - 1);
        if (!aliasDn.startsWith((Name)normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals((Object)this.normSuffix) && null != ancestorId) {
            if (!NamespaceTools.isDescendant((Name)ancestorDn, (Name)normalizedAliasTargetDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn.remove(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
        }
    }

    public synchronized void add(ServerEntry entry) throws Exception {
        Long parentId;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        Long id = this.master.getNextId();
        LdapDN entryDn = entry.getDn();
        LdapDN parentDn = null;
        if (entryDn.getNormName().equals(this.normSuffix.getNormName())) {
            parentId = 0L;
        } else {
            parentDn = (LdapDN)entryDn.clone();
            parentDn.remove(parentDn.size() - 1);
            parentId = this.getEntryId(parentDn.toString());
        }
        if (parentId == null) {
            throw new LdapNameNotFoundException("Id for parent '" + parentDn + "' not found!");
        }
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass == null) {
            String msg = "Entry " + entryDn.getUpName() + " contains no objectClass attribute: " + entry;
            ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
            LdapSchemaViolationException e = new LdapSchemaViolationException(msg, rc);
            e.setResolvedName((Name)entryDn);
            throw e;
        }
        for (Value value : objectClass) {
            this.objectClassIdx.add(value.getString(), id);
        }
        if (objectClass.contains(new String[]{"alias"})) {
            EntryAttribute aliasAttr = entry.get(ALIASED_OBJECT_NAME_AT);
            this.addAliasIndices(id, entryDn, aliasAttr.getString());
        }
        if (!Character.isDigit(entryDn.toNormName().charAt(0))) {
            throw new IllegalStateException("Not a normalized name: " + entryDn.toNormName());
        }
        this.ndnIdx.add(entryDn.toNormName(), id);
        this.updnIdx.add(entryDn.getUpName(), id);
        this.oneLevelIdx.add(parentId, id);
        EntryAttribute entryCsn = entry.get(ENTRY_CSN_AT);
        if (entryCsn == null) {
            String msg = "Entry " + entryDn.getUpName() + " contains no entryCsn attribute: " + entry;
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        this.entryCsnIdx.add(entryCsn.getString(), id);
        EntryAttribute entryUuid = entry.get(ENTRY_UUID_AT);
        if (entryUuid == null) {
            String msg = "Entry " + entryDn.getUpName() + " contains no entryUuid attribute: " + entry;
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        this.entryUuidIdx.add(entryUuid.getBytes(), id);
        Long tempId = parentId;
        while (tempId != null && tempId != 0L && tempId != 1L) {
            this.subLevelIdx.add(tempId, id);
            tempId = this.getParentId(tempId);
        }
        this.subLevelIdx.add(id, id);
        for (EntryAttribute attribute : entry) {
            String attributeOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<?, E> idx = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                idx.add(value.get(), id);
            }
            this.presenceIdx.add(attributeOid, id);
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public ServerEntry lookup(Long id) throws Exception {
        return this.master.get(id);
    }

    public synchronized void delete(Long id) throws Exception {
        ServerEntry entry = this.lookup(id);
        Long parentId = this.getParentId(id);
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass.contains(new String[]{"alias"})) {
            this.dropAliasIndices(id);
        }
        for (Value value : objectClass) {
            this.objectClassIdx.drop(value.getString(), id);
        }
        this.ndnIdx.drop(id);
        this.updnIdx.drop(id);
        this.oneLevelIdx.drop(id);
        this.entryCsnIdx.drop(id);
        this.entryUuidIdx.drop(id);
        if (id != 1L) {
            this.subLevelIdx.drop(id);
        }
        if (!parentId.equals(0L)) {
            this.oneLevelIdx.drop(parentId, id);
        }
        for (EntryAttribute attribute : entry) {
            String attributeOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<?, E> index = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                ((JdbmIndex)index).drop(value.get(), id);
            }
            this.presenceIdx.drop(attributeOid, id);
        }
        this.master.delete(id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public IndexCursor<Long, E> list(Long id) throws Exception {
        IndexCursor<Long, E> cursor = this.oneLevelIdx.forwardCursor(id);
        cursor.beforeValue(id, null);
        return cursor;
    }

    public int getChildCount(Long id) throws Exception {
        return this.oneLevelIdx.count(id);
    }

    public LdapDN getSuffix() {
        return this.normSuffix;
    }

    public LdapDN getUpSuffix() {
        return this.upSuffix;
    }

    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.master.setProperty(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) throws Exception {
        return this.master.getProperty(propertyName);
    }

    private void add(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        String modsOid = this.oidRegistry.getOid(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.drop(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<?, E> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((JdbmIndex)index).add(value.get(), id);
            }
            if (!this.presenceIdx.forward(modsOid, id)) {
                this.presenceIdx.add(modsOid, id);
            }
        }
        AttributeType type = this.attributeTypeRegistry.lookup(modsOid);
        for (Value value : mods) {
            entry.add(type, new Value[]{value});
        }
        if (modsOid.equals("2.5.4.1")) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new LdapDN(ndnStr), mods.getString());
        }
    }

    private void remove(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        String modsOid = this.oidRegistry.getOid(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.drop(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<?, E> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((JdbmIndex)index).drop(value.get(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.attributeTypeRegistry.lookup(modsOid);
        if (mods.size() == 0) {
            entry.removeAttributes(new AttributeType[]{attrType});
        } else {
            EntryAttribute entryAttr = entry.get(attrType);
            for (Value value : mods) {
                entryAttr.remove(new Value[]{value});
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(new String[]{entryAttr.getId()});
            }
        }
        if (modsOid.equals("2.5.4.1")) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        String aliasAttributeOid;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        String modsOid = this.oidRegistry.getOid(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            if (this.objectClassIdx.reverse(id)) {
                this.objectClassIdx.drop(id);
            }
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<?, E> index = this.getUserIndex(modsOid);
            if (index.reverse(id)) {
                ((JdbmIndex)index).drop(id);
            }
            for (Value value : mods) {
                ((JdbmIndex)index).add(value.get(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        if (modsOid.equals(aliasAttributeOid = this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(new EntryAttribute[]{mods});
        } else {
            entry.remove(new EntryAttribute[]{mods});
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new LdapDN(ndnStr), mods.getString());
        }
    }

    public void modify(LdapDN dn, ModificationOperation modOp, ServerEntry mods) throws Exception {
        if (mods instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        Long id = this.getEntryId(dn.toString());
        ServerEntry entry = this.master.get(id);
        block5: for (AttributeType attributeType : mods.getAttributeTypes()) {
            EntryAttribute attr = mods.get(attributeType);
            switch (modOp) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attr);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attr);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attr);
                    continue block5;
                }
            }
            throw new NamingException("Unidentified modification operation");
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public void modify(LdapDN dn, List<Modification> mods) throws Exception {
        Long id = this.getEntryId(dn.toString());
        ServerEntry entry = this.master.get(id);
        block5: for (Modification mod : mods) {
            ServerAttribute attrMods = (ServerAttribute)mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, (EntryAttribute)attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, (EntryAttribute)attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, (EntryAttribute)attrMods);
                    continue block5;
                }
            }
            throw new NamingException("Unidentified modification operation");
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        Index<?, E> index;
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = this.lookup(id);
        LdapDN updn = entry.getDn();
        for (AttributeTypeAndValue newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            String newNormValue = newAtav.getNormValue().getString();
            AttributeType newRdnAttrType = this.attributeTypeRegistry.lookup(newNormType);
            Object unEscapedRdn = Rdn.unescapeValue((String)newAtav.getUpValue().getString());
            Object value = null;
            value = unEscapedRdn instanceof String ? new ServerStringValue(newRdnAttrType, (String)unEscapedRdn) : new ServerBinaryValue(newRdnAttrType, (byte[])unEscapedRdn);
            value.normalize();
            entry.add(newRdnAttrType, new Value[]{value});
            if (!this.hasUserIndexOn(newNormType)) continue;
            index = this.getUserIndex(newNormType);
            ((JdbmIndex)index).add(newNormValue, id);
            if (this.presenceIdx.forward(newNormType, id)) continue;
            this.presenceIdx.add(newNormType, id);
        }
        if (deleteOldRdn) {
            Rdn oldRdn = updn.getRdn();
            for (AttributeTypeAndValue oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (AttributeTypeAndValue newAtav : newRdn) {
                    if (!oldAtav.equals((Object)newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getNormValue().getString();
                AttributeType oldRdnAttrType = this.attributeTypeRegistry.lookup(oldNormType);
                entry.remove(oldRdnAttrType, new String[]{oldNormValue});
                if (!this.hasUserIndexOn(oldNormType)) continue;
                index = this.getUserIndex(oldNormType);
                ((JdbmIndex)index).drop(oldNormValue, id);
                if (null != index.reverseLookup(id)) continue;
                this.presenceIdx.drop(oldNormType, id);
            }
        }
        LdapDN newUpdn = (LdapDN)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newRdn.getUpName());
        newUpdn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        this.modifyDn(id, newUpdn, false);
        entry.setDn(newUpdn);
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private void modifyDn(Long id, LdapDN updn, boolean isMove) throws Exception {
        String aliasTarget;
        this.ndnIdx.drop(id);
        if (!updn.isNormalized()) {
            updn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        }
        this.ndnIdx.add(updn.toNormName(), id);
        this.updnIdx.drop(id);
        this.updnIdx.add(updn.getUpName(), id);
        if (isMove && null != (aliasTarget = this.aliasIdx.reverseLookup(id))) {
            this.addAliasIndices(id, new LdapDN(this.getEntryDn(id)), aliasTarget);
        }
        IndexCursor<Long, E> children = this.list(id);
        while (children.next()) {
            IndexEntry rec = (IndexEntry)children.get();
            Long childId = rec.getId();
            LdapDN childUpdn = (LdapDN)updn.clone();
            LdapDN oldUpdn = new LdapDN(this.getEntryUpdn(childId));
            String rdn = oldUpdn.get(oldUpdn.size() - 1);
            LdapDN rdnDN = new LdapDN(rdn);
            rdnDN.normalize(this.attributeTypeRegistry.getNormalizerMapping());
            childUpdn.add(rdnDN.getRdn());
            ServerEntry entry = this.lookup(childId);
            entry.setDn(childUpdn);
            this.master.put(childId, entry);
            this.modifyDn(childId, childUpdn, isMove);
        }
        children.close();
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.toString());
        this.rename(oldChildDn, newRdn, deleteOldRdn);
        LdapDN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.toString());
        LdapDN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private LdapDN move(LdapDN oldChildDn, Long childId, LdapDN newParentDn) throws Exception {
        Long newParentId = this.getEntryId(newParentDn.toString());
        Long oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.oneLevelIdx.drop(oldParentId, childId);
        this.oneLevelIdx.add(newParentId, childId);
        this.updateSubLevelIndex(childId, oldParentId, newParentId);
        LdapDN childUpdn = new LdapDN(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        LdapDN newUpdn = new LdapDN(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, newUpdn, true);
        return newUpdn;
    }

    private void updateSubLevelIndex(Long childId, Long oldParentId, Long newParentId) throws Exception {
        Long tempId = oldParentId;
        ArrayList<Long> parentIds = new ArrayList<Long>();
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        IndexCursor<Long, E> cursor = this.subLevelIdx.forwardCursor(childId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.add(childId);
        while (cursor.next()) {
            childIds.add(((IndexEntry)cursor.get()).getId());
        }
        for (Long pid : parentIds) {
            for (Long cid : childIds) {
                this.subLevelIdx.drop(pid, cid);
            }
        }
        parentIds.clear();
        tempId = newParentId;
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        for (Long id : parentIds) {
            for (Long cid : childIds) {
                this.subLevelIdx.add(id, cid);
            }
        }
    }

    private void dropMovedAliasIndices(LdapDN movedBase) throws Exception {
        Long movedBaseId = this.getEntryId(movedBase.toString());
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    private void dropAliasIndices(Long aliasId, LdapDN movedBase) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)movedBase.getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.toString());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.upSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    public void initRegistries(Registries registries) {
        this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        this.oidRegistry = registries.getOidRegistry();
    }
}

