/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Timer;
import org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class FilesystemMetadataProvider
extends AbstractReloadingMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(FilesystemMetadataProvider.class);
    private File metadataFile;

    public FilesystemMetadataProvider(File metadata) throws MetadataProviderException {
        this.setMetadataFile(metadata);
    }

    public FilesystemMetadataProvider(Timer backgroundTaskTimer, File metadata) throws MetadataProviderException {
        super(backgroundTaskTimer);
        this.setMetadataFile(metadata);
    }

    protected void setMetadataFile(File file) throws MetadataProviderException {
        if (!file.exists()) {
            throw new MetadataProviderException("Give metadata file, " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isFile()) {
            throw new MetadataProviderException("Give metadata file, " + file.getAbsolutePath() + " is not a file");
        }
        if (!file.canRead()) {
            throw new MetadataProviderException("Give metadata file, " + file.getAbsolutePath() + " is not readable");
        }
        this.metadataFile = file;
    }

    public boolean maintainExpiredMetadata() {
        return !this.requireValidMetadata();
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.setRequireValidMetadata(!maintain);
    }

    protected String getMetadataIdentifier() {
        return this.metadataFile.getAbsolutePath();
    }

    protected byte[] fetchMetadata() throws MetadataProviderException {
        try {
            return this.inputstreamToByteArray(new FileInputStream(this.metadataFile));
        }
        catch (IOException e) {
            String errMsg = MessageFormatter.format((String)"Unable to read metadata file '{}'", (Object)this.metadataFile.getAbsolutePath());
            this.log.error(errMsg, (Throwable)e);
            throw new MetadataProviderException(errMsg, e);
        }
    }
}

