/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.subtree.Subentry;
import org.apache.directory.server.core.subtree.SubentryCache;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.control.SubentriesControl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubentryInterceptor
extends BaseInterceptor {
    private static final String SUBENTRY_CONTROL = "1.3.6.1.4.1.4203.1.10.1";
    public static final String AC_AREA = "accessControlSpecificArea";
    public static final String AC_INNERAREA = "accessControlInnerArea";
    public static final String SCHEMA_AREA = "subschemaAdminSpecificArea";
    public static final String COLLECTIVE_AREA = "collectiveAttributeSpecificArea";
    public static final String COLLECTIVE_INNERAREA = "collectiveAttributeInnerArea";
    public static final String TRIGGER_AREA = "triggerExecutionSpecificArea";
    public static final String TRIGGER_INNERAREA = "triggerExecutionInnerArea";
    public static final String[] SUBENTRY_OPATTRS = new String[]{"accessControlSubentries", "subschemaSubentry", "collectiveAttributeSubentries", "triggerExecutionSubentries"};
    private static final Logger LOG = LoggerFactory.getLogger(SubentryInterceptor.class);
    private final SubentryCache subentryCache = new SubentryCache();
    private SubtreeSpecificationParser ssParser;
    private SubtreeEvaluator evaluator;
    private PartitionNexus nexus;
    private Registries registries;
    private AttributeTypeRegistry atRegistry;
    private OidRegistry oidRegistry;
    private AttributeType objectClassType;

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.registries = directoryService.getRegistries();
        this.atRegistry = this.registries.getAttributeTypeRegistry();
        this.oidRegistry = this.registries.getOidRegistry();
        this.objectClassType = this.atRegistry.lookup(this.oidRegistry.getOid("objectClass"));
        this.ssParser = new SubtreeSpecificationParser(new NormalizerMappingResolver(){

            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return SubentryInterceptor.this.atRegistry.getNormalizerMapping();
            }
        }, this.atRegistry.getNormalizerMapping());
        this.evaluator = new SubtreeEvaluator(this.oidRegistry, this.atRegistry);
        Set<String> suffixes = this.nexus.listSuffixes(null);
        EqualityNode filter = new EqualityNode("objectClass", (Value)new ClientStringValue("subentry"));
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningAttributes(new String[]{"subtreeSpecification", "objectClass"});
        for (String suffix : suffixes) {
            LdapDN suffixDn = new LdapDN(suffix);
            suffixDn.normalize(this.atRegistry.getNormalizerMapping());
            LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            adminDn.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
            DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(adminSession, suffixDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                SubtreeSpecification ss;
                ServerEntry subentry = (ServerEntry)subentries.get();
                LdapDN dnName = subentry.getDn();
                String subtree = subentry.get("subtreeSpecification").getString();
                try {
                    ss = this.ssParser.parse(subtree);
                }
                catch (Exception e) {
                    LOG.warn("Failed while parsing subtreeSpecification for " + dnName);
                    continue;
                }
                dnName.normalize(this.atRegistry.getNormalizerMapping());
                this.subentryCache.setSubentry(dnName.toString(), ss, this.getSubentryTypes(subentry));
            }
        }
    }

    private int getSubentryTypes(ServerEntry subentry) throws Exception {
        int types = 0;
        EntryAttribute oc = subentry.get("objectClass");
        if (oc == null) {
            throw new LdapSchemaViolationException("A subentry must have an objectClass attribute", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        if (oc.contains(new String[]{"accessControlSubentry"})) {
            types |= 4;
        }
        if (oc.contains(new String[]{"subschema"})) {
            types |= 2;
        }
        if (oc.contains(new String[]{"collectiveAttributeSubentry"})) {
            types |= 1;
        }
        if (oc.contains(new String[]{"triggerExecutionSubentry"})) {
            types |= 8;
        }
        return types;
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        if (!this.isSubentryVisible(opContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        }
        return cursor;
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        if (opContext.getScope() == SearchScope.OBJECT) {
            return cursor;
        }
        if (!this.isSubentryVisible(opContext)) {
            cursor.addEntryFilter(new HideSubentriesFilter());
        } else {
            cursor.addEntryFilter(new HideEntriesFilter());
        }
        return cursor;
    }

    private boolean isSubentryVisible(OperationContext opContext) throws Exception {
        if (!opContext.hasRequestControls()) {
            return false;
        }
        if (opContext.hasRequestControl(SUBENTRY_CONTROL)) {
            SubentriesControl subentriesControl = (SubentriesControl)opContext.getRequestControl(SUBENTRY_CONTROL);
            return subentriesControl.isVisible();
        }
        return false;
    }

    public ServerEntry getSubentryAttributes(LdapDN dn, ServerEntry entryAttrs) throws Exception {
        DefaultServerEntry subentryAttrs = new DefaultServerEntry(this.registries, dn);
        Iterator<String> list = this.subentryCache.nameIterator();
        while (list.hasNext()) {
            EntryAttribute operational;
            String subentryDnStr = list.next();
            LdapDN subentryDn = new LdapDN(subentryDnStr);
            LdapDN apDn = (LdapDN)subentryDn.clone();
            apDn.remove(apDn.size() - 1);
            Subentry subentry = this.subentryCache.getSubentry(subentryDnStr);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            if (!this.evaluator.evaluate(ss, (Name)apDn, (Name)dn, entryAttrs)) continue;
            if (subentry.isAccessControlSubentry()) {
                operational = subentryAttrs.get("accessControlSubentries");
                if (operational == null) {
                    operational = new DefaultServerAttribute("accessControlSubentries", this.atRegistry.lookup("accessControlSubentries"));
                    subentryAttrs.put(new EntryAttribute[]{operational});
                }
                operational.add(new String[]{subentryDn.toString()});
            }
            if (subentry.isSchemaSubentry()) {
                operational = subentryAttrs.get("subschemaSubentry");
                if (operational == null) {
                    operational = new DefaultServerAttribute("subschemaSubentry", this.atRegistry.lookup("subschemaSubentry"));
                    subentryAttrs.put(new EntryAttribute[]{operational});
                }
                operational.add(new String[]{subentryDn.toString()});
            }
            if (subentry.isCollectiveSubentry()) {
                operational = subentryAttrs.get("collectiveAttributeSubentries");
                if (operational == null) {
                    operational = new DefaultServerAttribute("collectiveAttributeSubentries", this.atRegistry.lookup("collectiveAttributeSubentries"));
                    subentryAttrs.put(new EntryAttribute[]{operational});
                }
                operational.add(new String[]{subentryDn.toString()});
            }
            if (!subentry.isTriggerSubentry()) continue;
            operational = subentryAttrs.get("triggerExecutionSubentries");
            if (operational == null) {
                operational = new DefaultServerAttribute("triggerExecutionSubentries", this.atRegistry.lookup("triggerExecutionSubentries"));
                subentryAttrs.put(new EntryAttribute[]{operational});
            }
            operational.add(new String[]{subentryDn.toString()});
        }
        return subentryAttrs;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        LdapDN name = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        EntryAttribute objectClasses = entry.get("objectClass");
        if (objectClasses.contains(new String[]{"subentry"})) {
            SubtreeSpecification ss;
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(name.size() - 1);
            ClonedServerEntry ap = addContext.lookup(apName, ByPassConstants.LOOKUP_BYPASS);
            EntryAttribute administrativeRole = ap.get("administrativeRole");
            if (administrativeRole == null || administrativeRole.size() <= 0) {
                throw new LdapNoSuchAttributeException("Administration point " + apName + " does not contain an administrativeRole attribute! An" + " administrativeRole attribute in the administrative point is" + " required to add a subordinate subentry.");
            }
            Subentry subentry = new Subentry();
            subentry.setTypes(this.getSubentryTypes((ServerEntry)entry));
            ServerEntry operational = this.getSubentryOperatationalAttributes(name, subentry);
            String subtree = entry.get("subtreeSpecification").getString();
            try {
                ss = this.ssParser.parse(subtree);
            }
            catch (Exception e) {
                String msg = "Failed while parsing subtreeSpecification for " + name.getUpName();
                LOG.warn(msg);
                throw new LdapInvalidAttributeValueException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            }
            this.subentryCache.setSubentry(name.getNormName(), ss, this.getSubentryTypes((ServerEntry)entry));
            next.add(addContext);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            PresenceNode filter = new PresenceNode("2.5.4.0");
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(addContext.getSession(), baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = candidate.getDn();
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(addContext.getSession(), dn, this.getOperationalModsForAdd(candidate, operational)));
            }
            addContext.setEntry(entry);
        } else {
            Iterator<String> list = this.subentryCache.nameIterator();
            while (list.hasNext()) {
                EntryAttribute operational;
                String subentryDnStr = list.next();
                LdapDN subentryDn = new LdapDN(subentryDnStr);
                LdapDN apDn = (LdapDN)subentryDn.clone();
                apDn.remove(apDn.size() - 1);
                Subentry subentry = this.subentryCache.getSubentry(subentryDnStr);
                SubtreeSpecification ss = subentry.getSubtreeSpecification();
                if (!this.evaluator.evaluate(ss, (Name)apDn, (Name)name, (ServerEntry)entry)) continue;
                if (subentry.isAccessControlSubentry()) {
                    operational = entry.get("accessControlSubentries");
                    if (operational == null) {
                        operational = new DefaultServerAttribute(this.atRegistry.lookup("accessControlSubentries"));
                        entry.put(new EntryAttribute[]{operational});
                    }
                    operational.add(new String[]{subentryDn.toString()});
                }
                if (subentry.isSchemaSubentry()) {
                    operational = entry.get("subschemaSubentry");
                    if (operational == null) {
                        operational = new DefaultServerAttribute(this.atRegistry.lookup("subschemaSubentry"));
                        entry.put(new EntryAttribute[]{operational});
                    }
                    operational.add(new String[]{subentryDn.toString()});
                }
                if (subentry.isCollectiveSubentry()) {
                    operational = entry.get("collectiveAttributeSubentries");
                    if (operational == null) {
                        operational = new DefaultServerAttribute(this.atRegistry.lookup("collectiveAttributeSubentries"));
                        entry.put(new EntryAttribute[]{operational});
                    }
                    operational.add(new String[]{subentryDn.toString()});
                }
                if (!subentry.isTriggerSubentry()) continue;
                operational = entry.get("triggerExecutionSubentries");
                if (operational == null) {
                    operational = new DefaultServerAttribute(this.atRegistry.lookup("triggerExecutionSubentries"));
                    entry.put(new EntryAttribute[]{operational});
                }
                operational.add(new String[]{subentryDn.toString()});
            }
            addContext.setEntry(entry);
            next.add(addContext);
        }
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        if (objectClasses.contains(new String[]{"subentry"})) {
            SubtreeSpecification ss = this.subentryCache.removeSubentry(name.toNormName()).getSubtreeSpecification();
            next.delete(opContext);
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(name.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(opContext.getSession(), baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = new LdapDN((Name)candidate.getDn());
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForRemove(name, candidate)));
            }
        } else {
            next.delete(opContext);
        }
    }

    private boolean hasAdministrativeDescendant(OperationContext opContext, LdapDN name) throws Exception {
        PresenceNode filter = new PresenceNode("administrativeRole");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        EntryFilteringCursor aps = this.nexus.search(new SearchOperationContext(opContext.getSession(), name, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
        if (aps.next()) {
            aps.close();
            return true;
        }
        return false;
    }

    private List<Modification> getModsOnEntryRdnChange(Name oldName, Name newName, ServerEntry entry) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        Iterator<String> subentries = this.subentryCache.nameIterator();
        while (subentries.hasNext()) {
            EntryAttribute opAttr;
            ModificationOperation op;
            boolean isNewNameSelected;
            String subentryDn = subentries.next();
            LdapDN apDn = new LdapDN(subentryDn);
            apDn.remove(apDn.size() - 1);
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldNameSelected = this.evaluator.evaluate(ss, (Name)apDn, oldName, entry);
            if (isOldNameSelected == (isNewNameSelected = this.evaluator.evaluate(ss, (Name)apDn, newName, entry))) continue;
            if (isOldNameSelected && !isNewNameSelected) {
                for (String aSUBENTRY_OPATTRS : SUBENTRY_OPATTRS) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    opAttr = entry.get(aSUBENTRY_OPATTRS);
                    if (opAttr == null) continue;
                    opAttr = (ServerAttribute)opAttr.clone();
                    opAttr.remove(new String[]{subentryDn});
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modList.add((Modification)new ServerModification(op, opAttr));
                }
                continue;
            }
            if (!isNewNameSelected || isOldNameSelected) continue;
            for (String aSUBENTRY_OPATTRS : SUBENTRY_OPATTRS) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                opAttr = new DefaultServerAttribute(aSUBENTRY_OPATTRS, this.atRegistry.lookup(aSUBENTRY_OPATTRS));
                opAttr.add(new String[]{subentryDn});
                modList.add((Modification)new ServerModification(op, opAttr));
            }
        }
        return modList;
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        if (objectClasses.contains(new String[]{"subentry"})) {
            Subentry subentry = this.subentryCache.getSubentry(name.toNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(apName.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            LdapDN newName = (LdapDN)name.clone();
            newName.remove(newName.size() - 1);
            newName.add(opContext.getNewRdn());
            String newNormName = newName.toNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.rename(opContext);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(opContext.getSession(), baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = candidate.getDn();
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForReplace((Name)name, (Name)newName, subentry, candidate)));
            }
        } else {
            if (this.hasAdministrativeDescendant(opContext, name)) {
                String msg = "Will not allow rename operation on entries with administrative descendants.";
                LOG.warn(msg);
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
            }
            next.rename(opContext);
            LdapDN newName = (LdapDN)name.clone();
            newName.remove(newName.size() - 1);
            newName.add(opContext.getNewRdn());
            newName.normalize(this.atRegistry.getNormalizerMapping());
            List<Modification> mods = this.getModsOnEntryRdnChange((Name)name, (Name)newName, (ServerEntry)entry);
            if (mods.size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), newName, mods));
            }
        }
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        LdapDN parent = opContext.getParent();
        ClonedServerEntry entry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        if (objectClasses.contains(new String[]{"subentry"})) {
            Subentry subentry = this.subentryCache.getSubentry(oriChildName.toNormName());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            LdapDN apName = (LdapDN)oriChildName.clone();
            apName.remove(apName.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            LdapDN newName = (LdapDN)parent.clone();
            newName.remove(newName.size() - 1);
            newName.add(opContext.getNewRdn());
            String newNormName = newName.toNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.moveAndRename(opContext);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(opContext.getSession(), baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = candidate.getDn();
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForReplace((Name)oriChildName, (Name)newName, subentry, candidate)));
            }
        } else {
            if (this.hasAdministrativeDescendant(opContext, oriChildName)) {
                String msg = "Will not allow rename operation on entries with administrative descendants.";
                LOG.warn(msg);
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
            }
            next.moveAndRename(opContext);
            LdapDN newName = (LdapDN)parent.clone();
            newName.add(opContext.getNewRdn());
            newName.normalize(this.atRegistry.getNormalizerMapping());
            List<Modification> mods = this.getModsOnEntryRdnChange((Name)oriChildName, (Name)newName, (ServerEntry)entry);
            if (mods.size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), newName, mods));
            }
        }
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        LdapDN newParentName = opContext.getParent();
        ClonedServerEntry entry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        EntryAttribute objectClasses = entry.get("objectClass");
        if (objectClasses.contains(new String[]{"subentry"})) {
            Subentry subentry = this.subentryCache.getSubentry(oriChildName.toString());
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            LdapDN apName = (LdapDN)oriChildName.clone();
            apName.remove(apName.size() - 1);
            LdapDN baseDn = (LdapDN)apName.clone();
            baseDn.addAll((Name)ss.getBase());
            LdapDN newName = (LdapDN)newParentName.clone();
            newName.remove(newName.size() - 1);
            newName.add(newParentName.get(newParentName.size() - 1));
            String newNormName = newName.toNormName();
            this.subentryCache.setSubentry(newNormName, ss, subentry.getTypes());
            next.move(opContext);
            subentry = this.subentryCache.getSubentry(newNormName);
            PresenceNode filter = new PresenceNode("objectClass");
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(opContext.getSession(), baseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = candidate.getDn();
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ss, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForReplace((Name)oriChildName, (Name)newName, subentry, candidate)));
            }
        } else {
            if (this.hasAdministrativeDescendant(opContext, oriChildName)) {
                String msg = "Will not allow rename operation on entries with administrative descendants.";
                LOG.warn(msg);
                throw new LdapSchemaViolationException(msg, ResultCodeEnum.NOT_ALLOWED_ON_RDN);
            }
            next.move(opContext);
            LdapDN newName = (LdapDN)newParentName.clone();
            newName.add(oriChildName.get(oriChildName.size() - 1));
            List<Modification> mods = this.getModsOnEntryRdnChange((Name)oriChildName, (Name)newName, (ServerEntry)entry);
            if (mods.size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), newName, mods));
            }
        }
    }

    private int getSubentryTypes(ServerEntry entry, List<Modification> mods) throws Exception {
        ServerAttribute ocFinalState = (ServerAttribute)entry.get("objectClass").clone();
        block5: for (Modification mod : mods) {
            if (!mod.getAttribute().getId().equalsIgnoreCase("objectClass")) continue;
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    for (Value value : (ServerAttribute)mod.getAttribute()) {
                        ocFinalState.add(new String[]{value.getString()});
                    }
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    for (Value value : (ServerAttribute)mod.getAttribute()) {
                        ocFinalState.remove(new String[]{value.getString()});
                    }
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    ocFinalState = (ServerAttribute)mod.getAttribute();
                }
            }
        }
        DefaultServerEntry attrs = new DefaultServerEntry(this.registries, LdapDN.EMPTY_LDAPDN);
        attrs.put(new EntryAttribute[]{ocFinalState});
        return this.getSubentryTypes((ServerEntry)attrs);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        LdapDN name = opContext.getDn();
        List<Modification> mods = opContext.getModItems();
        ClonedServerEntry entry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        ServerEntry oldEntry = (ServerEntry)entry.clone();
        EntryAttribute objectClasses = entry.get(this.objectClassType);
        boolean isSubtreeSpecificationModification = false;
        Modification subtreeMod = null;
        for (Modification mod : mods) {
            if (!"subtreeSpecification".equalsIgnoreCase(mod.getAttribute().getId())) continue;
            isSubtreeSpecificationModification = true;
            subtreeMod = mod;
        }
        if (objectClasses.contains(new String[]{"subentry"}) && isSubtreeSpecificationModification) {
            SubtreeSpecification ssNew;
            SubtreeSpecification ssOld = this.subentryCache.removeSubentry(name.toString()).getSubtreeSpecification();
            try {
                ssNew = this.ssParser.parse(((ServerAttribute)subtreeMod.getAttribute()).getString());
            }
            catch (Exception e) {
                String msg = "failed to parse the new subtreeSpecification";
                LOG.error(msg, (Throwable)e);
                throw new LdapInvalidAttributeValueException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            }
            this.subentryCache.setSubentry(name.toNormName(), ssNew, this.getSubentryTypes((ServerEntry)entry, mods));
            next.modify(opContext);
            LdapDN apName = (LdapDN)name.clone();
            apName.remove(apName.size() - 1);
            LdapDN oldBaseDn = (LdapDN)apName.clone();
            oldBaseDn.addAll((Name)ssOld.getBase());
            PresenceNode filter = new PresenceNode(this.oidRegistry.getOid("objectClass"));
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(new String[]{"+", "*"});
            EntryFilteringCursor subentries = this.nexus.search(new SearchOperationContext(opContext.getSession(), oldBaseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = candidate.getDn();
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssOld, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForRemove(name, candidate)));
            }
            Subentry subentry = this.subentryCache.getSubentry(name.toNormName());
            ServerEntry operational = this.getSubentryOperatationalAttributes(name, subentry);
            LdapDN newBaseDn = (LdapDN)apName.clone();
            newBaseDn.addAll((Name)ssNew.getBase());
            subentries = this.nexus.search(new SearchOperationContext(opContext.getSession(), newBaseDn, AliasDerefMode.NEVER_DEREF_ALIASES, (ExprNode)filter, controls));
            while (subentries.next()) {
                ServerEntry candidate = (ServerEntry)subentries.get();
                LdapDN dn = candidate.getDn();
                dn.normalize(this.atRegistry.getNormalizerMapping());
                if (!this.evaluator.evaluate(ssNew, (Name)apName, (Name)dn, candidate)) continue;
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), dn, this.getOperationalModsForAdd(candidate, operational)));
            }
        } else {
            ClonedServerEntry newEntry;
            List<Modification> subentriesOpAttrMods;
            next.modify(opContext);
            if (!objectClasses.contains(new String[]{"subentry"}) && (subentriesOpAttrMods = this.getModsOnEntryModification(name, oldEntry, (ServerEntry)(newEntry = opContext.lookup(name, ByPassConstants.LOOKUP_BYPASS)))).size() > 0) {
                this.nexus.modify(new ModifyOperationContext(opContext.getSession(), name, subentriesOpAttrMods));
            }
        }
    }

    private List<Modification> getOperationalModsForReplace(Name oldName, Name newName, Subentry subentry, ServerEntry entry) throws Exception {
        ServerAttribute operational;
        ArrayList<Modification> modList = new ArrayList<Modification>();
        if (subentry.isAccessControlSubentry()) {
            operational = (ServerAttribute)entry.get("accessControlSubentries").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("accessControlSubentries", this.atRegistry.lookup("accessControlSubentries"));
                operational.add(new String[]{newName.toString()});
            } else {
                operational.remove(new String[]{oldName.toString()});
                operational.add(new String[]{newName.toString()});
            }
            modList.add((Modification)new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)operational));
        }
        if (subentry.isSchemaSubentry()) {
            operational = (ServerAttribute)entry.get("subschemaSubentry").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("subschemaSubentry", this.atRegistry.lookup("subschemaSubentry"));
                operational.add(new String[]{newName.toString()});
            } else {
                operational.remove(new String[]{oldName.toString()});
                operational.add(new String[]{newName.toString()});
            }
            modList.add((Modification)new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)operational));
        }
        if (subentry.isCollectiveSubentry()) {
            operational = (ServerAttribute)entry.get("collectiveAttributeSubentries").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("collectiveAttributeSubentries", this.atRegistry.lookup("collectiveAttributeSubentries"));
                operational.add(new String[]{newName.toString()});
            } else {
                operational.remove(new String[]{oldName.toString()});
                operational.add(new String[]{newName.toString()});
            }
            modList.add((Modification)new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)operational));
        }
        if (subentry.isTriggerSubentry()) {
            operational = (ServerAttribute)entry.get("triggerExecutionSubentries").clone();
            if (operational == null) {
                operational = new DefaultServerAttribute("triggerExecutionSubentries", this.atRegistry.lookup("triggerExecutionSubentries"));
                operational.add(new String[]{newName.toString()});
            } else {
                operational.remove(new String[]{oldName.toString()});
                operational.add(new String[]{newName.toString()});
            }
            modList.add((Modification)new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)operational));
        }
        return modList;
    }

    private ServerEntry getSubentryOperatationalAttributes(LdapDN name, Subentry subentry) throws Exception {
        DefaultServerEntry operational = new DefaultServerEntry(this.registries, name);
        if (subentry.isAccessControlSubentry()) {
            if (operational.get("accessControlSubentries") == null) {
                operational.put("accessControlSubentries", new String[]{name.toString()});
            } else {
                operational.get("accessControlSubentries").add(new String[]{name.toString()});
            }
        }
        if (subentry.isSchemaSubentry()) {
            if (operational.get("subschemaSubentry") == null) {
                operational.put("subschemaSubentry", new String[]{name.toString()});
            } else {
                operational.get("subschemaSubentry").add(new String[]{name.toString()});
            }
        }
        if (subentry.isCollectiveSubentry()) {
            if (operational.get("collectiveAttributeSubentries") == null) {
                operational.put("collectiveAttributeSubentries", new String[]{name.toString()});
            } else {
                operational.get("collectiveAttributeSubentries").add(new String[]{name.toString()});
            }
        }
        if (subentry.isTriggerSubentry()) {
            if (operational.get("triggerExecutionSubentries") == null) {
                operational.put("triggerExecutionSubentries", new String[]{name.toString()});
            } else {
                operational.get("triggerExecutionSubentries").add(new String[]{name.toString()});
            }
        }
        return operational;
    }

    private List<Modification> getOperationalModsForRemove(LdapDN subentryDn, ServerEntry candidate) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        String dn = subentryDn.toNormName();
        for (String opAttrId : SUBENTRY_OPATTRS) {
            EntryAttribute opAttr = candidate.get(opAttrId);
            if (opAttr == null || !opAttr.contains(new String[]{dn})) continue;
            AttributeType attributeType = this.atRegistry.lookup(opAttrId);
            DefaultServerAttribute attr = new DefaultServerAttribute(opAttrId, attributeType, new String[]{dn});
            modList.add((Modification)new ServerModification(ModificationOperation.REMOVE_ATTRIBUTE, (EntryAttribute)attr));
        }
        return modList;
    }

    public List<Modification> getOperationalModsForAdd(ServerEntry entry, ServerEntry operational) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        for (AttributeType attributeType : operational.getAttributeTypes()) {
            ModificationOperation op = ModificationOperation.REPLACE_ATTRIBUTE;
            DefaultServerAttribute result = new DefaultServerAttribute(attributeType);
            EntryAttribute opAttrAdditions = operational.get(attributeType);
            EntryAttribute opAttrInEntry = entry.get(attributeType);
            for (Value value : opAttrAdditions) {
                result.add(new Value[]{value});
            }
            if (opAttrInEntry != null && opAttrInEntry.size() > 0) {
                for (Value value : opAttrInEntry) {
                    result.add(new Value[]{value});
                }
            } else {
                op = ModificationOperation.ADD_ATTRIBUTE;
            }
            modList.add((Modification)new ServerModification(op, (EntryAttribute)result));
        }
        return modList;
    }

    private List<Modification> getModsOnEntryModification(LdapDN name, ServerEntry oldEntry, ServerEntry newEntry) throws Exception {
        ArrayList<Modification> modList = new ArrayList<Modification>();
        Iterator<String> subentries = this.subentryCache.nameIterator();
        while (subentries.hasNext()) {
            ModificationOperation op;
            boolean isNewEntrySelected;
            String subentryDn = subentries.next();
            LdapDN apDn = new LdapDN(subentryDn);
            apDn.remove(apDn.size() - 1);
            SubtreeSpecification ss = this.subentryCache.getSubentry(subentryDn).getSubtreeSpecification();
            boolean isOldEntrySelected = this.evaluator.evaluate(ss, (Name)apDn, (Name)name, oldEntry);
            if (isOldEntrySelected == (isNewEntrySelected = this.evaluator.evaluate(ss, (Name)apDn, (Name)name, newEntry))) continue;
            if (isOldEntrySelected && !isNewEntrySelected) {
                for (String aSUBENTRY_OPATTRS : SUBENTRY_OPATTRS) {
                    op = ModificationOperation.REPLACE_ATTRIBUTE;
                    EntryAttribute opAttr = oldEntry.get(aSUBENTRY_OPATTRS);
                    if (opAttr == null) continue;
                    opAttr = (ServerAttribute)opAttr.clone();
                    opAttr.remove(new String[]{subentryDn});
                    if (opAttr.size() < 1) {
                        op = ModificationOperation.REMOVE_ATTRIBUTE;
                    }
                    modList.add((Modification)new ServerModification(op, opAttr));
                }
                continue;
            }
            if (!isNewEntrySelected || isOldEntrySelected) continue;
            for (String attribute : SUBENTRY_OPATTRS) {
                op = ModificationOperation.ADD_ATTRIBUTE;
                AttributeType type = this.atRegistry.lookup(attribute);
                DefaultServerAttribute opAttr = new DefaultServerAttribute(attribute, type);
                opAttr.add(new String[]{subentryDn});
                modList.add((Modification)new ServerModification(op, (EntryAttribute)opAttr));
            }
        }
        return modList;
    }

    public class HideEntriesFilter
    implements EntryFilter {
        public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
            String dn = entry.getDn().getNormName();
            if (SubentryInterceptor.this.subentryCache.hasSubentry(dn)) {
                return true;
            }
            EntryAttribute objectClasses = entry.get("objectClass");
            if (objectClasses != null) {
                return objectClasses.contains(new String[]{"subentry"});
            }
            LdapDN ndn = new LdapDN(dn);
            ndn.normalize(SubentryInterceptor.this.atRegistry.getNormalizerMapping());
            return SubentryInterceptor.this.subentryCache.hasSubentry(ndn.toNormName());
        }
    }

    public class HideSubentriesFilter
    implements EntryFilter {
        public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
            String dn = entry.getDn().getNormName();
            if (SubentryInterceptor.this.subentryCache.hasSubentry(dn)) {
                return false;
            }
            EntryAttribute objectClasses = entry.get("objectClass");
            if (objectClasses != null) {
                return !objectClasses.contains(new String[]{"subentry"});
            }
            LdapDN ndn = new LdapDN(dn);
            ndn.normalize(SubentryInterceptor.this.atRegistry.getNormalizerMapping());
            String normalizedDn = ndn.toString();
            return !SubentryInterceptor.this.subentryCache.hasSubentry(normalizedDn);
        }
    }
}

