/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class RefinementLeafEvaluator {
    private final OidRegistry registry;

    public RefinementLeafEvaluator(OidRegistry registry) {
        this.registry = registry;
    }

    public boolean evaluate(SimpleNode node, EntryAttribute objectClasses) throws NamingException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (!(node instanceof EqualityNode)) {
            throw new NamingException("Unrecognized assertion type for refinement node: " + node);
        }
        if (!node.getAttribute().equalsIgnoreCase("objectClass")) {
            throw new NamingException("Refinement leaf node attribute was " + node.getAttribute());
        }
        if (null == objectClasses) {
            throw new IllegalArgumentException("objectClasses argument cannot be null");
        }
        if (!((ServerAttribute)objectClasses).instanceOf("objectClass")) {
            throw new IllegalArgumentException("objectClasses attribute must be for ID 'objectClass'");
        }
        String value = node.getValue().getString();
        if (objectClasses.contains(new String[]{value})) {
            return true;
        }
        if (Character.isDigit(value.charAt(0))) {
            for (String objectClass : this.registry.getNameSet(value)) {
                if (!objectClasses.contains(new String[]{objectClass})) continue;
                return true;
            }
        }
        return false;
    }
}

