/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcUtils;
import org.apache.directory.server.core.sp.java.LdapJavaStoredProcClassLoader;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.util.DirectoryClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaStoredProcEngine
implements StoredProcEngine {
    public static final String STORED_PROC_LANG_ID = "Java";
    private ServerEntry spUnit;
    private static Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    @Override
    public Object invokeProcedure(CoreSession session, String fullSPName, Object[] spArgs) throws Exception {
        Method proc;
        Class<?> clazz;
        EntryAttribute javaByteCode = this.spUnit.get("javaByteCode");
        String spName = StoredProcUtils.extractStoredProcName(fullSPName);
        String className = StoredProcUtils.extractStoredProcUnitName(fullSPName);
        LdapJavaStoredProcClassLoader loader = new LdapJavaStoredProcClassLoader(javaByteCode);
        try {
            clazz = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        Class[] types = this.getTypesFromValues(spArgs);
        try {
            proc = DirectoryClassUtils.getAssignmentCompatibleMethod(clazz, (String)spName, (Class[])types);
        }
        catch (NoSuchMethodException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        try {
            return proc.invoke(null, spArgs);
        }
        catch (IllegalArgumentException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        catch (InvocationTargetException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    @Override
    public String getSPLangId() {
        return STORED_PROC_LANG_ID;
    }

    @Override
    public void setSPUnitEntry(ServerEntry spUnit) {
        this.spUnit = spUnit;
    }

    private Class<?>[] getTypesFromValues(Object[] values) {
        ArrayList types = new ArrayList();
        for (Object obj : values) {
            types.add(obj.getClass());
        }
        return types.toArray(EMPTY_CLASS_ARRAY);
    }
}

