/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.schema.SchemaOperationControl;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.parsers.AbstractAdsSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;

public class SchemaService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ServerEntry schemaSubentry;
    private final Object lock = new Object();
    private DirectoryService directoryService;
    private Registries registries;
    private JdbmPartition schemaPartition;
    private SchemaOperationControl schemaControl;
    private LdapDN schemaModificationAttributesDN;

    public SchemaService(DirectoryService directoryService, JdbmPartition schemaPartition, SchemaOperationControl schemaControl) throws NamingException {
        this.directoryService = directoryService;
        this.registries = directoryService.getRegistries();
        this.schemaPartition = schemaPartition;
        this.schemaControl = schemaControl;
        this.schemaModificationAttributesDN = new LdapDN("cn=schemaModifications,ou=schema");
        this.schemaModificationAttributesDN.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
    }

    public boolean isSchemaSubentry(String dnString) throws NamingException {
        if ("cn=schema".equalsIgnoreCase(dnString) || "2.5.4.3=schema".equalsIgnoreCase(dnString)) {
            return true;
        }
        LdapDN dn = new LdapDN(dnString).normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        return dn.getNormName().equals("2.5.4.3=schema");
    }

    public Registries getRegistries() {
        return this.registries;
    }

    private ServerAttribute generateComparators() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("comparators"));
        Iterator list = this.registries.getComparatorRegistry().comparatorDescriptionIterator();
        while (list.hasNext()) {
            ComparatorDescription description = (ComparatorDescription)list.next();
            attr.add(new String[]{SchemaUtils.render((AbstractAdsSchemaDescription)description)});
        }
        return attr;
    }

    private ServerAttribute generateNormalizers() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("normalizers"));
        Iterator list = this.registries.getNormalizerRegistry().normalizerDescriptionIterator();
        while (list.hasNext()) {
            NormalizerDescription normalizer = (NormalizerDescription)list.next();
            attr.add(new String[]{SchemaUtils.render((AbstractAdsSchemaDescription)normalizer)});
        }
        return attr;
    }

    private ServerAttribute generateSyntaxCheckers() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("syntaxCheckers"));
        Iterator list = this.registries.getSyntaxCheckerRegistry().syntaxCheckerDescriptionIterator();
        while (list.hasNext()) {
            SyntaxCheckerDescription syntaxCheckerDescription = (SyntaxCheckerDescription)list.next();
            attr.add(new String[]{SchemaUtils.render((AbstractAdsSchemaDescription)syntaxCheckerDescription)});
        }
        return attr;
    }

    private ServerAttribute generateObjectClasses() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("objectClasses"));
        for (ObjectClass oc : this.registries.getObjectClassRegistry()) {
            attr.add(new String[]{SchemaUtils.render((ObjectClass)oc).toString()});
        }
        return attr;
    }

    private ServerAttribute generateAttributeTypes() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("attributeTypes"));
        for (AttributeType at : this.registries.getAttributeTypeRegistry()) {
            attr.add(new String[]{SchemaUtils.render((AttributeType)at).toString()});
        }
        return attr;
    }

    private ServerAttribute generateMatchingRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("matchingRules"));
        for (MatchingRule mr : this.registries.getMatchingRuleRegistry()) {
            attr.add(new String[]{SchemaUtils.render((MatchingRule)mr).toString()});
        }
        return attr;
    }

    private ServerAttribute generateMatchingRuleUses() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("matchingRuleUse"));
        for (MatchingRuleUse mru : this.registries.getMatchingRuleUseRegistry()) {
            attr.add(new String[]{SchemaUtils.render((MatchingRuleUse)mru).toString()});
        }
        return attr;
    }

    private ServerAttribute generateSyntaxes() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("ldapSyntaxes"));
        for (Syntax syntax : this.registries.getSyntaxRegistry()) {
            attr.add(new String[]{SchemaUtils.render((Syntax)syntax).toString()});
        }
        return attr;
    }

    private ServerAttribute generateDitContextRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("ditContentRules"));
        for (DITContentRule dcr : this.registries.getDitContentRuleRegistry()) {
            attr.add(new String[]{SchemaUtils.render((DITContentRule)dcr).toString()});
        }
        return attr;
    }

    private ServerAttribute generateDitStructureRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("ditStructureRules"));
        for (DITStructureRule dsr : this.registries.getDitStructureRuleRegistry()) {
            attr.add(new String[]{SchemaUtils.render((DITStructureRule)dsr).toString()});
        }
        return attr;
    }

    private ServerAttribute generateNameForms() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("nameForms"));
        for (NameForm nf : this.registries.getNameFormRegistry()) {
            attr.add(new String[]{SchemaUtils.render((NameForm)nf).toString()});
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSchemaSubentry(ServerEntry mods) throws NamingException {
        DefaultServerEntry attrs = new DefaultServerEntry(this.registries, mods.getDn());
        attrs.put("objectClass", new String[]{"top", "subschema", "subentry", "apacheSubschema"});
        attrs.put("cn", new String[]{"schema"});
        attrs.put(new EntryAttribute[]{this.generateComparators()});
        attrs.put(new EntryAttribute[]{this.generateNormalizers()});
        attrs.put(new EntryAttribute[]{this.generateSyntaxCheckers()});
        attrs.put(new EntryAttribute[]{this.generateObjectClasses()});
        attrs.put(new EntryAttribute[]{this.generateAttributeTypes()});
        attrs.put(new EntryAttribute[]{this.generateMatchingRules()});
        attrs.put(new EntryAttribute[]{this.generateMatchingRuleUses()});
        attrs.put(new EntryAttribute[]{this.generateSyntaxes()});
        attrs.put(new EntryAttribute[]{this.generateDitContextRules()});
        attrs.put(new EntryAttribute[]{this.generateDitStructureRules()});
        attrs.put(new EntryAttribute[]{this.generateNameForms()});
        attrs.put("subtreeSpecification", new String[]{"{}"});
        AttributeType createTimestampAT = this.registries.getAttributeTypeRegistry().lookup("createTimestamp");
        EntryAttribute createTimestamp = mods.get(createTimestampAT);
        attrs.put("createTimestamp", new Value[]{createTimestamp.get()});
        attrs.put("creatorsName", new String[]{"uid=admin,ou=system"});
        AttributeType schemaModifyTimestampAT = this.registries.getAttributeTypeRegistry().lookup("schemaModifyTimestamp");
        EntryAttribute schemaModifyTimestamp = mods.get(schemaModifyTimestampAT);
        attrs.put("modifyTimestamp", new Value[]{schemaModifyTimestamp.get()});
        AttributeType schemaModifiersNameAT = this.registries.getAttributeTypeRegistry().lookup("schemaModifiersName");
        EntryAttribute schemaModifiersName = mods.get(schemaModifiersNameAT);
        attrs.put("modifiersName", new Value[]{schemaModifiersName.get()});
        Object object = this.lock;
        synchronized (object) {
            this.schemaSubentry = attrs;
        }
    }

    private void addAttribute(ServerEntry attrs, String id) throws NamingException {
        EntryAttribute attr = this.schemaSubentry.get(id);
        if (attr != null) {
            attrs.put(new EntryAttribute[]{attr});
        }
    }

    public ServerEntry getSubschemaEntryImmutable() throws Exception {
        if (this.schemaSubentry == null) {
            this.generateSchemaSubentry((ServerEntry)this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN)));
        }
        return (ServerEntry)this.schemaSubentry.clone();
    }

    public ServerEntry getSubschemaEntryCloned() throws Exception {
        if (this.schemaSubentry == null) {
            this.generateSchemaSubentry((ServerEntry)this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN)));
        }
        return (ServerEntry)this.schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerEntry getSubschemaEntry(String[] ids) throws Exception {
        if (ids == null) {
            ids = EMPTY_STRING_ARRAY;
        }
        HashSet<String> setOids = new HashSet<String>();
        DefaultServerEntry attrs = new DefaultServerEntry(this.registries, LdapDN.EMPTY_LDAPDN);
        boolean returnAllOperationalAttributes = false;
        Object object = this.lock;
        synchronized (object) {
            ClonedServerEntry mods = this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN));
            this.generateSchemaSubentry((ServerEntry)mods);
            for (String id : ids) {
                if ("+".equals(id)) {
                    returnAllOperationalAttributes = true;
                    continue;
                }
                if ("*".equals(id)) {
                    setOids.add(id);
                    continue;
                }
                setOids.add(this.registries.getOidRegistry().getOid(id));
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.32")) {
                this.addAttribute((ServerEntry)attrs, "comparators");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.33")) {
                this.addAttribute((ServerEntry)attrs, "normalizers");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.34")) {
                this.addAttribute((ServerEntry)attrs, "syntaxCheckers");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.6")) {
                this.addAttribute((ServerEntry)attrs, "objectClasses");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.5")) {
                this.addAttribute((ServerEntry)attrs, "attributeTypes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.4")) {
                this.addAttribute((ServerEntry)attrs, "matchingRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.8")) {
                this.addAttribute((ServerEntry)attrs, "matchingRuleUse");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.1466.101.120.16")) {
                this.addAttribute((ServerEntry)attrs, "ldapSyntaxes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.2")) {
                this.addAttribute((ServerEntry)attrs, "ditContentRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.1")) {
                this.addAttribute((ServerEntry)attrs, "ditStructureRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.7")) {
                this.addAttribute((ServerEntry)attrs, "nameForms");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.6")) {
                this.addAttribute((ServerEntry)attrs, "subtreeSpecification");
            }
            int minSetSize = 0;
            if (setOids.contains("+")) {
                ++minSetSize;
            }
            if (setOids.contains("*")) {
                ++minSetSize;
            }
            if (setOids.contains("2.16.840.1.113730.3.1.34")) {
                ++minSetSize;
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.0") || setOids.size() == minSetSize) {
                this.addAttribute((ServerEntry)attrs, "objectClass");
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.3") || setOids.size() == minSetSize) {
                this.addAttribute((ServerEntry)attrs, "cn");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.1")) {
                this.addAttribute((ServerEntry)attrs, "createTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.3")) {
                this.addAttribute((ServerEntry)attrs, "creatorsName");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.2")) {
                this.addAttribute((ServerEntry)attrs, "modifyTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.4")) {
                this.addAttribute((ServerEntry)attrs, "modifiersName");
            }
        }
        return attrs;
    }

    SchemaOperationControl getSchemaControl() {
        return this.schemaControl;
    }
}

