/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;

public class MetaObjectClassHandler
extends AbstractSchemaChangeHandler {
    private final SchemaPartitionDao dao;
    private final ObjectClassRegistry objectClassRegistry;

    public MetaObjectClassHandler(Registries targetRegistries, PartitionSchemaLoader loader, SchemaPartitionDao dao) throws Exception {
        super(targetRegistries, loader);
        this.dao = dao;
        this.objectClassRegistry = targetRegistries.getObjectClassRegistry();
    }

    protected boolean modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Schema schema = this.getSchema(name);
        ObjectClass oc = this.factory.getObjectClass(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.objectClassRegistry.unregister(oid);
            this.objectClassRegistry.register(oc);
            return true;
        }
        return false;
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(name);
        ObjectClass oc = this.factory.getObjectClass(entry, this.targetRegistries, schemaName);
        this.add(oc);
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        String schemaName = this.getSchemaName(name);
        ObjectClass oc = this.factory.getObjectClass(entry, this.targetRegistries, schemaName);
        Set<ServerEntry> dependees = this.dao.listObjectClassDependents(oc);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The objectClass with OID " + oc.getOid() + " cannot be deleted until all entities" + " using this objectClass have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        this.delete(oc, cascade);
    }

    public void delete(ObjectClass oc, boolean cascade) throws Exception {
        Schema schema = this.loader.getSchema(oc.getSchema());
        if (!schema.isDisabled()) {
            this.objectClassRegistry.unregister(oc.getOid());
        }
        this.unregisterOids(oc.getOid());
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        Schema schema = this.getSchema(name);
        ObjectClass oldOc = this.factory.getObjectClass(entry, this.targetRegistries, schema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listObjectClassDependents(oldOc);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The objectClass with OID " + oldOc.getOid() + " cannot be deleted until all entities" + " using this objectClass have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        targetEntry.put("m-oid", new String[]{newOid});
        this.checkOidIsUnique(newOid);
        ObjectClass oc = this.factory.getObjectClass(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.objectClassRegistry.unregister(oldOc.getOid());
            this.objectClassRegistry.register(oc);
        } else {
            this.registerOids((SchemaObject)oc);
        }
        this.unregisterOids(oldOc.getOid());
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        Schema oldSchema = this.getSchema(oriChildName);
        ObjectClass oldOc = this.factory.getObjectClass(entry, this.targetRegistries, oldSchema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listObjectClassDependents(oldOc);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The objectClass with OID " + oldOc.getOid() + " cannot be deleted until all entities" + " using this objectClass have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema newSchema = this.getSchema(newParentName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", new String[]{newOid});
        ObjectClass oc = this.factory.getObjectClass(targetEntry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.objectClassRegistry.unregister(oldOc.getOid());
        }
        this.unregisterOids(oldOc.getOid());
        if (!newSchema.isDisabled()) {
            this.objectClassRegistry.register(oc);
        } else {
            this.registerOids((SchemaObject)oc);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        Schema oldSchema = this.getSchema(oriChildName);
        ObjectClass oldAt = this.factory.getObjectClass(entry, this.targetRegistries, oldSchema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listObjectClassDependents(oldAt);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The objectClass with OID " + oldAt.getOid() + " cannot be deleted until all entities" + " using this objectClass have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema newSchema = this.getSchema(newParentName);
        ObjectClass oc = this.factory.getObjectClass(entry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.objectClassRegistry.unregister(oldAt.getOid());
        }
        if (!newSchema.isDisabled()) {
            this.objectClassRegistry.register(oc);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a objectClass should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a objectClass should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("objectClasses")) {
            throw new LdapInvalidNameException("The parent entry of a attributeType should have a relative name of ou=objectClasses.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }

    public void add(ObjectClass oc) throws Exception {
        Schema schema = this.loader.getSchema(oc.getSchema());
        if (!schema.isDisabled()) {
            this.objectClassRegistry.register(oc);
        } else {
            this.registerOids((SchemaObject)oc);
        }
    }
}

