/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AbstractAttributeType;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;

class AttributeTypeImpl
extends AbstractAttributeType
implements MutableSchemaObject {
    private static final long serialVersionUID = 1L;
    private final Registries registries;
    private String syntaxOid;
    private Syntax syntax;
    private String equalityOid;
    private MatchingRule equalityMR;
    private String substrOid;
    private MatchingRule substringMR;
    private String orderingOid;
    private MatchingRule orderingMR;
    private String superiorOid;

    public AttributeTypeImpl(String oid, Registries registries) {
        super(oid);
        this.registries = registries;
    }

    public MatchingRule getEquality() throws NamingException {
        if (this.equalityMR == null) {
            this.equalityMR = this.equalityOid == null ? this.findEquality(this.getSuperior()) : this.registries.getMatchingRuleRegistry().lookup(this.equalityOid);
        }
        return this.equalityMR;
    }

    private MatchingRule findEquality(AttributeType at) throws NamingException {
        if (at == null) {
            return null;
        }
        MatchingRule mr = at.getEquality();
        if (mr == null) {
            return this.findEquality(at.getSuperior());
        }
        return mr;
    }

    public MatchingRule getOrdering() throws NamingException {
        if (this.orderingMR == null) {
            this.orderingMR = this.orderingOid == null ? this.findOrdering(this.getSuperior()) : this.registries.getMatchingRuleRegistry().lookup(this.orderingOid);
        }
        return this.orderingMR;
    }

    private MatchingRule findOrdering(AttributeType at) throws NamingException {
        if (at == null) {
            return null;
        }
        MatchingRule mr = at.getOrdering();
        if (mr == null) {
            return this.findOrdering(at.getSuperior());
        }
        return mr;
    }

    public MatchingRule getSubstr() throws NamingException {
        if (this.substringMR == null) {
            this.substringMR = this.substrOid == null ? this.findSubstr(this.getSuperior()) : this.registries.getMatchingRuleRegistry().lookup(this.substrOid);
        }
        return this.substringMR;
    }

    private MatchingRule findSubstr(AttributeType at) throws NamingException {
        if (at == null) {
            return null;
        }
        MatchingRule mr = at.getSubstr();
        if (mr == null) {
            return this.findSubstr(at.getSuperior());
        }
        return mr;
    }

    public AttributeType getSuperior() throws NamingException {
        if (this.superiorOid == null) {
            return null;
        }
        return this.registries.getAttributeTypeRegistry().lookup(this.superiorOid);
    }

    public Syntax getSyntax() throws NamingException {
        if (this.syntax == null) {
            this.syntax = this.syntaxOid == null ? this.findSyntax(this.getSuperior()) : this.registries.getSyntaxRegistry().lookup(this.syntaxOid);
        }
        return this.syntax;
    }

    private Syntax findSyntax(AttributeType at) throws NamingException {
        if (at == null) {
            throw new LdapNamingException("Cannot find syntax for attributeType " + this.getName() + " after walking ancestors.", ResultCodeEnum.OTHER);
        }
        if (at.getSyntax() != null) {
            return at.getSyntax();
        }
        return this.findSyntax(at.getSuperior());
    }

    public void setSyntaxOid(String syntaxOid) {
        this.syntaxOid = syntaxOid;
    }

    public void setSchema(String schema) {
        super.setSchema(schema);
    }

    public void setSuperiorOid(String superiorOid) {
        this.superiorOid = superiorOid;
    }

    public void setEqualityOid(String equalityOid) {
        this.equalityOid = equalityOid;
    }

    public void setSubstrOid(String substrOid) {
        this.substrOid = substrOid;
    }

    public void setOrderingOid(String orderingOid) {
        this.orderingOid = orderingOid;
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setNames(String[] names) {
        super.setNames(names);
    }

    public void setObsolete(boolean obsolete) {
        super.setObsolete(obsolete);
    }

    public void setCollective(boolean collective) {
        super.setCollective(collective);
    }

    public void setCanUserModify(boolean canUserModify) {
        super.setCanUserModify(canUserModify);
    }

    public void setLength(int length) {
        super.setLength(length);
    }

    public void setSingleValue(boolean singleValue) {
        super.setSingleValue(singleValue);
    }

    public void setUsage(UsageEnum usage) {
        super.setUsage(usage);
    }
}

