/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.prefs;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.prefs.ServerSystemPreferenceException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.PreferencesDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSystemPreferences
extends AbstractPreferences {
    private static final String[] EMPTY_STRINGS = new String[0];
    private List<Modification> changes = new ArrayList<Modification>(3);
    private HashMap<String, List<Modification>> keyToChange = new HashMap(3);
    private LdapDN dn;
    private DirectoryService directoryService;

    public ServerSystemPreferences(DirectoryService directoryService) {
        super(null, "");
        this.newNode = false;
        try {
            this.dn = new LdapDN("prefNodeName=sysPrefRoot,ou=system");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        this.directoryService = directoryService;
    }

    public void close() throws NamingException {
    }

    public ServerSystemPreferences(ServerSystemPreferences parent, String name) {
        super(parent, name);
        this.directoryService = parent.directoryService;
        LdapDN parentDn = ((ServerSystemPreferences)this.parent()).dn;
        try {
            this.dn = new LdapDN("prefNodeName=" + name + "," + parentDn.getUpName());
            this.dn.normalize(this.directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            if (!this.directoryService.getAdminSession().exists(this.dn)) {
                ServerEntry entry = this.directoryService.newEntry(this.dn);
                entry.add("objectClass", new String[]{"top", "prefNode", "extensibleObject"});
                entry.add("prefNodeName", new String[]{name});
                this.directoryService.getAdminSession().add(entry);
                this.newNode = false;
            }
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException("Failed to set up node.", e);
        }
    }

    public Dictionary<String, String> wrapAsDictionary() {
        return new PreferencesDictionary((Preferences)this);
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.directoryService.getAdminSession().modify(this.dn, this.changes);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            this.directoryService.getAdminSession().delete(this.dn);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.directoryService.getAdminSession().modify(this.dn, this.changes);
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> children = new ArrayList<String>();
        try {
            EntryFilteringCursor list = this.directoryService.getAdminSession().list(this.dn, AliasDerefMode.DEREF_ALWAYS, null);
            list.beforeFirst();
            while (list.next()) {
                ClonedServerEntry entry = (ClonedServerEntry)list.get();
                children.add((String)entry.getDn().getRdn().getValue());
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        return children.toArray(EMPTY_STRINGS);
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            ClonedServerEntry entry = this.directoryService.getAdminSession().lookup(this.dn);
            for (EntryAttribute attr : entry) {
                ServerAttribute sa = (ServerAttribute)attr;
                String oid = sa.getAttributeType().getOid();
                if (oid.equals("2.5.4.0")) continue;
                keys.add(sa.getUpId());
            }
        }
        catch (Exception e) {
            throw new BackingStoreException(e);
        }
        return keys.toArray(EMPTY_STRINGS);
    }

    @Override
    protected void removeSpi(String key) {
        try {
            AttributeType at = this.directoryService.getRegistries().getAttributeTypeRegistry().lookup(key);
            DefaultServerAttribute attr = new DefaultServerAttribute(at);
            ServerModification mi = new ServerModification(ModificationOperation.REMOVE_ATTRIBUTE, (EntryAttribute)attr);
            this.addDelta((Modification)mi);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    private void addDelta(Modification mi) {
        String key = mi.getAttribute().getUpId();
        this.changes.add(mi);
        List<Modification> deltas = this.keyToChange.containsKey(key) ? this.keyToChange.get(key) : new ArrayList<Modification>();
        deltas.add(mi);
        this.keyToChange.put(key, deltas);
    }

    @Override
    protected String getSpi(String key) {
        try {
            EntryAttribute attr = this.directoryService.getAdminSession().lookup(this.dn).get(key);
            if (this.keyToChange.containsKey(key)) {
                for (Modification mod : this.keyToChange.get(key)) {
                    if (mod.getOperation() == ModificationOperation.REMOVE_ATTRIBUTE) {
                        attr = null;
                        continue;
                    }
                    attr = mod.getAttribute();
                }
            }
            if (attr == null) {
                return null;
            }
            return attr.getString();
        }
        catch (Exception e) {
            throw new ServerSystemPreferenceException("Failed to get SPI.", e);
        }
    }

    @Override
    protected void putSpi(String key, String value) {
        try {
            AttributeType at = this.directoryService.getRegistries().getAttributeTypeRegistry().lookup(key);
            DefaultServerAttribute attr = new DefaultServerAttribute(at, new String[]{value});
            ServerModification mi = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)attr);
            this.addDelta((Modification)mi);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new ServerSystemPreferences(this, name);
    }
}

