/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionFrame;
import org.apache.directory.server.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionViewer {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionViewer.class);
    private BTreePartition partition;
    private Registries registries;

    public PartitionViewer(BTreePartition db, Registries registries) {
        this.partition = db;
        this.registries = registries;
    }

    public int execute() throws Exception {
        Thread t = new Thread(new Runnable(){

            public void run() {
                PartitionFrame frame = null;
                try {
                    frame = new PartitionFrame(PartitionViewer.this.partition, PartitionViewer.this.registries);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = frame.getSize();
                frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
                frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
                frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                frame.setVisible(true);
                LOG.debug(frameSize + "");
            }
        });
        t.run();
        return 0;
    }
}

