/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.message.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareOperationContext
extends AbstractOperationContext {
    private String oid;
    private Value<?> value;

    public CompareOperationContext(CoreSession session) {
        super(session);
    }

    public CompareOperationContext(CoreSession session, LdapDN dn) {
        super(session, dn);
    }

    public CompareOperationContext(CoreSession session, String oid) {
        super(session);
        this.oid = oid;
    }

    public CompareOperationContext(CoreSession session, LdapDN dn, String oid) {
        super(session, dn);
        this.oid = oid;
    }

    public CompareOperationContext(CoreSession session, LdapDN dn, String oid, Value<?> value) {
        super(session, dn);
        this.oid = oid;
        this.value = value;
    }

    public CompareOperationContext(CoreSession session, InternalCompareRequest compareRequest) {
        super(session, compareRequest.getName());
        this.oid = compareRequest.getAttributeId();
        this.value = compareRequest.getAssertionValue();
        this.requestControls = compareRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public Value<?> getValue() {
        return this.value;
    }

    public void setValue(Value<?> value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return MessageTypeEnum.COMPARE_REQUEST.name();
    }

    public String toString() {
        return "CompareContext for DN '" + this.getDn().getUpName() + "'" + (this.oid != null ? ", oid : <" + this.oid + ">" : "") + (this.value != null ? ", value :'" + (!this.value.isBinary() ? this.value.getString() : (this.value.isBinary() ? StringTools.dumpBytes((byte[])((byte[])((ClientBinaryValue)this.value).getReference())) : "unknown value type")) + "'" : "");
    }
}

