/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.Control;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperationContext
implements OperationContext {
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    protected LdapDN dn;
    protected ClonedServerEntry entry;
    protected Map<String, Control> requestControls = new HashMap<String, Control>(4);
    protected Map<String, Control> responseControls = new HashMap<String, Control>(4);
    protected Collection<String> byPassed;
    protected LdapPrincipal authorizedPrincipal;
    protected CoreSession session;
    protected OperationContext next;
    protected OperationContext previous;
    protected boolean throwReferral;

    public AbstractOperationContext(CoreSession session) {
        this.session = session;
    }

    public AbstractOperationContext(CoreSession session, LdapDN dn) {
        this.dn = dn;
        this.session = session;
        this.ignoreReferral();
    }

    @Override
    public CoreSession getSession() {
        return this.session;
    }

    protected void setSession(CoreSession session) {
        this.session = session;
    }

    protected void setAuthorizedPrincipal(LdapPrincipal authorizedPrincipal) {
        this.authorizedPrincipal = authorizedPrincipal;
    }

    @Override
    public LdapDN getDn() {
        return this.dn;
    }

    @Override
    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    @Override
    public void addRequestControl(Control requestControl) {
        this.requestControls.put(requestControl.getID(), requestControl);
    }

    @Override
    public Control getRequestControl(String numericOid) {
        return this.requestControls.get(numericOid);
    }

    @Override
    public boolean hasRequestControl(String numericOid) {
        return this.requestControls.containsKey(numericOid);
    }

    @Override
    public boolean hasRequestControls() {
        return !this.requestControls.isEmpty();
    }

    @Override
    public void addResponseControl(Control responseControl) {
        this.responseControls.put(responseControl.getID(), responseControl);
    }

    @Override
    public Control getResponseControl(String numericOid) {
        return this.responseControls.get(numericOid);
    }

    @Override
    public boolean hasResponseControl(String numericOid) {
        return this.responseControls.containsKey(numericOid);
    }

    @Override
    public Control[] getResponseControls() {
        if (this.responseControls.isEmpty()) {
            return EMPTY_CONTROLS;
        }
        return this.responseControls.values().toArray(EMPTY_CONTROLS);
    }

    @Override
    public boolean hasResponseControls() {
        return !this.responseControls.isEmpty();
    }

    @Override
    public int getResponseControlCount() {
        return this.responseControls.size();
    }

    @Override
    public void addRequestControls(Control[] requestControls) {
        for (Control c : requestControls) {
            this.requestControls.put(c.getID(), c);
        }
    }

    public void setRequestControls(Map<String, Control> requestControls) {
        this.requestControls = requestControls;
    }

    @Override
    public abstract String getName();

    @Override
    public Collection<String> getByPassed() {
        if (this.byPassed == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.byPassed);
    }

    @Override
    public void setByPassed(Collection<String> byPassed) {
        this.byPassed = byPassed;
    }

    @Override
    public boolean isBypassed(String interceptorName) {
        return this.byPassed != null && this.byPassed.contains(interceptorName);
    }

    @Override
    public boolean hasBypass() {
        return this.byPassed != null && !this.byPassed.isEmpty();
    }

    private void setup(AbstractOperationContext opContext) {
        opContext.setPreviousOperation(this);
        this.next = opContext;
        opContext.setByPassed(this.byPassed);
        opContext.setAuthorizedPrincipal(this.authorizedPrincipal);
    }

    @Override
    public boolean hasEntry(LdapDN dn, Collection<String> byPassed) throws Exception {
        EntryOperationContext opContext = new EntryOperationContext(this.session, dn);
        this.setup(opContext);
        opContext.setByPassed(byPassed);
        return this.session.getDirectoryService().getOperationManager().hasEntry(opContext);
    }

    @Override
    public void add(ServerEntry entry, Collection<String> byPassed) throws Exception {
        AddOperationContext opContext = new AddOperationContext(this.session, entry);
        this.setup(opContext);
        opContext.setByPassed(byPassed);
        this.session.getDirectoryService().getOperationManager().add(opContext);
    }

    @Override
    public void delete(LdapDN dn, Collection<String> byPassed) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext(this.session, dn);
        this.setup(opContext);
        opContext.setByPassed(byPassed);
        this.session.getDirectoryService().getOperationManager().delete(opContext);
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods, Collection<String> byPassed) throws Exception {
        ModifyOperationContext opContext = new ModifyOperationContext(this.session, dn, mods);
        this.setup(opContext);
        opContext.setByPassed(byPassed);
        this.session.getDirectoryService().getOperationManager().modify(opContext);
    }

    @Override
    public LookupOperationContext newLookupContext(LdapDN dn) {
        LookupOperationContext opContext = new LookupOperationContext(this.session, dn);
        this.setup(opContext);
        return opContext;
    }

    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        if (opContext != this.next) {
            throw new IllegalStateException("Cannot execute indirect lookup if it is not the next operation.");
        }
        return this.session.getDirectoryService().getOperationManager().lookup(opContext);
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn, Collection<String> byPassed) throws Exception {
        LookupOperationContext opContext = this.newLookupContext(dn);
        opContext.setByPassed(byPassed);
        return this.session.getDirectoryService().getOperationManager().lookup(opContext);
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal != null) {
            return this.authorizedPrincipal;
        }
        return this.session.getEffectivePrincipal();
    }

    @Override
    public boolean isFirstOperation() {
        return this.previous == null;
    }

    @Override
    public OperationContext getFirstOperation() {
        if (this.previous == null) {
            return this;
        }
        return this.previous.getFirstOperation();
    }

    @Override
    public OperationContext getLastOperation() {
        if (this.next == null) {
            return this;
        }
        return this.next.getLastOperation();
    }

    @Override
    public OperationContext getNextOperation() {
        return this.next;
    }

    protected void setNextOperation(OperationContext next) {
        this.next = next;
    }

    @Override
    public OperationContext getPreviousOperation() {
        return this.previous;
    }

    protected void setPreviousOperation(OperationContext previous) {
        this.previous = previous;
    }

    @Override
    public void setEntry(ClonedServerEntry entry) {
        this.entry = entry;
    }

    @Override
    public ClonedServerEntry getEntry() {
        return this.entry;
    }

    @Override
    public void throwReferral() {
        this.throwReferral = true;
    }

    @Override
    public boolean isReferralThrown() {
        return this.throwReferral;
    }

    @Override
    public void ignoreReferral() {
        this.throwReferral = false;
    }

    @Override
    public boolean isReferralIgnored() {
        return !this.throwReferral;
    }
}

