/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor;

import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInterceptor
implements Interceptor {
    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public static LdapPrincipal getPrincipal() {
        return BaseInterceptor.getContext().getSession().getEffectivePrincipal();
    }

    public static OperationContext getContext() {
        return InvocationStack.getInstance().peek();
    }

    protected BaseInterceptor() {
    }

    @Override
    public void init(DirectoryService directoryService) throws Exception {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        next.add(opContext);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        next.delete(opContext);
    }

    @Override
    public LdapDN getMatchedName(NextInterceptor next, GetMatchedNameOperationContext opContext) throws Exception {
        return next.getMatchedName(opContext);
    }

    @Override
    public ClonedServerEntry getRootDSE(NextInterceptor next, GetRootDSEOperationContext opContext) throws Exception {
        return next.getRootDSE(opContext);
    }

    @Override
    public LdapDN getSuffix(NextInterceptor next, GetSuffixOperationContext opContext) throws Exception {
        return next.getSuffix(opContext);
    }

    @Override
    public boolean hasEntry(NextInterceptor next, EntryOperationContext opContext) throws Exception {
        return next.hasEntry(opContext);
    }

    @Override
    public EntryFilteringCursor list(NextInterceptor next, ListOperationContext opContext) throws Exception {
        return next.list(opContext);
    }

    @Override
    public Set<String> listSuffixes(NextInterceptor next, ListSuffixOperationContext opContext) throws Exception {
        return next.listSuffixes(opContext);
    }

    @Override
    public ClonedServerEntry lookup(NextInterceptor next, LookupOperationContext opContext) throws Exception {
        return next.lookup(opContext);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        next.modify(opContext);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        next.rename(opContext);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        next.moveAndRename(opContext);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        next.move(opContext);
    }

    @Override
    public EntryFilteringCursor search(NextInterceptor next, SearchOperationContext opContext) throws Exception {
        return next.search(opContext);
    }

    @Override
    public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws Exception {
        next.addContextPartition(opContext);
    }

    @Override
    public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws Exception {
        next.removeContextPartition(opContext);
    }

    @Override
    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
        return next.compare(opContext);
    }

    @Override
    public void bind(NextInterceptor next, BindOperationContext opContext) throws Exception {
        next.bind(opContext);
    }

    @Override
    public void unbind(NextInterceptor next, UnbindOperationContext opContext) throws Exception {
        next.unbind(opContext);
    }
}

