/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedUserClassFilter
implements ACITupleFilter {
    private static final LdapDN ROOTDSE_NAME = LdapDN.EMPTY_LDAPDN;
    private final SubtreeEvaluator subtreeEvaluator;

    public RelatedUserClassFilter(SubtreeEvaluator subtreeEvaluator) {
        this.subtreeEvaluator = subtreeEvaluator;
    }

    @Override
    public Collection<ACITuple> filter(Registries registries, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<LdapDN> userGroupNames, LdapDN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws NamingException {
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> ii = tuples.iterator();
        while (ii.hasNext()) {
            ACITuple tuple = ii.next();
            if (tuple.isGrant()) {
                if (this.isRelated(userGroupNames, userName, userEntry, entryName, tuple.getUserClasses()) && authenticationLevel.compareTo((Enum)tuple.getAuthenticationLevel()) >= 0) continue;
                ii.remove();
                continue;
            }
            if (this.isRelated(userGroupNames, userName, userEntry, entryName, tuple.getUserClasses()) || authenticationLevel.compareTo((Enum)tuple.getAuthenticationLevel()) < 0) continue;
            ii.remove();
        }
        return tuples;
    }

    private boolean isRelated(Collection<LdapDN> userGroupNames, LdapDN userName, ServerEntry userEntry, LdapDN entryName, Collection<UserClass> userClasses) throws NamingException {
        for (UserClass userClass : userClasses) {
            if (userClass == UserClass.ALL_USERS) {
                return true;
            }
            if (userClass == UserClass.THIS_ENTRY) {
                if (!userName.equals((Object)entryName)) continue;
                return true;
            }
            if (userClass == UserClass.PARENT_OF_ENTRY) {
                if (!entryName.startsWith((Name)userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.Name) {
                UserClass.Name nameUserClass = (UserClass.Name)userClass;
                if (!nameUserClass.getNames().contains(userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.UserGroup) {
                UserClass.UserGroup userGroupUserClass = (UserClass.UserGroup)userClass;
                for (LdapDN userGroupName : userGroupNames) {
                    if (userGroupName == null || !userGroupUserClass.getNames().contains(userGroupName)) continue;
                    return true;
                }
                continue;
            }
            if (userClass instanceof UserClass.Subtree) {
                UserClass.Subtree subtree = (UserClass.Subtree)userClass;
                if (!this.matchUserClassSubtree(userName, userEntry, subtree)) continue;
                return true;
            }
            throw new InternalError("Unexpected userClass: " + userClass.getClass().getName());
        }
        return false;
    }

    private boolean matchUserClassSubtree(LdapDN userName, ServerEntry userEntry, UserClass.Subtree subtree) throws NamingException {
        for (SubtreeSpecification subtreeSpec : subtree.getSubtreeSpecifications()) {
            if (!this.subtreeEvaluator.evaluate(subtreeSpec, (Name)ROOTDSE_NAME, (Name)userName, userEntry)) continue;
            return true;
        }
        return false;
    }
}

