/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostSpecificUserClassFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(Registries registries, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<LdapDN> userGroupNames, LdapDN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws NamingException {
        if (tuples.size() <= 1) {
            return tuples;
        }
        ArrayList<ACITuple> filteredTuples = new ArrayList<ACITuple>();
        block0: for (ACITuple tuple : tuples) {
            for (UserClass userClass : tuple.getUserClasses()) {
                if (!(userClass instanceof UserClass.Name) && !(userClass instanceof UserClass.ThisEntry)) continue;
                filteredTuples.add(tuple);
                continue block0;
            }
        }
        if (filteredTuples.size() > 0) {
            return filteredTuples;
        }
        block2: for (ACITuple tuple : tuples) {
            for (UserClass userClass : tuple.getUserClasses()) {
                if (!(userClass instanceof UserClass.UserGroup)) continue;
                filteredTuples.add(tuple);
                continue block2;
            }
        }
        if (filteredTuples.size() > 0) {
            return filteredTuples;
        }
        block4: for (ACITuple tuple : tuples) {
            for (UserClass userClass : tuple.getUserClasses()) {
                if (!(userClass instanceof UserClass.Subtree)) continue;
                filteredTuples.add(tuple);
                continue block4;
            }
        }
        if (filteredTuples.size() > 0) {
            return filteredTuples;
        }
        return tuples;
    }
}

