/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.InternalAddRequest;
import org.apache.directory.shared.ldap.message.InternalCompareRequest;
import org.apache.directory.shared.ldap.message.InternalDeleteRequest;
import org.apache.directory.shared.ldap.message.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.message.InternalModifyRequest;
import org.apache.directory.shared.ldap.message.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.InternalUnbindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCoreSession
implements CoreSession {
    private final DirectoryService directoryService;
    private final LdapPrincipal authenticatedPrincipal;
    private LdapPrincipal authorizedPrincipal;

    public DefaultCoreSession(LdapPrincipal principal, DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.authenticatedPrincipal = principal;
    }

    private void setReferralHandling(AbstractOperationContext opContext, boolean ignoreReferral) {
        if (ignoreReferral) {
            opContext.ignoreReferral();
        } else {
            opContext.throwReferral();
        }
    }

    @Override
    public void add(ServerEntry entry) throws Exception {
        this.add(entry, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void add(ServerEntry entry, boolean ignoreReferral) throws Exception {
        this.add(entry, ignoreReferral, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void add(ServerEntry entry, DefaultDirectoryService.LogChange log) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, entry);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(opContext);
    }

    @Override
    public void add(ServerEntry entry, boolean ignoreReferral, DefaultDirectoryService.LogChange log) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, entry);
        opContext.setLogChange(log);
        this.setReferralHandling(opContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(opContext);
    }

    @Override
    public void add(InternalAddRequest addRequest) throws Exception {
        this.add(addRequest, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void add(InternalAddRequest addRequest, DefaultDirectoryService.LogChange log) throws Exception {
        AddOperationContext opContext = new AddOperationContext((CoreSession)this, addRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.add(opContext);
        addRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value<?> convertToValue(String oid, Object value) throws NamingException {
        ServerStringValue val = null;
        AttributeType attributeType = this.directoryService.getRegistries().getAttributeTypeRegistry().lookup(oid);
        if (attributeType.getSyntax().isHumanReadable()) {
            if (value instanceof String) {
                return new ServerStringValue(attributeType, (String)value);
            }
            if (!(value instanceof byte[])) throw new NamingException("Bad value for the OID " + oid);
            return new ServerStringValue(attributeType, StringTools.utf8ToString((byte[])((byte[])value)));
        }
        if (value instanceof String) {
            return new ServerBinaryValue(attributeType, StringTools.getBytesUtf8((String)((String)value)));
        }
        if (!(value instanceof byte[])) throw new NamingException("Bad value for the OID " + oid);
        return new ServerBinaryValue(attributeType, (byte[])value);
    }

    @Override
    public boolean compare(LdapDN dn, String oid, Object value) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(new CompareOperationContext(this, dn, oid, this.convertToValue(oid, value)));
    }

    @Override
    public boolean compare(LdapDN dn, String oid, Object value, boolean ignoreReferral) throws Exception {
        CompareOperationContext opContext = new CompareOperationContext(this, dn, oid, this.convertToValue(oid, value));
        this.setReferralHandling(opContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.compare(opContext);
    }

    @Override
    public void delete(LdapDN dn) throws Exception {
        this.delete(dn, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void delete(LdapDN dn, DefaultDirectoryService.LogChange log) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, dn);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(opContext);
    }

    @Override
    public void delete(LdapDN dn, boolean ignoreReferral) throws Exception {
        this.delete(dn, ignoreReferral, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void delete(LdapDN dn, boolean ignoreReferral, DefaultDirectoryService.LogChange log) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, dn);
        opContext.setLogChange(log);
        this.setReferralHandling(opContext, ignoreReferral);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(opContext);
    }

    @Override
    public LdapPrincipal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Override
    public AuthenticationLevel getAuthenticationLevel() {
        return this.getEffectivePrincipal().getAuthenticationLevel();
    }

    @Override
    public SocketAddress getClientAddress() {
        return null;
    }

    @Override
    public Set<Control> getControls() {
        return null;
    }

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public LdapPrincipal getEffectivePrincipal() {
        if (this.authorizedPrincipal == null) {
            return this.authenticatedPrincipal;
        }
        return this.authorizedPrincipal;
    }

    @Override
    public Set<OperationContext> getOutstandingOperations() {
        return null;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return null;
    }

    @Override
    public boolean isConfidential() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isAdministrator() {
        String normName = this.getEffectivePrincipal().getJndiName().toNormName();
        return normName.equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    @Override
    public boolean isAnAdministrator() {
        return this.isAdministrator();
    }

    @Override
    public EntryFilteringCursor list(LdapDN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.list(new ListOperationContext((CoreSession)this, dn, aliasDerefMode, returningAttributes));
    }

    @Override
    public EntryFilteringCursor list(LdapDN dn, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, int sizeLimit, int timeLimit) throws Exception {
        ListOperationContext opContext = new ListOperationContext((CoreSession)this, dn, aliasDerefMode, returningAttributes);
        opContext.setSizeLimit(sizeLimit);
        opContext.setTimeLimit(timeLimit);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.list(opContext);
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.lookup(new LookupOperationContext((CoreSession)this, dn));
    }

    @Override
    public ClonedServerEntry lookup(LdapDN dn, String[] attrId) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.lookup(new LookupOperationContext(this, dn, attrId));
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods) throws Exception {
        this.modify(dn, mods, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods, DefaultDirectoryService.LogChange log) throws Exception {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add((Modification)new ServerModification(this.directoryService.getRegistries(), mod));
        }
        ModifyOperationContext opContext = new ModifyOperationContext(this, dn, serverModifications);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(opContext);
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods, boolean ignoreReferral) throws Exception {
        this.modify(dn, mods, ignoreReferral, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods, boolean ignoreReferral, DefaultDirectoryService.LogChange log) throws Exception {
        if (mods == null) {
            return;
        }
        ArrayList<Modification> serverModifications = new ArrayList<Modification>(mods.size());
        for (Modification mod : mods) {
            serverModifications.add((Modification)new ServerModification(this.directoryService.getRegistries(), mod));
        }
        ModifyOperationContext opContext = new ModifyOperationContext(this, dn, serverModifications);
        this.setReferralHandling(opContext, ignoreReferral);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(opContext);
    }

    @Override
    public void move(LdapDN dn, LdapDN newParent) throws Exception {
        this.move(dn, newParent, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void move(LdapDN dn, LdapDN newParent, DefaultDirectoryService.LogChange log) throws Exception {
        MoveOperationContext opContext = new MoveOperationContext(this, dn, newParent);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(opContext);
    }

    @Override
    public void move(LdapDN dn, LdapDN newParent, boolean ignoreReferral) throws Exception {
        this.move(dn, newParent, ignoreReferral, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void move(LdapDN dn, LdapDN newParent, boolean ignoreReferral, DefaultDirectoryService.LogChange log) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveOperationContext opContext = new MoveOperationContext(this, dn, newParent);
        this.setReferralHandling(opContext, ignoreReferral);
        opContext.setLogChange(log);
        operationManager.move(opContext);
    }

    @Override
    public void moveAndRename(LdapDN dn, LdapDN newParent, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void moveAndRename(LdapDN dn, LdapDN newParent, Rdn newRdn, boolean deleteOldRdn, DefaultDirectoryService.LogChange log) throws Exception {
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext(this, dn, newParent, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(opContext);
    }

    @Override
    public void moveAndRename(LdapDN dn, LdapDN newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws Exception {
        this.moveAndRename(dn, newParent, newRdn, deleteOldRdn, ignoreReferral, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void moveAndRename(LdapDN dn, LdapDN newParent, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, DefaultDirectoryService.LogChange log) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext(this, dn, newParent, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        this.setReferralHandling(opContext, ignoreReferral);
        operationManager.moveAndRename(opContext);
    }

    @Override
    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        this.rename(dn, newRdn, deleteOldRdn, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn, DefaultDirectoryService.LogChange log) throws Exception {
        RenameOperationContext opContext = new RenameOperationContext(this, dn, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(opContext);
    }

    @Override
    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral) throws Exception {
        this.rename(dn, newRdn, deleteOldRdn, ignoreReferral, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn, boolean ignoreReferral, DefaultDirectoryService.LogChange log) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        RenameOperationContext opContext = new RenameOperationContext(this, dn, newRdn, deleteOldRdn);
        opContext.setLogChange(log);
        this.setReferralHandling(opContext, ignoreReferral);
        operationManager.rename(opContext);
    }

    @Override
    public EntryFilteringCursor search(LdapDN dn, String filter) throws Exception {
        return this.search(dn, filter, true);
    }

    @Override
    public EntryFilteringCursor search(LdapDN dn, String filter, boolean ignoreReferrals) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        ExprNode filterNode = FilterParser.parse((String)filter);
        SearchOperationContext opContext = new SearchOperationContext(this, dn, SearchScope.OBJECT, filterNode, AliasDerefMode.DEREF_ALWAYS, null);
        this.setReferralHandling(opContext, ignoreReferrals);
        return operationManager.search(opContext);
    }

    @Override
    public EntryFilteringCursor search(LdapDN dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes) throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.search(new SearchOperationContext(this, dn, scope, filter, aliasDerefMode, returningAttributes));
    }

    @Override
    public EntryFilteringCursor search(LdapDN dn, SearchScope scope, ExprNode filter, AliasDerefMode aliasDerefMode, Set<AttributeTypeOptions> returningAttributes, int sizeLimit, int timeLimit) throws Exception {
        SearchOperationContext opContext = new SearchOperationContext(this, dn, scope, filter, aliasDerefMode, returningAttributes);
        opContext.setSizeLimit(sizeLimit);
        opContext.setTimeLimit(timeLimit);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.search(opContext);
    }

    @Override
    public boolean isAnonymous() {
        return this.getEffectivePrincipal().getJndiName().isEmpty();
    }

    @Override
    public boolean compare(InternalCompareRequest compareRequest) throws Exception {
        CompareOperationContext opContext = new CompareOperationContext((CoreSession)this, compareRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        boolean result = operationManager.compare(opContext);
        compareRequest.getResultResponse().addAll(opContext.getResponseControls());
        return result;
    }

    @Override
    public void delete(InternalDeleteRequest deleteRequest) throws Exception {
        this.delete(deleteRequest, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void delete(InternalDeleteRequest deleteRequest, DefaultDirectoryService.LogChange log) throws Exception {
        DeleteOperationContext opContext = new DeleteOperationContext((CoreSession)this, deleteRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.delete(opContext);
        deleteRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public boolean exists(LdapDN dn) throws Exception {
        EntryOperationContext opContext = new EntryOperationContext(this, dn);
        OperationManager operationManager = this.directoryService.getOperationManager();
        return operationManager.hasEntry(opContext);
    }

    @Override
    public void modify(InternalModifyRequest modifyRequest) throws Exception {
        this.modify(modifyRequest, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void modify(InternalModifyRequest modifyRequest, DefaultDirectoryService.LogChange log) throws Exception {
        ModifyOperationContext opContext = new ModifyOperationContext((CoreSession)this, modifyRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.modify(opContext);
        modifyRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void move(InternalModifyDnRequest modifyDnRequest) throws Exception {
        this.move(modifyDnRequest, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void move(InternalModifyDnRequest modifyDnRequest, DefaultDirectoryService.LogChange log) throws Exception {
        MoveOperationContext opContext = new MoveOperationContext((CoreSession)this, modifyDnRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.move(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void moveAndRename(InternalModifyDnRequest modifyDnRequest) throws Exception {
        this.moveAndRename(modifyDnRequest, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void moveAndRename(InternalModifyDnRequest modifyDnRequest, DefaultDirectoryService.LogChange log) throws Exception {
        MoveAndRenameOperationContext opContext = new MoveAndRenameOperationContext((CoreSession)this, modifyDnRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.moveAndRename(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public void rename(InternalModifyDnRequest modifyDnRequest) throws Exception {
        this.rename(modifyDnRequest, DefaultDirectoryService.LogChange.TRUE);
    }

    @Override
    public void rename(InternalModifyDnRequest modifyDnRequest, DefaultDirectoryService.LogChange log) throws Exception {
        RenameOperationContext opContext = new RenameOperationContext((CoreSession)this, modifyDnRequest);
        opContext.setLogChange(log);
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.rename(opContext);
        modifyDnRequest.getResultResponse().addAll(opContext.getResponseControls());
    }

    @Override
    public EntryFilteringCursor search(InternalSearchRequest searchRequest) throws Exception {
        SearchOperationContext opContext = new SearchOperationContext((CoreSession)this, searchRequest);
        OperationManager operationManager = this.directoryService.getOperationManager();
        EntryFilteringCursor cursor = operationManager.search(opContext);
        searchRequest.getResultResponse().addAll(opContext.getResponseControls());
        return cursor;
    }

    @Override
    public void unbind() throws Exception {
        OperationManager operationManager = this.directoryService.getOperationManager();
        operationManager.unbind(new UnbindOperationContext(this));
    }

    @Override
    public void unbind(InternalUnbindRequest unbindRequest) {
    }
}

