/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.util;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.ldappc.Ldappc;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.util.LdapSearchFilter;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import edu.internet2.middleware.subject.Subject;
import edu.vt.middleware.ldap.SearchFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectCache.class);
    private static final int DEFAULT_HASH_ESTIMATE = 25000;
    private Map<String, Hashtable<String, Set<Name>>> subjectIdToDnTables;
    private int subjectIdLookups;
    private int subjectIdTableHits;
    private Ldappc ldappc;

    public SubjectCache(Ldappc ldappc) {
        this.ldappc = ldappc;
        this.init();
    }

    public int getSubjectIdLookups() {
        return this.subjectIdLookups;
    }

    public int getSubjectIdTableHits() {
        return this.subjectIdTableHits;
    }

    public String getSubjectData(Subject subject) {
        return this.getSubjectData(subject, false);
    }

    public String getSubjectData(Subject subject, boolean attributes) {
        String subjData = "null";
        if (subject != null) {
            subjData = "[ NAME = " + subject.getName() + " ][ ID = " + subject.getId() + " ]";
            if (attributes) {
                subjData = subjData + "[ ATTRIBUTES = " + subject.getAttributes() + " ]";
            }
        }
        return subjData;
    }

    public Set<Name> findSubjectDn(Member member) throws NamingException, LdappcException {
        String sourceId = member.getSubjectSourceId();
        if (sourceId.equals(SubjectFinder.internal_getGSA().getId()) && !this.ldappc.getConfig().getProvisionMemberGroups()) {
            return null;
        }
        if (this.subjectIdToDnTables.get(sourceId) == null) {
            this.subjectIdToDnTables.put(sourceId, new Hashtable(25000));
        } else {
            Set<Name> subjectDns = this.subjectIdToDnTables.get(sourceId).get(member.getSubjectId());
            if (subjectDns != null) {
                ++this.subjectIdTableHits;
                LOG.debug("cache found dns '{}' for sourceId '{}' subjectId '{}'", new Object[]{subjectDns, sourceId, member.getSubjectId()});
                return subjectDns;
            }
        }
        String subjectIdentifier = null;
        LdapSearchFilter filter = null;
        if (sourceId.equals(SubjectFinder.internal_getGSA().getId())) {
            Group group = member.toGroup();
            Name groupDN = this.ldappc.calculateGroupDn(group);
            subjectIdentifier = group.getName();
            filter = new LdapSearchFilter(groupDN.toString(), 0, "(objectclass=*)", LdapSearchFilter.OnNotFound.warn, false);
        } else {
            filter = this.ldappc.getConfig().getSourceSubjectLdapFilter(sourceId);
            if (filter == null) {
                throw new LdappcException("Ldap search filter not found using sourceId '" + sourceId + "'");
            }
            String sourceNameAttr = this.ldappc.getConfig().getSourceSubjectNamingAttribute(sourceId);
            if (sourceNameAttr == null) {
                throw new LdappcException("Subject source [ " + sourceId + " ] does not identify a source subject naming attribute");
            }
            LOG.debug("get source attribute '{}' for subject '{}'", (Object)sourceNameAttr, (Object)member.getSubjectId());
            subjectIdentifier = member.getSubject().getAttributeValue(sourceNameAttr);
            if (subjectIdentifier == null) {
                if (sourceNameAttr.equalsIgnoreCase("id")) {
                    subjectIdentifier = member.getSubject().getId();
                }
                if (sourceNameAttr.equalsIgnoreCase("name")) {
                    subjectIdentifier = member.getSubject().getName();
                }
            }
            if (subjectIdentifier == null) {
                throw new LdappcException("Subject " + subjectIdentifier + " ] has no value for attribute [ " + sourceNameAttr + " ]");
            }
        }
        Set<Name> subjectDns = this.findSubjectDn(filter, subjectIdentifier);
        if (subjectDns != null) {
            if (this.subjectIdToDnTables.get(sourceId).get(member.getSubjectId()) == null) {
                this.subjectIdToDnTables.get(sourceId).put(member.getSubjectId(), new LinkedHashSet());
            }
            this.subjectIdToDnTables.get(sourceId).get(member.getSubjectId()).addAll(subjectDns);
            LOG.debug("search found dn '{}' for sourceId '{}' subjectId '{}'", new Object[]{subjectDns, sourceId, member.getSubjectId()});
        }
        return subjectDns;
    }

    private Set<Name> findSubjectDn(LdapSearchFilter filter, String subjectIdentifier) throws NamingException, LdappcException {
        ++this.subjectIdLookups;
        String baseName = filter.getBase();
        String filterExpr = filter.getFilter();
        Object[] filterArgs = new Object[]{subjectIdentifier};
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(filter.getScope());
        searchControls.setReturningAttributes(new String[0]);
        searchControls.setCountLimit(2L);
        String msg = "search for subjectId '" + subjectIdentifier + "' base '" + baseName + "' filter '" + filterExpr + "' args " + Arrays.asList(filterArgs);
        LOG.debug(msg);
        Iterator searchResults = null;
        try {
            SearchFilter searchFilter = new SearchFilter(filterExpr);
            searchFilter.setFilterArgs(filterArgs);
            searchResults = this.ldappc.getContext().search(LdapUtil.escapeForwardSlash(baseName), searchFilter, searchControls);
        }
        catch (NameNotFoundException e) {
            if (filter.getOnNotFound().equals((Object)LdapSearchFilter.OnNotFound.fail)) {
                LOG.error("Subject not found using " + msg, (Throwable)e);
                throw new LdappcException(e);
            }
            if (filter.getOnNotFound().equals((Object)LdapSearchFilter.OnNotFound.warn)) {
                LOG.warn("Subject not found using " + msg);
            }
            return null;
        }
        if (!searchResults.hasNext()) {
            if (filter.getOnNotFound().equals((Object)LdapSearchFilter.OnNotFound.fail)) {
                LOG.error("Subject not found using " + msg);
                throw new LdappcException("Subject not found using " + msg);
            }
            if (filter.getOnNotFound().equals((Object)LdapSearchFilter.OnNotFound.warn)) {
                LOG.warn("Subject not found using " + msg);
            }
            return null;
        }
        LinkedHashSet<Name> subjectDns = new LinkedHashSet<Name>();
        while (searchResults.hasNext()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            if (searchResults.hasNext() && !filter.getMultipleResults()) {
                throw new LdappcException("Multiple entries found using " + msg);
            }
            if (!searchResult.isRelative()) {
                throw new LdappcException("Unable to resolve the reference found using " + msg);
            }
            LOG.trace("found {}", (Object)searchResult.getName());
            LdapName subjectDn = new LdapName(LdapUtil.unescapeForwardSlash(searchResult.getName()));
            subjectDns.add(subjectDn);
        }
        return subjectDns;
    }

    public void init() {
        this.subjectIdLookups = 0;
        this.subjectIdTableHits = 0;
        this.subjectIdToDnTables = new HashMap<String, Hashtable<String, Set<Name>>>();
        Map<String, Integer> estimates = this.ldappc.getConfig().getSourceSubjectHashEstimates();
        for (String source : this.ldappc.getConfig().getSourceSubjectLdapFilters().keySet()) {
            int estimate = 25000;
            if (estimates.get(source) != null) {
                estimate = estimates.get(source);
            }
            if (this.subjectIdToDnTables.get(source) == null) {
                this.subjectIdToDnTables.put(source, new Hashtable(estimate));
                continue;
            }
            this.subjectIdToDnTables.get(source).clear();
        }
    }
}

