/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.util;

import edu.internet2.middleware.ldappc.Ldappc;
import edu.internet2.middleware.ldappc.LdappcOptions;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdapUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUtil.class);
    public static final String OBJECT_CLASS_ATTRIBUTE = "objectClass";
    public static final String EMPTY_NAME = "";
    public static final String MULTIVALUED_RDN_DELIMITER = "+";
    static final char SPACE = ' ';
    static final char LB_SIGN = '#';
    static final char COMMA = ',';
    static final char PLUS_SIGN = '+';
    static final char DOUBLE_QUOTE = '\"';
    static final char BACKWARD_SLASH = '\\';
    static final char LESS_THAN = '<';
    static final char GREATER_THAN = '>';
    static final char SEMI_COLON = ';';
    static final char ASTERIX = '*';
    static final char LEFT_PARENTHESIS = '(';
    static final char RIGHT_PARENTHESIS = ')';
    static final char NUL = '\u0000';
    private static Pattern forwardSlashPattern = Pattern.compile("([^\\\\])/");
    private static Pattern escapedforwardSlashPattern = Pattern.compile("\\\\/");

    private LdapUtil() {
    }

    public static void delete(Ldappc ldappc, Name dn) throws NamingException {
        List<String> childDNs = LdapUtil.getChildDNs(dn.toString(), ldappc.getContext());
        for (String childDN : childDNs) {
            if (ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
                LdapUtil.writeLdif(ldappc.getWriter(), LdapUtil.getLdifDelete(new LdapDN(childDN)));
            }
            if (!ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) continue;
            String msg = "delete '" + dn + "'";
            if (ldappc.getOptions().getLogLdif()) {
                msg = msg + "\n\n" + LdapUtil.getLdifDelete(new LdapDN(childDN));
            }
            LOG.debug(msg);
            ldappc.getContext().delete(LdapUtil.escapeForwardSlash(childDN));
        }
        if (ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
            LdapUtil.writeLdif(ldappc.getWriter(), LdapUtil.getLdifDelete(new LdapDN(dn)));
        }
        if (ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) {
            LOG.debug("delete '{}'", (Object)dn);
            ldappc.getContext().delete(LdapUtil.escapeForwardSlash(dn.toString()));
        }
    }

    public static String makeLdapFilterValueSafe(String value) {
        StringBuffer safeBuf = new StringBuffer();
        if (value != null) {
            char[] valueChars = value.toCharArray();
            block3: for (int i = 0; i < valueChars.length; ++i) {
                switch (valueChars[i]) {
                    case '\u0000': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '\\': {
                        safeBuf.append('\\');
                        if (valueChars[i] == '\u0000') {
                            safeBuf.append("0");
                        }
                        safeBuf.append(Integer.toHexString(valueChars[i]));
                        continue block3;
                    }
                    default: {
                        safeBuf.append(valueChars[i]);
                    }
                }
            }
        }
        return value == null ? value : safeBuf.toString();
    }

    public static String makeLdapNameSafe(String value) {
        StringBuffer safeBuf = new StringBuffer();
        if (value != null) {
            int trailingSpacesStart;
            char[] valueChars = value.toCharArray();
            for (trailingSpacesStart = valueChars.length; trailingSpacesStart > 0 && valueChars[trailingSpacesStart - 1] == ' '; --trailingSpacesStart) {
            }
            int index = 0;
            for (index = 0; index < trailingSpacesStart && (valueChars[index] == ' ' || valueChars[index] == '#'); ++index) {
                safeBuf.append('\\');
                safeBuf.append(valueChars[index]);
            }
            while (index < trailingSpacesStart) {
                switch (valueChars[index]) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        safeBuf.append('\\');
                    }
                }
                safeBuf.append(valueChars[index]);
                ++index;
            }
            while (index < valueChars.length) {
                safeBuf.append('\\');
                safeBuf.append(valueChars[index]);
                ++index;
            }
        }
        return value == null ? value : safeBuf.toString();
    }

    public static String convertParameterToAsterisk(String filter, int parameterIndex) {
        String newFilter = EMPTY_NAME;
        if (filter != null) {
            String regExpr = "\\{\\s*?" + parameterIndex + "\\s*?\\}";
            String asterisk = "*";
            newFilter = filter.replaceAll(regExpr, asterisk);
        }
        return newFilter;
    }

    public static Name getName(NameParser parser, SearchResult searchResult) throws NamingException {
        String entryName = searchResult.getName();
        if (entryName.startsWith("\"") && entryName.endsWith("\"")) {
            entryName = entryName.replaceFirst("^\"", EMPTY_NAME);
            entryName = entryName.replaceFirst("\"$", EMPTY_NAME);
        }
        return parser.parse(entryName);
    }

    public static String getLdif(Attribute attribute) throws NamingException {
        StringBuffer ldif = new StringBuffer();
        NamingEnumeration<?> values = attribute.getAll();
        while (values.hasMore()) {
            String value = values.next().toString();
            ldif.append(attribute.getID() + ": " + value + "\n");
        }
        return ldif.toString();
    }

    public static String getLdif(Attributes attributes) throws NamingException {
        StringBuffer ldif = new StringBuffer();
        NamingEnumeration<? extends Attribute> ae = attributes.getAll();
        while (ae.hasMore()) {
            Attribute attribute = ae.next();
            ldif.append(LdapUtil.getLdif(attribute));
        }
        return ldif.toString();
    }

    public static String getLdifModify(LdapDN dn, ModificationItem[] modificationItems) throws NamingException {
        LdifEntry ldifEntry = new LdifEntry();
        ldifEntry.setChangeType(ChangeType.Modify);
        ldifEntry.setDn(dn);
        for (ModificationItem modificationItem : modificationItems) {
            ClientModification clientModification = new ClientModification();
            clientModification.setOperation(modificationItem.getModificationOp());
            DefaultClientAttribute clientAttribute = new DefaultClientAttribute();
            clientAttribute.setId(modificationItem.getAttribute().getID());
            NamingEnumeration<?> values = modificationItem.getAttribute().getAll();
            while (values.hasMore()) {
                clientAttribute.add(new String[]{values.next().toString()});
            }
            clientModification.setAttribute((EntryAttribute)clientAttribute);
            ldifEntry.addModificationItem((Modification)clientModification);
        }
        return LdifUtils.convertToLdif((LdifEntry)ldifEntry);
    }

    public static String getLdifAdd(LdapDN dn, Attributes attributes) throws NamingException {
        LdifEntry ldifEntry = new LdifEntry();
        ldifEntry.setChangeType(ChangeType.Add);
        ldifEntry.setDn(dn);
        NamingEnumeration<? extends Attribute> a = attributes.getAll();
        while (a.hasMore()) {
            Attribute ax = a.next();
            DefaultClientAttribute clientAttribute = new DefaultClientAttribute();
            clientAttribute.setId(ax.getID());
            NamingEnumeration<?> values = ax.getAll();
            while (values.hasMore()) {
                clientAttribute.add(new String[]{values.next().toString()});
            }
            ldifEntry.addAttribute((EntryAttribute)clientAttribute);
        }
        return LdifUtils.convertToLdif((LdifEntry)ldifEntry);
    }

    public static String getLdifDelete(LdapDN dn) throws NamingException {
        LdifEntry ldifEntry = new LdifEntry();
        ldifEntry.setChangeType(ChangeType.Delete);
        ldifEntry.setDn(dn);
        return LdifUtils.convertToLdif((LdifEntry)ldifEntry);
    }

    public static void writeLdif(BufferedWriter writer, String ldif) {
        try {
            writer.write(ldif);
        }
        catch (IOException e) {
            throw new LdappcException(e);
        }
    }

    public static BufferedWriter openWriter(File file) throws LdappcException {
        try {
            return new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new LdappcException("Unable to open file: " + file, e);
        }
    }

    public static BufferedReader openReader(File file) throws LdappcException {
        try {
            return new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new LdappcException("Unable to open membership file", e);
        }
    }

    public static List<String> getChildDNs(String dn, Ldap ldap) throws NamingException {
        ArrayList<String> tree = new ArrayList<String>();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(new String[0]);
        Iterator results = ldap.search(LdapUtil.escapeForwardSlash(dn), new SearchFilter("objectclass=*"), searchControls);
        while (results.hasNext()) {
            SearchResult sr = (SearchResult)results.next();
            String name = sr.getName();
            tree.addAll(LdapUtil.getChildDNs(name, ldap));
            tree.add(name);
        }
        return tree;
    }

    public static List<String> getChildDNs(String dn, LdapContext ldap) throws NamingException {
        ArrayList<String> tree = new ArrayList<String>();
        SearchControls ctrls = new SearchControls();
        ctrls.setSearchScope(1);
        ctrls.setReturningAttributes(new String[0]);
        NamingEnumeration<SearchResult> results = ldap.search(dn, "objectclass=*", ctrls);
        while (results.hasMore()) {
            SearchResult result = results.next();
            tree.addAll(LdapUtil.getChildDNs(result.getNameInNamespace(), ldap));
            tree.add(result.getNameInNamespace());
        }
        return tree;
    }

    public static Attributes searchAttributes(Ldap ldap, String dn) throws NamingException, LdappcException {
        return LdapUtil.searchAttributes(ldap, dn, null);
    }

    public static Attributes searchAttributes(Ldap ldap, String dn, String[] retAttrs) throws NamingException, LdappcException {
        Iterator<SearchResult> results = LdapUtil.searchEntryDn(ldap, dn, retAttrs);
        if (!results.hasNext()) {
            LOG.debug("No result found for '" + dn + "'");
            throw new LdappcException("No result found for '" + dn + "'");
        }
        SearchResult result = results.next();
        if (results.hasNext()) {
            LOG.error("More than one result returned for '" + dn + "'");
            throw new LdappcException("More than one result returned for " + dn + "'");
        }
        return result.getAttributes();
    }

    public static Iterator<SearchResult> searchEntryDn(Ldap ldap, String dn, String[] retAttrs) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(retAttrs);
        searchControls.setCountLimit(1L);
        return ldap.search(dn, new SearchFilter("objectclass=*"), searchControls);
    }

    public static String escapeForwardSlash(String dn) {
        Matcher matcher = forwardSlashPattern.matcher(dn);
        if (matcher.find()) {
            dn = matcher.replaceAll("$1\\\\/");
        }
        return dn;
    }

    public static String unescapeForwardSlash(String dn) {
        Matcher matcher = escapedforwardSlashPattern.matcher(dn);
        if (matcher.find()) {
            dn = matcher.replaceAll("/");
        }
        return dn;
    }

    public static String canonicalizeDn(String dn) throws InvalidNameException {
        return new LdapDN(LdapUtil.unescapeForwardSlash(dn)).toString();
    }

    public static String getParentDn(String dn) throws InvalidNameException {
        LdapDN ldapDN = new LdapDN(dn);
        ldapDN.remove(ldapDN.getRdns().size() - 1);
        return ldapDN.toString();
    }
}

