/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public final class ExternalSort {
    private static final int DEFAULT_BATCH_SIZE = 200000;
    private static final String BATCH_EXTENSION = "_batch";

    private ExternalSort() {
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java edu.internet2.middleware.ldappc.util.Sort filename batchsize");
            System.exit(1);
        }
        String filename = args[0];
        int batchSize = Integer.parseInt(args[1]);
        try {
            ExternalSort.sort(filename, batchSize);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void sort(String filename) throws IOException {
        ExternalSort.sort(filename, 200000);
    }

    public static void sort(String filename, int batchSize) throws IOException {
        FileReader intialFileInput = new FileReader(filename);
        BufferedReader initFileReader = new BufferedReader(intialFileInput);
        ArrayList<String> batch = new ArrayList<String>();
        int numFiles = 0;
        boolean atEOF = false;
        while (!atEOF) {
            int numLines;
            for (numLines = 0; numLines < batchSize; ++numLines) {
                String line = initFileReader.readLine();
                if (line == null) {
                    atEOF = true;
                    break;
                }
                batch.add(line);
            }
            if (numLines <= 0) continue;
            Collections.sort(batch);
            FileWriter fw = new FileWriter(filename + BATCH_EXTENSION + numFiles);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < batch.size(); ++i) {
                bw.append((String)batch.get(i) + "\n");
            }
            bw.close();
            ++numFiles;
            batch.clear();
        }
        initFileReader.close();
        intialFileInput.close();
        if (numFiles > 0) {
            ExternalSort.mergeFiles(filename, numFiles);
        }
    }

    private static void mergeFiles(String filename, int numFiles) throws IOException {
        File[] mergeFiles = new File[numFiles];
        FileReader[] mergeFileReaders = new FileReader[numFiles];
        BufferedReader[] mergeBufferedReaders = new BufferedReader[numFiles];
        String[] currentLines = new String[numFiles];
        FileWriter fw = new FileWriter(filename);
        BufferedWriter bw = new BufferedWriter(fw);
        for (int i = 0; i < numFiles; ++i) {
            mergeFiles[i] = new File(filename + BATCH_EXTENSION + i);
            mergeFileReaders[i] = new FileReader(mergeFiles[i]);
            mergeBufferedReaders[i] = new BufferedReader(mergeFileReaders[i]);
            currentLines[i] = mergeBufferedReaders[i].readLine();
        }
        boolean filesExhausted = false;
        while (!filesExhausted) {
            int minIndex = ExternalSort.findMinimumLine(currentLines);
            if (minIndex < 0) {
                filesExhausted = true;
                continue;
            }
            bw.append(currentLines[minIndex] + "\n");
            currentLines[minIndex] = mergeBufferedReaders[minIndex].readLine();
        }
        bw.close();
        fw.close();
        for (int i = 0; i < numFiles; ++i) {
            mergeBufferedReaders[i].close();
            mergeFileReaders[i].close();
            mergeFiles[i].delete();
        }
    }

    private static int findMinimumLine(String[] currentLines) {
        int minIndex = -1;
        String minimumLineText = null;
        for (int i = 0; i < currentLines.length; ++i) {
            String currentLine = currentLines[i];
            if (currentLine == null || minimumLineText != null && currentLine.compareTo(minimumLineText) >= 0) continue;
            minimumLineText = currentLine;
            minIndex = i;
        }
        return minIndex;
    }
}

