/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.synchronize;

import edu.internet2.middleware.ldappc.Ldappc;
import edu.internet2.middleware.ldappc.LdappcOptions;
import edu.internet2.middleware.ldappc.exception.ConfigurationException;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.synchronize.AttributeModifier;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import java.util.Arrays;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMembershipSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(StringMembershipSynchronizer.class);
    private Ldappc ldappc;
    private AttributeModifier membershipMods;
    private AttributeModifier objectClassMods;
    private String subject;

    public StringMembershipSynchronizer(Ldappc ldappc, String subject) throws NamingException, ConfigurationException {
        this.ldappc = ldappc;
        this.subject = subject;
        String listAttrName = ldappc.getConfig().getMemberGroupsListAttribute();
        if (listAttrName == null) {
            throw new ConfigurationException("The name of the attribute to store membership group strings is null.");
        }
        this.objectClassMods = new AttributeModifier("objectClass");
        this.membershipMods = new AttributeModifier(listAttrName);
    }

    public void synchronize(Set<String> groupNames) throws NamingException, LdappcException {
        this.initialize();
        for (String groupNameString : groupNames) {
            this.membershipMods.store(groupNameString);
        }
        this.commit();
    }

    public String calculateLdif(Set<String> groupNames) throws LdappcException, NamingException {
        String stringObjectClass = this.ldappc.getConfig().getMemberGroupsListObjectClass();
        if (stringObjectClass != null) {
            this.objectClassMods.store(stringObjectClass);
            this.objectClassMods.retainAll();
        }
        for (String groupNameString : groupNames) {
            this.membershipMods.store(groupNameString);
        }
        BasicAttributes attributes = new BasicAttributes();
        if (this.objectClassMods != null) {
            attributes.put(this.objectClassMods.getAdditions());
        }
        if (this.membershipMods != null) {
            attributes.put(this.membershipMods.getAdditions());
        }
        return LdifUtils.convertToLdif((Attributes)attributes, (LdapDN)new LdapDN(this.getSubject())) + "\n";
    }

    protected void initialize() throws NamingException, LdappcException {
        this.membershipMods.clear();
        this.objectClassMods.clear();
        this.populate();
    }

    protected void populate() throws NamingException {
        LOG.debug("get attributes for '{}' attrs '{}' '{}'", new Object[]{this.getSubject(), this.membershipMods.getAttributeName(), this.objectClassMods.getAttributeName()});
        Attributes attributes = LdapUtil.searchAttributes(this.ldappc.getContext(), LdapUtil.escapeForwardSlash(this.getSubject()), new String[]{this.membershipMods.getAttributeName(), this.objectClassMods.getAttributeName()});
        Attribute attribute = attributes.get(this.membershipMods.getAttributeName());
        this.membershipMods.init(attribute);
        this.objectClassMods.init();
        String stringObjectClass = this.ldappc.getConfig().getMemberGroupsListObjectClass();
        if (stringObjectClass != null) {
            attribute = attributes.get(this.objectClassMods.getAttributeName());
            this.objectClassMods.init(attribute);
            this.objectClassMods.retainAll();
            this.objectClassMods.store(stringObjectClass);
        }
    }

    protected void commit() throws NamingException, LdappcException {
        ModificationItem[] membershipModItems;
        ModificationItem[] objectClassModItems = this.objectClassMods.getModifications();
        int modCnt = objectClassModItems.length + (membershipModItems = this.membershipMods.getModifications()).length;
        if (modCnt > 0) {
            ModificationItem[] mods = new ModificationItem[modCnt];
            int modIndex = 0;
            for (ModificationItem modItem : objectClassModItems) {
                mods[modIndex++] = modItem;
            }
            for (ModificationItem modItem : membershipModItems) {
                mods[modIndex++] = modItem;
            }
            if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
                LdapUtil.writeLdif(this.ldappc.getWriter(), LdapUtil.getLdifModify(new LdapDN(this.getSubject()), mods));
            }
            if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) {
                String msg = "Modify subject '" + this.getSubject() + " " + Arrays.asList(mods);
                if (this.ldappc.getOptions().getLogLdif()) {
                    msg = msg + "\n\n" + LdapUtil.getLdifModify(new LdapDN(this.getSubject()), mods);
                }
                LOG.info(msg);
                this.ldappc.getContext().modifyAttributes(LdapUtil.escapeForwardSlash(this.getSubject()), mods);
            }
        }
    }

    public String getSubject() {
        return this.subject;
    }
}

