/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.synchronize;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.exception.AttributeNotFoundException;
import edu.internet2.middleware.grouper.exception.GroupNotFoundException;
import edu.internet2.middleware.ldappc.Ldappc;
import edu.internet2.middleware.ldappc.LdappcConfig;
import edu.internet2.middleware.ldappc.LdappcOptions;
import edu.internet2.middleware.ldappc.exception.ConfigurationException;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.synchronize.AttributeModifier;
import edu.internet2.middleware.ldappc.synchronize.DnAttributeModifier;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestContext;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.subject.Source;
import edu.internet2.middleware.subject.Subject;
import edu.internet2.middleware.subject.SubjectNotFoundException;
import edu.vt.middleware.ldap.SearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupEntrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(GroupEntrySynchronizer.class);
    private Ldappc ldappc;
    private static final int DEFAULT_HASH_SIZE = 100000;
    private Set<Name> deleteOus;
    private Set<Name> processedOus;
    private Set<Name> deleteGroups;
    private Set<Name> processedGroups;
    private AttributeModifier objectClassMods;
    private AttributeModifier memberDnMods;
    private AttributeModifier memberNameMods;
    private AttributeModifier rdnMods;
    private BasicAttributes mappedLdapAttributes;

    public GroupEntrySynchronizer(Ldappc ldappc, boolean provisionMemberDns) throws NamingException, ConfigurationException {
        String attrName;
        this.ldappc = ldappc;
        int estimate = ldappc.getConfig().getGroupHashEstimate();
        if (estimate == 0) {
            estimate = 100000;
        }
        LOG.debug("Group initial cache size = " + estimate);
        this.deleteOus = new HashSet<Name>(estimate);
        this.processedOus = new HashSet<Name>(estimate);
        this.deleteGroups = new HashSet<Name>(estimate);
        this.processedGroups = new HashSet<Name>(estimate);
        this.mappedLdapAttributes = new BasicAttributes(true);
        if (LdappcConfig.GroupDNStructure.flat.equals((Object)ldappc.getConfig().getGroupDnStructure()) && ldappc.getConfig().getGroupDnGrouperAttribute() == null) {
            throw new ConfigurationException("Group DN grouper attribute is not defined.");
        }
        if (ldappc.getConfig().getGroupDnObjectClass() == null) {
            throw new ConfigurationException("Group ldap entry object class is not defined.");
        }
        String rdnAttrName = ldappc.getConfig().getGroupDnRdnAttribute();
        if (rdnAttrName == null || "ou".equalsIgnoreCase(rdnAttrName)) {
            throw new ConfigurationException("Group ldap entry RDN attribute name is invalid.");
        }
        this.rdnMods = new AttributeModifier(rdnAttrName);
        this.objectClassMods = new AttributeModifier("objectClass");
        this.memberDnMods = null;
        if (ldappc.getConfig().isGroupMembersDnListed()) {
            attrName = ldappc.getConfig().getGroupMembersDnListAttribute();
            if (attrName == null) {
                throw new ConfigurationException("Group members DN list attribute name is not defined.");
            }
            if (provisionMemberDns) {
                this.memberDnMods = new DnAttributeModifier(attrName, ldappc.getConfig().getGroupMembersDnListEmptyValue());
            }
        }
        this.memberNameMods = null;
        if (ldappc.getConfig().isGroupMembersNameListed()) {
            attrName = ldappc.getConfig().getGroupMembersNameListAttribute();
            if (attrName == null) {
                throw new ConfigurationException("Group members name list attribute name is not defined.");
            }
            if (provisionMemberDns) {
                this.memberNameMods = new AttributeModifier(attrName, ldappc.getConfig().getGroupMembersNameListEmptyValue());
            }
        }
        Map<String, List<String>> attributeMap = ldappc.getConfig().getGroupAttributeMapping();
        for (String grouperAttr : attributeMap.keySet()) {
            for (String ldapAttr : attributeMap.get(grouperAttr)) {
                if (ldapAttr.equalsIgnoreCase(this.objectClassMods.getAttributeName())) {
                    throw new LdappcException("Unable to map an attribute whose name matches '" + this.objectClassMods.getAttributeName() + "'");
                }
                if (this.memberDnMods != null && ldapAttr.equalsIgnoreCase(this.memberDnMods.getAttributeName())) {
                    throw new LdappcException("Unable to map an attribute whose name matches '" + this.memberDnMods.getAttributeName() + "'");
                }
                if (this.memberNameMods != null && ldapAttr.equalsIgnoreCase(this.memberNameMods.getAttributeName())) {
                    throw new LdappcException("Unable to map an attribute whose name matches '" + this.memberNameMods.getAttributeName() + "'");
                }
                if (this.mappedLdapAttributes.get(ldapAttr) != null) continue;
                String emptyValue = ldappc.getConfig().getGroupAttributeMappingLdapEmptyValue(ldapAttr);
                this.mappedLdapAttributes.put(ldapAttr, new AttributeModifier(ldapAttr, emptyValue));
            }
        }
        Map<String, List<String>> resolverMap = ldappc.getConfig().getAttributeResolverMapping();
        for (String resolverAttr : resolverMap.keySet()) {
            for (String ldapAttr : resolverMap.get(resolverAttr)) {
                if (ldapAttr.equalsIgnoreCase(this.objectClassMods.getAttributeName())) {
                    throw new LdappcException("Unable to map an attribute whose name matches '" + this.objectClassMods.getAttributeName() + "'");
                }
                if (this.memberDnMods != null && ldapAttr.equalsIgnoreCase(this.memberDnMods.getAttributeName())) {
                    throw new LdappcException("Unable to map an attribute whose name matches '" + this.memberDnMods.getAttributeName() + "'");
                }
                if (this.memberNameMods != null && ldapAttr.equalsIgnoreCase(this.memberNameMods.getAttributeName())) {
                    throw new LdappcException("Unable to map an attribute whose name matches '" + this.memberNameMods.getAttributeName() + "'");
                }
                if (this.mappedLdapAttributes.get(ldapAttr) != null) continue;
                String emptyValue = ldappc.getConfig().getAttributeResolverMappingLdapEmptyValue(ldapAttr);
                this.mappedLdapAttributes.put(ldapAttr, new AttributeModifier(ldapAttr, emptyValue));
            }
        }
    }

    public void synchronize(Set<Group> groups) throws NamingException, LdappcException {
        this.initialize();
        for (Group group : groups) {
            this.performInclude(group, this.ldappc.determineStatus(group), groups);
        }
        this.commit();
    }

    public String calculateLdif(Group group, Set<Group> groups) throws LdappcException, NamingException {
        this.initializeInclude(group);
        Name groupDn = this.ldappc.calculateGroupDn(group);
        Rdn rdn = new Rdn(groupDn.get(groupDn.size() - 1));
        this.rdnMods.store(rdn.getValue().toString());
        this.storeGroupData(group, groups);
        BasicAttributes attributes = new BasicAttributes(true);
        attributes.put(this.objectClassMods.getAdditions());
        if (this.memberDnMods != null) {
            attributes.put(this.memberDnMods.getAdditions());
        }
        if (this.memberNameMods != null) {
            attributes.put(this.memberNameMods.getAdditions());
        }
        attributes.put(this.rdnMods.getAdditions());
        NamingEnumeration<Attribute> ldapAttrEnum = this.mappedLdapAttributes.getAll();
        while (ldapAttrEnum.hasMore()) {
            Attribute attribute = ldapAttrEnum.next();
            AttributeModifier modifier = (AttributeModifier)attribute.get();
            Attribute toAdd = modifier.getAdditions();
            if (toAdd.size() <= 0) continue;
            Attribute attr = attributes.get(toAdd.getID());
            if (attr == null) {
                attributes.put(toAdd);
                continue;
            }
            NamingEnumeration<?> values = toAdd.getAll();
            while (values.hasMoreElements()) {
                attr.add(values.next());
            }
        }
        return LdifUtils.convertToLdif((Attributes)attributes, (LdapDN)new LdapDN(groupDn));
    }

    protected void performInclude(Group group, int status, Set<Group> groups) throws NamingException, LdappcException {
        LOG.debug("Starting include of group {}", (Object)group.getName());
        this.initializeInclude(group);
        Name groupDn = this.buildGroupDn(group);
        if (!this.processedGroups.contains(groupDn)) {
            if (this.deleteGroups.remove(groupDn)) {
                if (status == 0 || status == 1 || status == 3) {
                    this.updateGroupEntry(groupDn, group, groups);
                }
            } else {
                this.addGroupEntry(groupDn, group, groups);
            }
            this.updateProcessedOus(groupDn);
            this.processedGroups.add(groupDn);
        } else {
            LOG.error("Group entry identified by {} has already been encountered, and will not be processed another time.", (Object)groupDn);
        }
    }

    protected void updateGroupEntry(Name groupDn, Group group, Set<Group> groups) throws NamingException {
        this.initGroupData(groupDn);
        this.storeGroupData(group, groups);
        Vector<AttributeModifier> modifiers = new Vector<AttributeModifier>();
        modifiers.add(this.objectClassMods);
        if (this.memberDnMods != null) {
            if (this.memberDnMods.getRetainedValues().size() == 0 && this.memberDnMods.getAdds().size() == 0 && this.memberDnMods.getNoValue() != null) {
                this.memberDnMods.store(this.memberDnMods.getNoValue());
            }
            modifiers.add(this.memberDnMods);
        }
        if (this.memberNameMods != null) {
            if (this.memberNameMods.getRetainedValues().size() == 0 && this.memberNameMods.getAdds().size() == 0 && this.memberNameMods.getNoValue() != null) {
                this.memberNameMods.store(this.memberNameMods.getNoValue());
            }
            modifiers.add(this.memberNameMods);
        }
        NamingEnumeration<Attribute> ldapAttrEnum = this.mappedLdapAttributes.getAll();
        while (ldapAttrEnum.hasMore()) {
            Attribute attribute = ldapAttrEnum.next();
            modifiers.add((AttributeModifier)attribute.get());
        }
        Vector<ModificationItem> modifications = new Vector<ModificationItem>();
        for (AttributeModifier modifier : modifiers) {
            ModificationItem[] items = modifier.getModifications();
            for (int i = 0; i < items.length; ++i) {
                modifications.add(items[i]);
            }
        }
        ModificationItem[] modificationItems = new ModificationItem[modifications.size()];
        for (int i = 0; i < modificationItems.length; ++i) {
            modificationItems[i] = (ModificationItem)modifications.get(i);
        }
        if (modificationItems.length > 0) {
            if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
                if (this.ldappc.getConfig().getBundleModifications()) {
                    LdapUtil.writeLdif(this.ldappc.getWriter(), LdapUtil.getLdifModify(new LdapDN(groupDn), modificationItems));
                } else {
                    ModificationItem[] arr$ = modificationItems;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        ModificationItem modificationItem = arr$[i$];
                        LdapUtil.writeLdif(this.ldappc.getWriter(), LdapUtil.getLdifModify(new LdapDN(groupDn), new ModificationItem[]{modificationItem}));
                    }
                }
            }
            if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) {
                if (this.ldappc.getConfig().getBundleModifications()) {
                    String msg = "Modify '" + groupDn + "' " + Arrays.asList(modificationItems);
                    if (this.ldappc.getOptions().getLogLdif()) {
                        msg = msg + "\n\n" + LdapUtil.getLdifModify(new LdapDN(groupDn), modificationItems);
                    }
                    LOG.info(msg);
                    this.ldappc.getContext().modifyAttributes(LdapUtil.escapeForwardSlash(groupDn.toString()), modificationItems);
                } else {
                    for (ModificationItem modificationItem : modificationItems) {
                        ModificationItem[] unbundledMod = new ModificationItem[]{modificationItem};
                        String msg = "Modify '" + groupDn + "' " + Arrays.asList(unbundledMod);
                        if (this.ldappc.getOptions().getLogLdif()) {
                            msg = msg + "\n\n" + LdapUtil.getLdifModify(new LdapDN(groupDn), unbundledMod);
                        }
                        LOG.info(msg);
                        this.ldappc.getContext().modifyAttributes(LdapUtil.escapeForwardSlash(groupDn.toString()), unbundledMod);
                    }
                }
            }
        }
    }

    protected void initGroupData(Name groupDn) throws NamingException {
        Vector<String> wantedAttr = new Vector<String>();
        wantedAttr.add(this.rdnMods.getAttributeName());
        if (this.memberDnMods != null) {
            wantedAttr.add(this.memberDnMods.getAttributeName());
        }
        if (this.memberNameMods != null) {
            wantedAttr.add(this.memberNameMods.getAttributeName());
        }
        NamingEnumeration<String> mappedLdapAttrNames = this.mappedLdapAttributes.getIDs();
        while (mappedLdapAttrNames.hasMore()) {
            wantedAttr.add(mappedLdapAttrNames.next());
        }
        wantedAttr.add(this.objectClassMods.getAttributeName());
        LOG.debug("get group attributes '" + groupDn + "' attrs " + wantedAttr);
        Attributes attributes = LdapUtil.searchAttributes(this.ldappc.getContext(), LdapUtil.escapeForwardSlash(groupDn.toString()), wantedAttr.toArray(new String[0]));
        this.populateAttrModifier(attributes, this.rdnMods);
        if (this.memberDnMods != null) {
            this.populateAttrModifier(attributes, this.memberDnMods);
        }
        if (this.memberNameMods != null) {
            this.populateAttrModifier(attributes, this.memberNameMods);
        }
        NamingEnumeration<Attribute> mappedLdapAttributeEnum = this.mappedLdapAttributes.getAll();
        while (mappedLdapAttributeEnum.hasMore()) {
            Attribute ldapAttribute = mappedLdapAttributeEnum.next();
            this.populateAttrModifier(attributes, (AttributeModifier)ldapAttribute.get());
        }
        this.populateAttrModifier(attributes, this.objectClassMods);
        this.objectClassMods.retainAll();
    }

    private void populateAttrModifier(Attributes attributes, AttributeModifier modifier) throws NamingException {
        Attribute attribute = attributes.get(modifier.getAttributeName());
        if (attribute != null) {
            modifier.init(attribute);
            attributes.remove(modifier.getAttributeName());
        }
    }

    protected void storeGroupData(Group group, Set<Group> groups) throws NamingException, LdappcException {
        this.storeObjectClassData();
        Set members = group.getMembers();
        if (members.isEmpty()) {
            if (this.memberDnMods != null && this.memberDnMods.getNoValue() != null) {
                this.memberDnMods.store(this.memberDnMods.getNoValue());
            }
            if (this.memberNameMods != null && this.memberNameMods.getNoValue() != null) {
                this.memberNameMods.store(this.memberNameMods.getNoValue());
            }
        } else {
            for (Member member : members) {
                Set<Name> subjectDns;
                Subject subject;
                block38: {
                    subject = null;
                    try {
                        subject = member.getSubject();
                    }
                    catch (SubjectNotFoundException snfe) {
                        LOG.warn("Subject not found", (Throwable)snfe);
                        continue;
                    }
                    if (!this.ldappc.getConfig().getProvisionMemberGroupsIgnoreQueries() && subject.getSourceId().equals(SubjectFinder.internal_getGSA().getId())) {
                        try {
                            Group memberGroup = member.toGroup();
                            if (!groups.contains(memberGroup)) {
                                LOG.debug("Ignoring member group not in group-queries " + memberGroup);
                            }
                            break block38;
                        }
                        catch (GroupNotFoundException e) {
                            LOG.warn("Unable to find group for member " + member, (Throwable)e);
                        }
                        continue;
                    }
                }
                if (this.memberDnMods != null && (subjectDns = this.ldappc.getSubjectCache().findSubjectDn(member)) != null) {
                    for (Name subjectDn : subjectDns) {
                        this.memberDnMods.store(subjectDn.toString());
                    }
                }
                if (this.memberNameMods == null) continue;
                try {
                    Source source = subject.getSource();
                    if (source == null) {
                        throw new LdappcException("Source is null");
                    }
                    String nameAttribute = this.ldappc.getConfig().getGroupMembersNameListNamingAttribute(source.getId());
                    if (nameAttribute != null) {
                        String nameValue = subject.getAttributeValue(nameAttribute);
                        if (nameValue == null) {
                            if (nameAttribute.equalsIgnoreCase("id")) {
                                nameValue = subject.getId();
                            }
                            if (nameAttribute.equalsIgnoreCase("name")) {
                                nameValue = subject.getName();
                            }
                        }
                        if (nameValue != null) {
                            this.memberNameMods.store(nameValue);
                            continue;
                        }
                        throw new LdappcException("Naming attribute [" + nameAttribute + "] is not defined.");
                    }
                    throw new LdappcException("No group members name list naming attribute defined for source id [" + source.getId() + "]");
                }
                catch (Exception e) {
                    LOG.warn(this.getErrorData(subject), (Throwable)e);
                }
            }
        }
        Map<String, List<String>> attributeMap = this.ldappc.getConfig().getGroupAttributeMapping();
        for (String groupAttribute : attributeMap.keySet()) {
            String groupAttributeValue = null;
            try {
                groupAttributeValue = group.getAttributeOrFieldValue(groupAttribute, false, false);
            }
            catch (AttributeNotFoundException e) {
                groupAttributeValue = null;
            }
            for (String ldapAttr : attributeMap.get(groupAttribute)) {
                Attribute attribute = this.mappedLdapAttributes.get(ldapAttr);
                AttributeModifier attributeModifier = (AttributeModifier)attribute.get();
                if (groupAttributeValue != null && groupAttributeValue.length() > 0) {
                    attributeModifier.store(groupAttributeValue);
                    continue;
                }
                if (attributeModifier.getNoValue() == null) continue;
                attributeModifier.store(attributeModifier.getNoValue());
            }
        }
        Map<String, List<String>> resolverMap = this.ldappc.getConfig().getAttributeResolverMapping();
        if (!resolverMap.isEmpty()) {
            try {
                BaseSAMLProfileRequestContext attributeRequestContext = new BaseSAMLProfileRequestContext();
                attributeRequestContext.setPrincipalName(group.getName());
                Map attributes = this.ldappc.getAttributeAuthority().getAttributes((AttributeRequestContext)attributeRequestContext);
                if (LOG.isDebugEnabled()) {
                    for (String key : attributes.keySet()) {
                        for (Object value : ((BaseAttribute)attributes.get(key)).getValues()) {
                            LOG.trace("resolver returned '{}' : {}", (Object)key, (Object)PSPUtil.getString(value));
                        }
                    }
                }
                for (String resolverAttribute : resolverMap.keySet()) {
                    BaseAttribute baseAttribute = (BaseAttribute)attributes.get(resolverAttribute);
                    if (baseAttribute == null) {
                        LOG.trace("No attribute was returned from the resolver for '{}'", (Object)resolverAttribute);
                        continue;
                    }
                    Collection resolverAttributeValues = baseAttribute.getValues();
                    ArrayList<String> stringResolverAttributeValues = new ArrayList<String>();
                    for (Object resolverAttributeValue : resolverAttributeValues) {
                        if (resolverAttributeValue == null || !(resolverAttributeValue instanceof String) || ((String)resolverAttributeValue).length() <= 0) continue;
                        stringResolverAttributeValues.add(resolverAttributeValue.toString());
                    }
                    for (String ldapAttr : resolverMap.get(resolverAttribute)) {
                        Attribute attribute = this.mappedLdapAttributes.get(ldapAttr);
                        AttributeModifier attributeModifier = (AttributeModifier)attribute.get();
                        if (stringResolverAttributeValues.isEmpty() && attributeModifier.getNoValue() != null) {
                            attributeModifier.store(attributeModifier.getNoValue());
                            continue;
                        }
                        for (String stringResolverAttributeValue : stringResolverAttributeValues) {
                            attributeModifier.store(stringResolverAttributeValue);
                        }
                    }
                }
            }
            catch (AttributeRequestException e) {
                LOG.error("Unable to resolve attributes : " + e.getMessage(), (Throwable)e);
                throw new LdappcException("Unable to resolve attributes", e);
            }
        }
    }

    protected void storeObjectClassData() throws NamingException {
        Set<String> arMapOC;
        Set<String> attrMapOC;
        String objectClass;
        this.objectClassMods.store(this.ldappc.getConfig().getGroupDnObjectClass());
        if (this.memberDnMods != null && (objectClass = this.ldappc.getConfig().getGroupMembersDnListObjectClass()) != null) {
            this.objectClassMods.store(objectClass);
        }
        if (this.memberNameMods != null && (objectClass = this.ldappc.getConfig().getGroupMembersNameListObjectClass()) != null) {
            this.objectClassMods.store(objectClass);
        }
        if ((attrMapOC = this.ldappc.getConfig().getGroupAttributeMappingObjectClass()) != null) {
            for (String objClass : attrMapOC) {
                this.objectClassMods.store(objClass);
            }
        }
        if ((arMapOC = this.ldappc.getConfig().getAttributeResolverMappingObjectClass()) != null) {
            for (String objClass : arMapOC) {
                this.objectClassMods.store(objClass);
            }
        }
    }

    protected void addGroupEntry(Name groupDn, Group group, Set<Group> groups) throws NamingException {
        Attribute attribute;
        this.storeGroupData(group, groups);
        Vector<AttributeModifier> modifiers = new Vector<AttributeModifier>();
        modifiers.add(this.objectClassMods);
        modifiers.add(this.rdnMods);
        NamingEnumeration<Attribute> ldapAttrEnum = this.mappedLdapAttributes.getAll();
        while (ldapAttrEnum.hasMore()) {
            Attribute attribute2 = ldapAttrEnum.next();
            modifiers.add((AttributeModifier)attribute2.get());
        }
        Vector<AttributeModifier> memberModifiers = new Vector<AttributeModifier>();
        if (this.memberDnMods != null) {
            if (this.memberDnMods.getAdditions().size() == 0 && this.memberDnMods.getNoValue() != null) {
                this.memberDnMods.store(this.memberDnMods.getNoValue());
            }
            memberModifiers.add(this.memberDnMods);
        } else if (this.ldappc.getConfig().isGroupMembersDnListed() && this.ldappc.getConfig().getGroupMembersDnListEmptyValue() != null) {
            DnAttributeModifier memberDnModsEmptyValue = new DnAttributeModifier(this.ldappc.getConfig().getGroupMembersDnListAttribute(), this.ldappc.getConfig().getGroupMembersDnListEmptyValue());
            memberDnModsEmptyValue.store(memberDnModsEmptyValue.getNoValue());
            memberModifiers.add(memberDnModsEmptyValue);
        }
        if (this.memberNameMods != null) {
            if (this.memberNameMods.getAdditions().size() == 0 && this.memberNameMods.getNoValue() != null) {
                this.memberNameMods.store(this.memberNameMods.getNoValue());
            }
            memberModifiers.add(this.memberNameMods);
        } else if (this.ldappc.getConfig().isGroupMembersNameListed() && this.ldappc.getConfig().getGroupMembersNameListEmptyValue() != null) {
            AttributeModifier memberNameModsEmptyValue = new AttributeModifier(this.ldappc.getConfig().getGroupMembersNameListAttribute(), this.ldappc.getConfig().getGroupMembersNameListEmptyValue());
            memberNameModsEmptyValue.store(memberNameModsEmptyValue.getNoValue());
            memberModifiers.add(memberNameModsEmptyValue);
        }
        BasicAttributes attributes = new BasicAttributes(true);
        for (AttributeModifier modifier : modifiers) {
            attribute = modifier.getAdditions();
            if (attribute.size() <= 0) continue;
            Attribute attr = attributes.get(attribute.getID());
            if (attr == null) {
                attributes.put(attribute);
                continue;
            }
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                attr.add(values.next());
            }
        }
        if (!this.ldappc.getConfig().getCreateGroupThenModifyMembers()) {
            for (AttributeModifier modifier : memberModifiers) {
                attribute = modifier.getAdditions();
                if (attribute.size() <= 0) continue;
                attributes.put(attribute);
            }
        }
        if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
            LdapUtil.writeLdif(this.ldappc.getWriter(), LdapUtil.getLdifAdd(new LdapDN(groupDn), attributes));
        }
        if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) {
            String msg = "Creating '" + groupDn + "' attrs " + attributes;
            if (this.ldappc.getOptions().getLogLdif()) {
                msg = msg + "\n\n" + LdapUtil.getLdifAdd(new LdapDN(groupDn), attributes);
            }
            LOG.info(msg);
            this.ldappc.getContext().create(LdapUtil.escapeForwardSlash(groupDn.toString()), (Attributes)attributes);
        }
        if (this.ldappc.getConfig().getCreateGroupThenModifyMembers()) {
            Vector<ModificationItem> modifications = new Vector<ModificationItem>();
            for (AttributeModifier modifier : memberModifiers) {
                for (ModificationItem modItem : modifier.getModifications()) {
                    modifications.add(modItem);
                }
            }
            if (!modifications.isEmpty()) {
                if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
                    LdapUtil.writeLdif(this.ldappc.getWriter(), LdapUtil.getLdifModify(new LdapDN(groupDn), modifications.toArray(new ModificationItem[0])));
                }
                if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) {
                    String msg = "Modify '" + groupDn + "' " + modifications;
                    if (this.ldappc.getOptions().getLogLdif()) {
                        msg = msg + "\n\n" + LdapUtil.getLdifModify(new LdapDN(groupDn), modifications.toArray(new ModificationItem[0]));
                    }
                    LOG.info(msg);
                    this.ldappc.getContext().modifyAttributes(LdapUtil.escapeForwardSlash(groupDn.toString()), modifications.toArray(new ModificationItem[0]));
                }
            }
        }
    }

    protected Name buildGroupDn(Group group) throws NamingException, LdappcException {
        if (LdappcConfig.GroupDNStructure.bushy.equals((Object)this.ldappc.getConfig().getGroupDnStructure())) {
            this.buildStemOuEntries(group);
        }
        Name groupDn = this.ldappc.calculateGroupDn(group);
        Rdn rdn = new Rdn(groupDn.get(groupDn.size() - 1));
        this.rdnMods.store(rdn.getValue().toString());
        return groupDn;
    }

    protected void buildStemOuEntries(Group group) throws NamingException {
        List<Name> stemDns = this.ldappc.calculateStemDns(group);
        for (Name stemDn : stemDns) {
            if (this.processedOus.contains(stemDn) || this.deleteOus.contains(stemDn)) continue;
            BasicAttributes attributes = this.ldappc.calculateStemAttributes(stemDn);
            if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.DRYRUN)) {
                LdapUtil.writeLdif(this.ldappc.getWriter(), LdapUtil.getLdifAdd(new LdapDN(stemDn), attributes));
            }
            if (this.ldappc.getOptions().getMode().equals((Object)LdappcOptions.ProvisioningMode.PROVISION)) {
                String msg = "Creating '" + stemDn + "' attrs " + attributes;
                if (this.ldappc.getOptions().getLogLdif()) {
                    msg = msg + "\n\n" + LdapUtil.getLdifAdd(new LdapDN(stemDn), attributes);
                }
                LOG.info(msg);
                this.ldappc.getContext().create(LdapUtil.escapeForwardSlash(stemDn.toString()), (Attributes)attributes);
            }
            this.deleteOus.add((Name)stemDn.clone());
        }
    }

    protected void updateProcessedOus(Name groupDn) {
        for (int i = this.ldappc.getRootDn().size() + 1; i < groupDn.size(); ++i) {
            Name stemDn = groupDn.getPrefix(i);
            this.deleteOus.remove(stemDn);
            this.processedOus.add(stemDn);
        }
    }

    protected void initialize() throws NamingException, LdappcException {
        this.processedOus.clear();
        this.deleteOus.clear();
        this.processedGroups.clear();
        this.deleteGroups.clear();
        this.clearRoot();
        this.populate();
    }

    protected void clearRoot() throws NamingException {
        String filter = "(objectClass=" + this.ldappc.getConfig().getGroupDnObjectClass() + ")";
        if (LdappcConfig.GroupDNStructure.bushy.equals((Object)this.ldappc.getConfig().getGroupDnStructure())) {
            filter = "(|" + filter + "(" + "objectClass" + "=" + "organizationalUnit" + "))";
        }
        filter = "(!" + filter + ")";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setCountLimit(0L);
        LOG.debug("search base '" + this.ldappc.getRootDn() + "' filter '" + filter + "'");
        Iterator searchResults = this.ldappc.getContext().search(LdapUtil.escapeForwardSlash(this.ldappc.getRootDn().toString()), new SearchFilter(filter), searchControls);
        while (searchResults.hasNext()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            if (searchResult.isRelative()) {
                String entryName = searchResult.getName();
                if (entryName.length() == 0) continue;
                LdapName entryDn = new LdapName(entryName);
                if (this.ldappc.getRootDn().equals(entryDn)) continue;
                try {
                    this.ldappc.getContext().list(LdapUtil.escapeForwardSlash(((Object)entryDn).toString()));
                }
                catch (NamingException ne) {
                    continue;
                }
                try {
                    LdapUtil.delete(this.ldappc, entryDn);
                }
                catch (Exception e) {
                    LOG.warn("Unable to delete " + entryDn, (Throwable)e);
                }
                continue;
            }
            LOG.error("Unable to handle LDAP URL references: {}", (Object)searchResult.getName());
        }
    }

    protected void populate() throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setCountLimit(0L);
        searchControls.setReturningAttributes(new String[0]);
        String filter = "(objectClass=" + this.ldappc.getConfig().getGroupDnObjectClass() + ")";
        this.populateDns(this.deleteGroups, filter, searchControls);
        LOG.debug("found " + this.deleteGroups.size() + " groups");
        if (LdappcConfig.GroupDNStructure.bushy.equals((Object)this.ldappc.getConfig().getGroupDnStructure())) {
            filter = "(objectClass=organizationalUnit)";
            this.populateDns(this.deleteOus, filter, searchControls);
            LOG.debug("found " + this.deleteOus.size() + " ous");
        }
    }

    protected void populateDns(Set<Name> dns, String filter, SearchControls searchControls) throws NamingException {
        LOG.debug("search base '{}' filter '{}'", (Object)this.ldappc.getRootDn(), (Object)filter);
        Iterator searchResults = this.ldappc.getContext().search(LdapUtil.escapeForwardSlash(this.ldappc.getRootDn().toString()), new SearchFilter(filter), searchControls);
        while (searchResults.hasNext()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            if (searchResult.isRelative()) {
                String entryName = searchResult.getName();
                if (entryName.length() == 0) continue;
                LdapName entryDn = new LdapName(entryName);
                if (this.ldappc.getRootDn().equals(entryDn)) continue;
                dns.add(entryDn);
                continue;
            }
            LOG.error("Unable to handle LDAP URL references: {}", (Object)searchResult.getName());
        }
    }

    protected void initializeInclude(Group group) throws NamingException {
        this.objectClassMods.clear();
        this.rdnMods.clear();
        if (this.memberDnMods != null) {
            this.memberDnMods.clear();
        }
        if (this.memberNameMods != null) {
            this.memberNameMods.clear();
        }
        NamingEnumeration<Attribute> ldapAttrEnum = this.mappedLdapAttributes.getAll();
        while (ldapAttrEnum.hasMore()) {
            Attribute attribute = ldapAttrEnum.next();
            ((AttributeModifier)attribute.get()).clear();
        }
    }

    protected void commit() throws NamingException, LdappcException {
        for (Name dn : this.deleteGroups) {
            LdapUtil.delete(this.ldappc, dn);
        }
        for (Name dn : this.deleteOus) {
            try {
                this.ldappc.getContext().list(LdapUtil.escapeForwardSlash(dn.toString()));
            }
            catch (NamingException ne) {
                continue;
            }
            LdapUtil.delete(this.ldappc, dn);
        }
    }

    protected String getErrorData(Subject subject) {
        return "SUBJECT[" + this.ldappc.getSubjectCache().getSubjectData(subject) + "]";
    }

    protected String getErrorData(Group group) {
        return "GROUP[" + Ldappc.getGroupData(group) + "]";
    }

    protected String getErrorData(Member member) {
        return "MEMBER[" + Ldappc.getMemberData(member) + "]";
    }
}

