/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningResponse;
import edu.internet2.middleware.ldappc.spml.request.SynchronizedResponse;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.DeleteResponse;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.util.Spml2Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncResponse
extends ProvisioningResponse {
    public void addResponse(AddResponse addResponse) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)addResponse));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public void addResponse(ModifyResponse modifyResponse) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)modifyResponse));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public void addResponse(DeleteResponse deleteResponse) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)deleteResponse));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public void addResponse(Response response) throws LdappcException {
        if (response instanceof AddResponse) {
            this.addResponse((AddResponse)response);
        } else if (response instanceof DeleteResponse) {
            this.addResponse((DeleteResponse)response);
        } else if (response instanceof ModifyResponse) {
            this.addResponse((ModifyResponse)response);
        } else if (response instanceof SynchronizedResponse) {
            this.addResponse((SynchronizedResponse)response);
        } else {
            throw new LdappcException("Response " + response.getClass() + " is not supported.");
        }
    }

    public void addResponse(SynchronizedResponse synchronizedResponse) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)synchronizedResponse));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public List<AddResponse> getAddResponses() {
        ArrayList<AddResponse> requests = new ArrayList<AddResponse>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof AddResponse)) continue;
            requests.add((AddResponse)o);
        }
        return requests;
    }

    public List<DeleteResponse> getDeleteResponses() {
        ArrayList<DeleteResponse> requests = new ArrayList<DeleteResponse>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof DeleteResponse)) continue;
            requests.add((DeleteResponse)o);
        }
        return requests;
    }

    public List<ModifyResponse> getModifyResponses() {
        ArrayList<ModifyResponse> requests = new ArrayList<ModifyResponse>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof ModifyResponse)) continue;
            requests.add((ModifyResponse)o);
        }
        return requests;
    }

    public List<Response> getAddDeleteModifyResponses() {
        ArrayList<Response> responses = new ArrayList<Response>();
        responses.addAll(this.getAddResponses());
        responses.addAll(this.getDeleteResponses());
        responses.addAll(this.getModifyResponses());
        return responses;
    }

    public Map<PSOIdentifier, Response> getResponseMap() {
        HashMap<PSOIdentifier, Response> map = new HashMap<PSOIdentifier, Response>();
        for (AddResponse addResponse : this.getAddResponses()) {
            map.put(addResponse.getPso().getPsoID(), (Response)addResponse);
        }
        for (ModifyResponse modifyResponse : this.getModifyResponses()) {
            map.put(modifyResponse.getPso().getPsoID(), (Response)modifyResponse);
        }
        return map;
    }

    public List<SynchronizedResponse> getSynchronizedResponses() {
        ArrayList<SynchronizedResponse> responses = new ArrayList<SynchronizedResponse>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof SynchronizedResponse)) continue;
            responses.add((SynchronizedResponse)((Object)o));
        }
        return responses;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 29 * result + (this.getId() != null ? this.getId().hashCode() : 0);
        result = 29 * result + (this.getError() != null ? this.getError().hashCode() : 0);
        result = 29 * result + (this.getErrorMessages() != null ? ((Object)Arrays.asList(this.getErrorMessages())).hashCode() : 0);
        result = 29 * result + (this.getRequestID() != null ? this.getRequestID().hashCode() : 0);
        result = 29 * result + (this.getStatus() != null ? this.getStatus().hashCode() : 0);
        result = 29 * result + (this.getOpenContentAttrs() != null ? ((Object)Arrays.asList(this.getOpenContentAttrs())).hashCode() : 0);
        for (Response response : this.getAddDeleteModifyResponses()) {
            result = 29 * result + response.hashCode();
        }
        for (SynchronizedResponse synchronizedResponse : this.getSynchronizedResponses()) {
            result = 29 * result + synchronizedResponse.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        Response other;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncResponse)) {
            return false;
        }
        SyncResponse that = (SyncResponse)((Object)o);
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getError() != null ? !this.getError().equals(that.getError()) : that.getError() != null) {
            return false;
        }
        if (this.getErrorMessages() != null ? !((Object)Arrays.asList(this.getErrorMessages())).equals(Arrays.asList(that.getErrorMessages())) : that.getErrorMessages() != null) {
            return false;
        }
        if (this.getRequestID() != null ? !this.getRequestID().equals(that.getRequestID()) : that.getRequestID() != null) {
            return false;
        }
        if (this.getStatus() != null ? !this.getStatus().equals(that.getStatus()) : that.getStatus() != null) {
            return false;
        }
        if (this.getOpenContentAttrs() != null ? !((Object)Arrays.asList(this.getOpenContentAttrs())).equals(Arrays.asList(that.getOpenContentAttrs())) : that.getOpenContentAttrs() != null) {
            return false;
        }
        Map<PSOIdentifier, Response> thisResponseMap = this.getResponseMap();
        Map<PSOIdentifier, Response> thatResponseMap = that.getResponseMap();
        for (PSOIdentifier psoID : thisResponseMap.keySet()) {
            other = thatResponseMap.get(psoID);
            if (other == null) {
                return false;
            }
            if (thisResponseMap.get(psoID).equals((Object)other)) continue;
            return false;
        }
        for (PSOIdentifier psoID : thatResponseMap.keySet()) {
            other = thisResponseMap.get(psoID);
            if (other == null) {
                return false;
            }
            if (thatResponseMap.get(psoID).equals((Object)other)) continue;
            return false;
        }
        return !(this.getDeleteResponses().isEmpty() ? !that.getDeleteResponses().isEmpty() : !((Object)this.getDeleteResponses()).equals(that.getDeleteResponses()));
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.appendSuper(super.toString());
        for (AddResponse addResponse : this.getAddResponses()) {
            toStringBuilder.append((Object)PSPUtil.toString(addResponse));
        }
        for (ModifyResponse modifyResponse : this.getModifyResponses()) {
            toStringBuilder.append((Object)PSPUtil.toString(modifyResponse));
        }
        for (DeleteResponse deleteResponse : this.getDeleteResponses()) {
            toStringBuilder.append((Object)PSPUtil.toString((Response)deleteResponse));
        }
        for (SynchronizedResponse synchronizedResponse : this.getSynchronizedResponses()) {
            toStringBuilder.append((Object)synchronizedResponse);
        }
        return toStringBuilder.toString();
    }
}

