/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import edu.internet2.middleware.ldappc.spml.request.ID;
import edu.internet2.middleware.ldappc.spml.request.LdappcMarshallableCreator;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.msg.spml.BatchableRequest;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProvisioningRequest
extends BatchableRequest {
    private ID m_id;
    private ReturnData m_returnData = ReturnData.EVERYTHING;
    private ListWithType m_schemaEntity = new ArrayListWithType(SchemaEntityRef.class);

    public PrefixAndNamespaceTuple[] getNamespacesInfo() {
        return LdappcMarshallableCreator.staticGetNamespacesInfo();
    }

    public String getId() {
        return this.m_id == null ? null : this.m_id.getID();
    }

    public void setId(String id) {
        this.m_id = new ID(id);
    }

    public ReturnData getReturnData() {
        return this.m_returnData;
    }

    public void setReturnData(ReturnData data) {
        this.m_returnData = data;
    }

    public void addSchemaEntity(SchemaEntityRef se) {
        if (se != null) {
            this.m_schemaEntity.add((Object)se);
        }
    }

    public void setSchemaEntities(List<SchemaEntityRef> se) {
        this.m_schemaEntity.clear();
        for (SchemaEntityRef s : se) {
            this.addSchemaEntity(s);
        }
    }

    public List<SchemaEntityRef> getSchemaEntities() {
        return this.m_schemaEntity;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_id != null ? this.m_id.hashCode() : 0);
        result = 29 * result + (this.m_returnData != null ? this.m_returnData.hashCode() : 0);
        result = 29 * result + (this.m_schemaEntity != null ? this.m_schemaEntity.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProvisioningRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProvisioningRequest that = (ProvisioningRequest)((Object)o);
        if (!this.m_id.equals((Object)that.m_id)) {
            return false;
        }
        if (this.m_returnData != null ? !this.m_returnData.equals(that.m_returnData) : that.m_returnData != null) {
            return false;
        }
        return !(this.m_schemaEntity != null ? !this.m_schemaEntity.equals(that.m_schemaEntity) : that.m_schemaEntity != null);
    }

    public boolean isValid() {
        return this.m_id != null;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("id", (Object)this.getId());
        toStringBuilder.append("requestID", (Object)this.getRequestID());
        toStringBuilder.append("returnData", (Object)this.getReturnData());
        for (SchemaEntityRef s : this.getSchemaEntities()) {
            toStringBuilder.append("schemaEntityRef", (Object)PSPUtil.toString(s));
        }
        return toStringBuilder.toString();
    }
}

