/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import edu.internet2.middleware.grouper.shibboleth.dataConnector.SourceDataConnector;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOIdentifierDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.TargetDefinition;
import edu.internet2.middleware.ldappc.spml.request.BulkProvisioningRequest;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethAttributeResolver;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.DataConnector;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkProvisioningRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BulkProvisioningRequestHandler.class);
    private PSP psp;
    private BulkProvisioningRequest request;

    public BulkProvisioningRequestHandler(PSP psp, BulkProvisioningRequest request) {
        this.psp = psp;
        this.request = request;
    }

    public Set<String> getAllIdentifiers() throws LdappcException {
        String msg = "get all identifers";
        LOG.debug(msg);
        LinkedHashSet<String> identifiers = new LinkedHashSet<String>();
        LinkedHashMap<String, SourceDataConnector> dataConnectors = new LinkedHashMap<String, SourceDataConnector>();
        if (this.request.getSchemaEntities().isEmpty()) {
            dataConnectors.putAll(this.getAllSourceDataConnectors(null));
        } else {
            for (SchemaEntityRef schemaEntityRef : this.request.getSchemaEntities()) {
                dataConnectors.putAll(this.getAllSourceDataConnectors(schemaEntityRef));
            }
        }
        for (SourceDataConnector sourceDataConnector : dataConnectors.values()) {
            identifiers.addAll(sourceDataConnector.getAllIdentifiers(this.request.getUpdatedSinceAsDate()));
        }
        LOG.debug("{} found {} identifiers", (Object)msg, (Object)identifiers.size());
        return identifiers;
    }

    protected Map<String, SourceDataConnector> getAllSourceDataConnectors(SchemaEntityRef schemaEntityRef) throws LdappcException {
        String msg = "get all source data connectors for " + PSPUtil.toString(schemaEntityRef);
        LOG.debug(msg);
        ShibbolethAttributeResolver attributeResolver = null;
        for (String beanName : this.psp.getApplicationContext().getBeanNamesForType(ShibbolethAttributeResolver.class)) {
            if (attributeResolver != null) {
                LOG.error("Only one ShibbolethAttributeResolver was expected.");
                throw new LdappcException("Only one ShibbolethAttributeResolver was expected.");
            }
            attributeResolver = (ShibbolethAttributeResolver)this.psp.getApplicationContext().getBean(beanName);
        }
        LinkedHashMap<String, SourceDataConnector> dataConnectors = new LinkedHashMap<String, SourceDataConnector>();
        Map<TargetDefinition, List<PSODefinition>> map = this.psp.getTargetAndObjectDefinitions(schemaEntityRef);
        for (TargetDefinition targetDefinition : map.keySet()) {
            for (PSODefinition psoDefinition : map.get(targetDefinition)) {
                PSOIdentifierDefinition psoIdentifierDefinition = psoDefinition.getPsoIdentifierDefinition();
                String ref = psoIdentifierDefinition.getRef();
                AttributeDefinition attributeDef = (AttributeDefinition)attributeResolver.getAttributeDefinitions().get(ref);
                if (attributeDef == null) {
                    LOG.error("Attribute definition for '" + ref + "' does not exist.");
                    throw new LdappcException("Attribute definition for '" + ref + "' does not exist.");
                }
                dataConnectors.putAll(this.getDependentSourceDataConnectors(attributeResolver, (ResolutionPlugIn<?>)attributeDef));
            }
        }
        LOG.debug("{} found {}", (Object)msg, dataConnectors);
        return dataConnectors;
    }

    protected Map<String, SourceDataConnector> getDependentSourceDataConnectors(ShibbolethAttributeResolver sar, ResolutionPlugIn<?> plugIn) {
        String msg = "get dependent source data connectors for attribute resolver '" + sar.getId() + "' plugIn '" + plugIn.getId() + "'";
        LOG.debug(msg);
        LinkedHashMap<String, SourceDataConnector> dataConnectors = new LinkedHashMap<String, SourceDataConnector>();
        for (String dependencyId : plugIn.getDependencyIds()) {
            DataConnector dc;
            AttributeDefinition ad = (AttributeDefinition)sar.getAttributeDefinitions().get(dependencyId);
            if (ad != null) {
                dataConnectors.putAll(this.getDependentSourceDataConnectors(sar, (ResolutionPlugIn<?>)ad));
            }
            if ((dc = (DataConnector)sar.getDataConnectors().get(dependencyId)) == null) continue;
            if (dc instanceof SourceDataConnector) {
                dataConnectors.put(dc.getId(), (SourceDataConnector)dc);
            }
            dataConnectors.putAll(this.getDependentSourceDataConnectors(sar, (ResolutionPlugIn<?>)dc));
        }
        LOG.debug("{} found {}", (Object)msg, dataConnectors);
        return dataConnectors;
    }
}

