/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import edu.internet2.middleware.ldappc.spml.request.ProvisioningRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openspml.v2.msg.spmlbatch.OnError;

public abstract class BulkProvisioningRequest
extends ProvisioningRequest {
    public static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'_'hh:mm:ss");
    private OnError m_onError = OnError.RESUME;
    private String m_updatedSince = null;
    private Date updatedSinceDate = null;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkProvisioningRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BulkProvisioningRequest that = (BulkProvisioningRequest)((Object)o);
        if (this.m_onError != null ? !this.m_onError.equals(that.m_onError) : that.m_onError != null) {
            return false;
        }
        return !(this.m_updatedSince != null ? !this.m_updatedSince.equals(that.m_updatedSince) : that.m_updatedSince != null);
    }

    public OnError getOnError() {
        return this.m_onError;
    }

    public String getUpdatedSince() {
        return this.m_updatedSince;
    }

    public Date getUpdatedSinceAsDate() {
        return this.updatedSinceDate;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_onError != null ? this.m_onError.hashCode() : 0);
        result = 29 * result + (this.m_updatedSince != null ? this.m_updatedSince.hashCode() : 0);
        return result;
    }

    public void setOnError(OnError onError) {
        this.m_onError = onError;
    }

    public void setUpdatedSince(Date updatedSince) {
        if (updatedSince != null) {
            this.m_updatedSince = df.format(updatedSince);
        }
        this.updatedSinceDate = updatedSince;
    }

    public void setUpdatedSince(String updatedSince) throws ParseException {
        if (updatedSince != null) {
            StringBuffer dateInput = new StringBuffer(updatedSince);
            int len = dateInput.length();
            if (len == 10) {
                dateInput.append("_00:00:00");
            } else if (len == 13) {
                dateInput.append(":00:00");
            } else if (len == 16) {
                dateInput.append(":00");
            }
            this.updatedSinceDate = df.parse(dateInput.toString());
        }
        this.m_updatedSince = updatedSince;
    }

    static {
        df.setLenient(true);
    }
}

