/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import edu.internet2.middleware.ldappc.spml.request.CalcResponse;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningResponse;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkCalcResponse
extends ProvisioningResponse {
    private ListWithType m_response = new ArrayListWithType(CalcResponse.class);

    public List<CalcResponse> getResponses() {
        return this.m_response;
    }

    public void addResponse(CalcResponse response) {
        this.m_response.add((Object)response);
    }

    public Map<PSOIdentifier, CalcResponse> getResponseMap() {
        HashMap<PSOIdentifier, CalcResponse> map = new HashMap<PSOIdentifier, CalcResponse>();
        for (CalcResponse response : this.getResponses()) {
            for (PSO pso : response.getPSOs()) {
                map.put(pso.getPsoID(), response);
            }
        }
        return map;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_response != null ? this.m_response.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        CalcResponse other;
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkCalcResponse)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BulkCalcResponse that = (BulkCalcResponse)((Object)o);
        if (this.m_response != null ? !this.m_response.equals(that.m_response) : that.m_response != null) {
            return false;
        }
        Map<PSOIdentifier, CalcResponse> thisResponseMap = this.getResponseMap();
        Map<PSOIdentifier, CalcResponse> thatResponseMap = that.getResponseMap();
        for (PSOIdentifier psoID : thisResponseMap.keySet()) {
            other = thatResponseMap.get(psoID);
            if (other == null) {
                return false;
            }
            if (thisResponseMap.get(psoID).equals((Object)other)) continue;
            return false;
        }
        for (PSOIdentifier psoID : thatResponseMap.keySet()) {
            other = thisResponseMap.get(psoID);
            if (other == null) {
                return false;
            }
            if (thatResponseMap.get(psoID).equals((Object)other)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("responses", this.getResponses().size());
        toStringBuilder.appendSuper(PSPUtil.toString(this));
        return toStringBuilder.toString();
    }
}

