/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.provider;

import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferencesDefinition;
import edu.internet2.middleware.ldappc.spml.provider.BaseSpmlTargetProvider;
import edu.internet2.middleware.ldappc.spml.request.LdapFilterQueryClause;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.bean.OrderedLdapBeanFactory;
import edu.vt.middleware.ldap.bean.SortedLdapBeanFactory;
import edu.vt.middleware.ldap.ldif.Ldif;
import edu.vt.middleware.ldap.ldif.LdifResultConverter;
import edu.vt.middleware.ldap.pool.LdapPool;
import edu.vt.middleware.ldap.pool.LdapPoolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.DeleteResponse;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.QueryClause;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.util.Spml2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapTargetProvider
extends BaseSpmlTargetProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapTargetProvider.class);
    private String ldapPoolId;
    private LdapPool<Ldap> ldapPool;
    private boolean logLdif;
    private boolean logSpml;

    public String getLdapPoolId() {
        return this.ldapPoolId;
    }

    public void setLdapPoolId(String ldapPoolId) {
        this.ldapPoolId = ldapPoolId;
    }

    public LdapPool<Ldap> getLdapPool() {
        return this.ldapPool;
    }

    public boolean isLogLdif() {
        return this.logLdif;
    }

    public void setLogLdif(boolean logLdif) {
        this.logLdif = logLdif;
    }

    public boolean isLogSpml() {
        return this.logSpml;
    }

    public void setLogSpml(boolean logSpml) {
        this.logSpml = logSpml;
    }

    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        LdapPool<Ldap> oldPool = this.ldapPool;
        try {
            LOG.debug("Loading ldap pool '{}'", (Object)this.getLdapPoolId());
            this.ldapPool = (LdapPool)newServiceContext.getBean(this.getLdapPoolId());
        }
        catch (Exception e) {
            this.ldapPool = oldPool;
            LOG.error(this.getId() + " configuration is not valid, retaining old configuration", (Throwable)e);
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AddResponse execute(AddRequest addRequest) {
        Ldap ldap;
        AddResponse addResponse;
        block30: {
            AddResponse addResponse2;
            String msg = PSPUtil.toString(addRequest);
            LOG.info("{}", (Object)msg);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)addRequest));
            }
            addResponse = new AddResponse();
            addResponse.setRequestID(this.getOrGenerateRequestID((Request)addRequest));
            if (!this.getPSP().isValid(addRequest, addResponse)) {
                LOG.error(PSPUtil.toString(addResponse));
                if (!this.isLogSpml()) return addResponse;
                LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                return addResponse;
            }
            if (!this.isValidTargetId(addRequest.getPsoID(), (Response)addResponse)) {
                LOG.error(PSPUtil.toString(addResponse));
                if (!this.isLogSpml()) return addResponse;
                LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                return addResponse;
            }
            String dn = addRequest.getPsoID().getID();
            try {
                this.handleEmptyReferences(addRequest);
            }
            catch (DSMLProfileException e) {
                this.fail((Response)addResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                LOG.error(PSPUtil.toString(addResponse), (Throwable)e);
                if (!this.isLogSpml()) return addResponse;
                LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                return addResponse;
            }
            ldap = null;
            try {
                try {
                    Extensible data = addRequest.getData();
                    SortedLdapBeanFactory ldapBeanFactory = new SortedLdapBeanFactory();
                    LdapAttributes ldapAttributes = ldapBeanFactory.newLdapAttributes();
                    Map<String, DSMLAttr> dsmlAttrs = PSP.getDSMLAttrMap(data);
                    for (DSMLAttr dsmlAttr : dsmlAttrs.values()) {
                        BasicAttribute basicAttribute = new BasicAttribute(dsmlAttr.getName());
                        for (DSMLValue dsmlValue : dsmlAttr.getValues()) {
                            basicAttribute.add(dsmlValue.getValue());
                        }
                        LdapAttribute ldapAttribute = ldapBeanFactory.newLdapAttribute();
                        ldapAttribute.setAttribute((Attribute)basicAttribute);
                        ldapAttributes.addAttribute(ldapAttribute);
                    }
                    Map<String, List<Reference>> references = PSP.getReferences(addRequest.getCapabilityData());
                    for (String typeOfReference : references.keySet()) {
                        BasicAttribute basicAttribute = new BasicAttribute(typeOfReference);
                        for (Reference reference : references.get(typeOfReference)) {
                            if (!reference.getToPsoID().getTargetID().equals(this.getTargetDefinition().getId())) continue;
                            String id = reference.getToPsoID().getID();
                            if (id == null) {
                                id = "";
                            }
                            basicAttribute.add(id);
                        }
                        LdapAttribute ldapAttribute = ldapBeanFactory.newLdapAttribute();
                        ldapAttribute.setAttribute((Attribute)basicAttribute);
                        ldapAttributes.addAttribute(ldapAttribute);
                    }
                    String escapedDn = LdapUtil.escapeForwardSlash(dn);
                    LOG.debug("{} escaped dn '{}'", (Object)msg, (Object)escapedDn);
                    ldap = (Ldap)this.ldapPool.checkOut();
                    LOG.info("{} create", (Object)PSPUtil.toString(addRequest));
                    ldap.create(escapedDn, ldapAttributes.toAttributes());
                    if (this.isLogLdif()) {
                        LdapEntry ldapEntry = ldapBeanFactory.newLdapEntry();
                        ldapEntry.setDn(dn);
                        ldapEntry.setLdapAttributes(ldapAttributes);
                        LdapResult result = ldapBeanFactory.newLdapResult();
                        result.addEntry(ldapEntry);
                        Ldif ldif = new Ldif();
                        LOG.info("{}:\n{}", (Object)msg, (Object)ldif.createLdif(result));
                    }
                    if (addRequest.getReturnData().equals(ReturnData.IDENTIFIER)) {
                        PSO responsePSO = new PSO();
                        responsePSO.setPsoID(addRequest.getPsoID());
                        addResponse.setPso(responsePSO);
                        break block30;
                    }
                    LookupRequest lookupRequest = new LookupRequest();
                    lookupRequest.setPsoID(addRequest.getPsoID());
                    lookupRequest.setReturnData(addRequest.getReturnData());
                    LookupResponse lookupResponse = this.execute(lookupRequest);
                    if (lookupResponse.getStatus() == StatusCode.SUCCESS) {
                        addResponse.setPso(lookupResponse.getPso());
                        break block30;
                    }
                    this.fail((Response)addResponse, lookupResponse.getError(), "Unable to lookup object after create.");
                    LOG.error(PSPUtil.toString(addResponse));
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                    }
                    addResponse2 = addResponse;
                    Object var18_31 = null;
                }
                catch (LdapPoolException e) {
                    this.fail((Response)addResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                    LOG.error(PSPUtil.toString(addResponse), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                    }
                    AddResponse addResponse3 = addResponse;
                    Object var18_33 = null;
                    this.ldapPool.checkIn(ldap);
                    return addResponse3;
                }
                catch (NameAlreadyBoundException e) {
                    this.fail((Response)addResponse, ErrorCode.ALREADY_EXISTS, e);
                    LOG.error(PSPUtil.toString(addResponse), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                    }
                    AddResponse addResponse4 = addResponse;
                    Object var18_34 = null;
                    this.ldapPool.checkIn(ldap);
                    return addResponse4;
                }
                catch (NamingException e) {
                    this.fail((Response)addResponse, ErrorCode.CUSTOM_ERROR, e);
                    LOG.error(PSPUtil.toString(addResponse), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                    }
                    AddResponse addResponse5 = addResponse;
                    Object var18_35 = null;
                    this.ldapPool.checkIn(ldap);
                    return addResponse5;
                }
                catch (LdappcException e) {
                    this.fail((Response)addResponse, ErrorCode.CUSTOM_ERROR, e);
                    LOG.error(PSPUtil.toString(addResponse), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
                    }
                    AddResponse addResponse6 = addResponse;
                    Object var18_36 = null;
                    this.ldapPool.checkIn(ldap);
                    return addResponse6;
                }
            }
            catch (Throwable throwable) {
                Object var18_37 = null;
                this.ldapPool.checkIn(ldap);
                throw throwable;
            }
            this.ldapPool.checkIn((BaseLdap)ldap);
            return addResponse2;
        }
        Object var18_32 = null;
        this.ldapPool.checkIn((BaseLdap)ldap);
        addResponse.setStatus(StatusCode.SUCCESS);
        LOG.info(PSPUtil.toString(addResponse));
        if (!this.isLogSpml()) return addResponse;
        LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
        return addResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteResponse execute(DeleteRequest deleteRequest) {
        String msg = PSPUtil.toString(deleteRequest);
        LOG.info("{}", (Object)msg);
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteRequest));
        }
        DeleteResponse deleteResponse = new DeleteResponse();
        deleteResponse.setRequestID(this.getOrGenerateRequestID((Request)deleteRequest));
        if (!this.isValidTargetId(deleteRequest.getPsoID(), (Response)deleteResponse)) {
            LOG.error(PSPUtil.toString((Response)deleteResponse));
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
            }
            return deleteResponse;
        }
        String dn = deleteRequest.getPsoID().getID();
        Ldap ldap = null;
        try {
            try {
                ldap = (Ldap)this.ldapPool.checkOut();
                LOG.info("{}", (Object)msg);
                String escapedDn = LdapUtil.escapeForwardSlash(dn);
                LOG.debug("{} escaped dn '{}'", (Object)msg, (Object)escapedDn);
                ldap.delete(escapedDn);
            }
            catch (LdapPoolException e) {
                this.fail((Response)deleteResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                LOG.error(PSPUtil.toString((Response)deleteResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
                }
                DeleteResponse deleteResponse2 = deleteResponse;
                Object var9_11 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return deleteResponse2;
            }
            catch (NameNotFoundException e) {
                this.fail((Response)deleteResponse, ErrorCode.NO_SUCH_IDENTIFIER, e);
                LOG.error(PSPUtil.toString((Response)deleteResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
                }
                DeleteResponse deleteResponse3 = deleteResponse;
                Object var9_12 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return deleteResponse3;
            }
            catch (NamingException e) {
                this.fail((Response)deleteResponse, ErrorCode.CUSTOM_ERROR, e);
                LOG.error(PSPUtil.toString((Response)deleteResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
                }
                DeleteResponse deleteResponse4 = deleteResponse;
                Object var9_13 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return deleteResponse4;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.ldapPool.checkIn((BaseLdap)ldap);
            throw throwable;
        }
        this.ldapPool.checkIn((BaseLdap)ldap);
        deleteResponse.setStatus(StatusCode.SUCCESS);
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
        }
        return deleteResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LookupResponse execute(LookupRequest lookupRequest) {
        Ldap ldap;
        LookupResponse lookupResponse;
        block31: {
            LookupResponse lookupResponse2;
            block30: {
                LookupResponse lookupResponse3;
                block29: {
                    String msg = PSPUtil.toString(lookupRequest);
                    LOG.info("{}", (Object)msg);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupRequest));
                    }
                    lookupResponse = new LookupResponse();
                    lookupResponse.setRequestID(this.getOrGenerateRequestID((Request)lookupRequest));
                    if (lookupRequest.getPsoID() == null || lookupRequest.getPsoID().getID() == null) {
                        this.fail((Response)lookupResponse, ErrorCode.MALFORMED_REQUEST, "A psoID is required.");
                        LOG.error("{}", (Object)PSPUtil.toString(lookupResponse));
                        if (this.isLogSpml()) {
                            LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                        }
                        return lookupResponse;
                    }
                    String targetId = lookupRequest.getPsoID().getTargetID();
                    if (GrouperUtil.isBlank((String)targetId)) {
                        this.fail((Response)lookupResponse, ErrorCode.MALFORMED_REQUEST, "A targetID is required.");
                        LOG.error("{}", (Object)PSPUtil.toString(lookupResponse));
                        if (this.isLogSpml()) {
                            LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                        }
                        return lookupResponse;
                    }
                    if (!targetId.equals(this.getTargetDefinition().getId())) {
                        this.fail((Response)lookupResponse, ErrorCode.INVALID_IDENTIFIER, new String[0]);
                        LOG.error("{}", (Object)PSPUtil.toString(lookupResponse));
                        if (this.isLogSpml()) {
                            LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                        }
                        return lookupResponse;
                    }
                    String dn = lookupRequest.getPsoID().getID();
                    ldap = null;
                    try {
                        try {
                            SearchFilter sf = new SearchFilter();
                            sf.setFilter("objectclass=*");
                            SearchControls sc = new SearchControls();
                            sc.setSearchScope(0);
                            String[] retAttrs = this.getTargetDefinition().getNames(lookupRequest.getReturnData()).toArray(new String[0]);
                            sc.setReturningAttributes(retAttrs);
                            String escapedDn = LdapUtil.escapeForwardSlash(dn);
                            LOG.debug("{} dn '{}' attrs {}", new Object[]{msg, escapedDn, retAttrs});
                            ldap = (Ldap)this.ldapPool.checkOut();
                            Iterator searchResults = ldap.search(escapedDn, sf, sc);
                            if (!searchResults.hasNext()) {
                                this.fail((Response)lookupResponse, ErrorCode.NO_SUCH_IDENTIFIER, new String[0]);
                                LOG.error("{}", (Object)PSPUtil.toString(lookupResponse));
                                if (this.isLogSpml()) {
                                    LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                                }
                                lookupResponse3 = lookupResponse;
                                Object var24_26 = null;
                                break block29;
                            }
                            SearchResult result = (SearchResult)searchResults.next();
                            if (searchResults.hasNext()) {
                                this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, "More than one result found.");
                                LOG.error("{}", (Object)PSPUtil.toString(lookupResponse));
                                if (this.isLogSpml()) {
                                    LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                                }
                                lookupResponse2 = lookupResponse;
                                break block30;
                            }
                            Attributes attributes = result.getAttributes();
                            OrderedLdapBeanFactory orderedLdapBeanFactory = new OrderedLdapBeanFactory();
                            SortedLdapBeanFactory sortedLdapBeanFactory = new SortedLdapBeanFactory();
                            LdapAttributes ldapAttributes = orderedLdapBeanFactory.newLdapAttributes();
                            for (String retAttr : retAttrs) {
                                Attribute attr = attributes.get(retAttr);
                                if (attr == null) continue;
                                LdapAttribute ldapAttribute = sortedLdapBeanFactory.newLdapAttribute();
                                ldapAttribute.setAttribute(attr);
                                ldapAttributes.addAttribute(ldapAttribute);
                            }
                            LdapEntry entry = sortedLdapBeanFactory.newLdapEntry();
                            entry.setDn(dn);
                            entry.setLdapAttributes(ldapAttributes);
                            if (this.isLogLdif()) {
                                LdapResult lr = sortedLdapBeanFactory.newLdapResult();
                                lr.addEntry(entry);
                                LdifResultConverter lrc = new LdifResultConverter();
                                LOG.info("{}\n{}", (Object)msg, (Object)lrc.toLdif(lr));
                            }
                            lookupResponse.setPso(this.getPSO(entry, lookupRequest.getReturnData()));
                            break block31;
                        }
                        catch (NameNotFoundException e) {
                            this.fail((Response)lookupResponse, ErrorCode.NO_SUCH_IDENTIFIER, new String[0]);
                            LOG.error(PSPUtil.toString(lookupResponse));
                            LOG.debug(PSPUtil.toString(lookupResponse), (Throwable)e);
                            if (this.isLogSpml()) {
                                LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                            }
                            LookupResponse lookupResponse4 = lookupResponse;
                            Object var24_29 = null;
                            this.ldapPool.checkIn(ldap);
                            return lookupResponse4;
                        }
                        catch (LdapPoolException e) {
                            this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                            LOG.error(PSPUtil.toString(lookupResponse), (Throwable)e);
                            if (this.isLogSpml()) {
                                LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                            }
                            LookupResponse lookupResponse5 = lookupResponse;
                            Object var24_30 = null;
                            this.ldapPool.checkIn(ldap);
                            return lookupResponse5;
                        }
                        catch (InvalidNameException e) {
                            this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, e);
                            LOG.error(PSPUtil.toString(lookupResponse), (Throwable)e);
                            if (this.isLogSpml()) {
                                LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                            }
                            LookupResponse lookupResponse6 = lookupResponse;
                            Object var24_31 = null;
                            this.ldapPool.checkIn(ldap);
                            return lookupResponse6;
                        }
                        catch (NamingException e) {
                            this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, e);
                            LOG.error(PSPUtil.toString(lookupResponse), (Throwable)e);
                            if (this.isLogSpml()) {
                                LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                            }
                            LookupResponse lookupResponse7 = lookupResponse;
                            Object var24_32 = null;
                            this.ldapPool.checkIn(ldap);
                            return lookupResponse7;
                        }
                        catch (DSMLProfileException e) {
                            this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                            LOG.error(PSPUtil.toString(lookupResponse), (Throwable)e);
                            if (this.isLogSpml()) {
                                LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                            }
                            LookupResponse lookupResponse8 = lookupResponse;
                            Object var24_33 = null;
                            this.ldapPool.checkIn(ldap);
                            return lookupResponse8;
                        }
                        catch (Spml2Exception e) {
                            this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                            LOG.error(PSPUtil.toString(lookupResponse), (Throwable)e);
                            if (this.isLogSpml()) {
                                LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
                            }
                            LookupResponse lookupResponse9 = lookupResponse;
                            Object var24_34 = null;
                            this.ldapPool.checkIn(ldap);
                            return lookupResponse9;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var24_35 = null;
                        this.ldapPool.checkIn(ldap);
                        throw throwable;
                    }
                }
                this.ldapPool.checkIn((BaseLdap)ldap);
                return lookupResponse3;
            }
            Object var24_27 = null;
            this.ldapPool.checkIn((BaseLdap)ldap);
            return lookupResponse2;
        }
        Object var24_28 = null;
        this.ldapPool.checkIn((BaseLdap)ldap);
        lookupResponse.setStatus(StatusCode.SUCCESS);
        LOG.info("{}", (Object)PSPUtil.toString(lookupResponse));
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
        }
        return lookupResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModifyResponse execute(ModifyRequest modifyRequest) {
        Ldap ldap;
        ModifyResponse response;
        block20: {
            ModifyResponse modifyResponse;
            String msg = PSPUtil.toString(modifyRequest);
            LOG.info("{}", (Object)msg);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)modifyRequest));
            }
            response = new ModifyResponse();
            response.setRequestID(this.getOrGenerateRequestID((Request)modifyRequest));
            if (!this.getPSP().isValid(modifyRequest, response)) {
                LOG.error(PSPUtil.toString(response));
                if (!this.isLogSpml()) return response;
                LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
                return response;
            }
            if (!this.isValidTargetId(modifyRequest.getPsoID(), (Response)response)) {
                LOG.error(PSPUtil.toString(response));
                if (!this.isLogSpml()) return response;
                LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
                return response;
            }
            String dn = modifyRequest.getPsoID().getID();
            ldap = null;
            try {
                try {
                    ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
                    for (Modification modification : modifyRequest.getModifications()) {
                        modificationItems.addAll(this.getDsmlMods(modification));
                        modificationItems.addAll(this.getReferenceMods(modification));
                    }
                    ldap = (Ldap)this.ldapPool.checkOut();
                    LOG.debug("{} mods {}", (Object)msg, modificationItems);
                    String escapedDn = LdapUtil.escapeForwardSlash(dn);
                    LOG.debug("{} escaped dn '{}'", (Object)msg, (Object)escapedDn);
                    ldap.modifyAttributes(escapedDn, modificationItems.toArray(new ModificationItem[0]));
                    if (modifyRequest.getReturnData().equals(ReturnData.IDENTIFIER)) {
                        PSO responsePSO = new PSO();
                        responsePSO.setPsoID(modifyRequest.getPsoID());
                        response.setPso(responsePSO);
                        break block20;
                    }
                    LookupRequest lookupRequest = new LookupRequest();
                    lookupRequest.setPsoID(modifyRequest.getPsoID());
                    lookupRequest.setReturnData(modifyRequest.getReturnData());
                    LookupResponse lookupResponse = this.execute(lookupRequest);
                    if (lookupResponse.getStatus() == StatusCode.SUCCESS) {
                        response.setPso(lookupResponse.getPso());
                        break block20;
                    }
                    this.fail((Response)response, lookupResponse.getError(), new String[0]);
                    LOG.error(PSPUtil.toString(response));
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
                    }
                    modifyResponse = response;
                    Object var12_20 = null;
                }
                catch (LdapPoolException e) {
                    this.fail((Response)response, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                    LOG.error(PSPUtil.toString(response), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
                    }
                    ModifyResponse modifyResponse2 = response;
                    Object var12_22 = null;
                    this.ldapPool.checkIn((BaseLdap)ldap);
                    return modifyResponse2;
                }
                catch (LdappcException e) {
                    this.fail((Response)response, ErrorCode.CUSTOM_ERROR, e);
                    LOG.error(PSPUtil.toString(response), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
                    }
                    ModifyResponse modifyResponse3 = response;
                    Object var12_23 = null;
                    this.ldapPool.checkIn((BaseLdap)ldap);
                    return modifyResponse3;
                }
                catch (NamingException e) {
                    this.fail((Response)response, ErrorCode.CUSTOM_ERROR, e);
                    LOG.error(PSPUtil.toString(response), (Throwable)e);
                    if (this.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
                    }
                    ModifyResponse modifyResponse4 = response;
                    Object var12_24 = null;
                    this.ldapPool.checkIn((BaseLdap)ldap);
                    return modifyResponse4;
                }
            }
            catch (Throwable throwable) {
                Object var12_25 = null;
                this.ldapPool.checkIn(ldap);
                throw throwable;
            }
            this.ldapPool.checkIn((BaseLdap)ldap);
            return modifyResponse;
        }
        Object var12_21 = null;
        this.ldapPool.checkIn((BaseLdap)ldap);
        response.setStatus(StatusCode.SUCCESS);
        LOG.info(PSPUtil.toString(response));
        if (!this.isLogSpml()) return response;
        LOG.info("\n{}", (Object)this.toXML((Marshallable)response));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchResponse execute(SearchRequest searchRequest) {
        String msg = PSPUtil.toString(searchRequest);
        LOG.info("{}", (Object)msg);
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)searchRequest));
        }
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setRequestID(this.getOrGenerateRequestID((Request)searchRequest));
        Query query = searchRequest.getQuery();
        if (GrouperUtil.isBlank((Object)query)) {
            this.fail((Response)searchResponse, ErrorCode.MALFORMED_REQUEST, "A query is required.");
            LOG.error("{}", (Object)searchResponse);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
            }
            return searchResponse;
        }
        if (query.getTargetID() != null && !query.getTargetID().equals(this.getTargetDefinition().getId())) {
            this.fail((Response)searchResponse, ErrorCode.MALFORMED_REQUEST, "Target ID " + query.getTargetID() + " does not match this target " + this.getTargetDefinition().getId());
            LOG.error("{}", (Object)searchResponse);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
            }
            return searchResponse;
        }
        String filter = null;
        for (QueryClause queryClause : query.getQueryClauses()) {
            if (!(queryClause instanceof LdapFilterQueryClause)) continue;
            filter = ((LdapFilterQueryClause)queryClause).getFilter();
        }
        if (GrouperUtil.isBlank(filter)) {
            this.fail((Response)searchResponse, ErrorCode.MALFORMED_REQUEST, "A filter is required.");
            LOG.error("{}", (Object)searchResponse);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
            }
            return searchResponse;
        }
        if (query.getBasePsoID() == null || query.getBasePsoID().getID() == null) {
            this.fail((Response)searchResponse, ErrorCode.MALFORMED_REQUEST, "A basePsoID is required.");
            LOG.error("{}", (Object)searchResponse);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
            }
            return searchResponse;
        }
        String base = query.getBasePsoID().getID();
        SearchControls searchControls = new SearchControls();
        Scope scope = query.getScope();
        if (scope != null) {
            searchControls.setSearchScope(PSPUtil.getScope(scope));
        }
        Ldap ldap = null;
        try {
            try {
                String[] retAttrs = this.getTargetDefinition().getNames(searchRequest.getReturnData()).toArray(new String[0]);
                searchControls.setReturningAttributes(retAttrs);
                ldap = (Ldap)this.ldapPool.checkOut();
                LOG.debug("{} retAttrs {}", (Object)msg, Arrays.asList(retAttrs));
                Iterator searchResults = ldap.search(base, new SearchFilter(filter), searchControls);
                SortedLdapBeanFactory ldapBeanFactory = new SortedLdapBeanFactory();
                LdapResult ldapResult = ldapBeanFactory.newLdapResult();
                ldapResult.addEntries(searchResults);
                Collection entries = ldapResult.getEntries();
                LOG.debug("{} found {}", (Object)msg, (Object)entries.size());
                for (LdapEntry entry : entries) {
                    searchResponse.addPSO(this.getPSO(entry, searchRequest.getReturnData()));
                }
                if (this.logLdif) {
                    Ldif ldif = new Ldif();
                    LOG.info("{}:\n{}", (Object)msg, (Object)ldif.createLdif(ldapResult));
                }
            }
            catch (NameNotFoundException e) {
                this.fail((Response)searchResponse, ErrorCode.NO_SUCH_IDENTIFIER, e);
                LOG.error(PSPUtil.toString(searchResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
                }
                SearchResponse searchResponse2 = searchResponse;
                Object var18_28 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return searchResponse2;
            }
            catch (NamingException e) {
                this.fail((Response)searchResponse, ErrorCode.CUSTOM_ERROR, e);
                LOG.error(PSPUtil.toString(searchResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
                }
                SearchResponse searchResponse3 = searchResponse;
                Object var18_29 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return searchResponse3;
            }
            catch (LdapPoolException e) {
                this.fail((Response)searchResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                LOG.error(PSPUtil.toString(searchResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
                }
                SearchResponse searchResponse4 = searchResponse;
                Object var18_30 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return searchResponse4;
            }
            catch (Spml2Exception e) {
                this.fail((Response)searchResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
                LOG.error(PSPUtil.toString(searchResponse), (Throwable)e);
                if (this.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
                }
                SearchResponse searchResponse5 = searchResponse;
                Object var18_31 = null;
                this.ldapPool.checkIn((BaseLdap)ldap);
                return searchResponse5;
            }
            Object var18_27 = null;
        }
        catch (Throwable throwable) {
            Object var18_32 = null;
            this.ldapPool.checkIn(ldap);
            throw throwable;
        }
        this.ldapPool.checkIn((BaseLdap)ldap);
        searchResponse.setStatus(StatusCode.SUCCESS);
        LOG.info("{}", (Object)PSPUtil.toString(searchResponse));
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
        }
        return searchResponse;
    }

    protected PSO getPSO(LdapEntry entry, ReturnData returnData) throws Spml2Exception {
        String msg = "get pso for '" + entry.getDn() + "' target '" + this.getTargetDefinition().getId() + "'";
        PSO pso = new PSO();
        PSODefinition psoDefinition = this.getPSODefinition(entry);
        LOG.debug("{} schema entity '{}'", (Object)msg, (Object)psoDefinition.getId());
        pso.addOpenContentAttr("entityName", psoDefinition.getId());
        PSOIdentifier psoID = new PSOIdentifier();
        psoID.setTargetID(this.getTargetDefinition().getId());
        try {
            psoID.setID(LdapUtil.canonicalizeDn(entry.getDn()));
        }
        catch (InvalidNameException e) {
            LOG.error(msg + " Unable to canonicalize entry dn.", (Throwable)e);
            throw new Spml2Exception((Throwable)e);
        }
        pso.setPsoID(psoID);
        LdapAttributes ldapAttributes = entry.getLdapAttributes();
        if (returnData.equals(ReturnData.DATA) || returnData.equals(ReturnData.EVERYTHING)) {
            TreeMap<String, String> attributeNameMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (String attributeName : psoDefinition.getAttributeNames()) {
                attributeNameMap.put(attributeName, attributeName);
            }
            TreeMap<String, String> referenceNameMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            if (returnData.equals(ReturnData.EVERYTHING)) {
                for (String referenceName : psoDefinition.getReferenceNames()) {
                    referenceNameMap.put(referenceName, referenceName);
                }
            }
            Extensible data = new Extensible();
            ArrayList<Reference> references = new ArrayList<Reference>();
            for (LdapAttribute ldapAttribute : ldapAttributes.getAttributes()) {
                if (attributeNameMap.containsKey(ldapAttribute.getName())) {
                    data.addOpenContentElement((OpenContentElement)this.getDsmlAttr((String)attributeNameMap.get(ldapAttribute.getName()), ldapAttribute.getStringValues()));
                } else if (returnData.equals(ReturnData.EVERYTHING) && referenceNameMap.containsKey(ldapAttribute.getName())) {
                    references.addAll(this.getReferences((String)referenceNameMap.get(ldapAttribute.getName()), ldapAttribute.getStringValues()));
                } else {
                    LOG.trace("{} ignoring attribute '{}'", (Object)msg, (Object)ldapAttribute.getName());
                }
                if (data.getOpenContentElements().length > 0) {
                    pso.setData(data);
                }
                if (!returnData.equals(ReturnData.EVERYTHING)) continue;
                PSPUtil.setReferences(pso, references);
            }
        }
        return pso;
    }

    protected PSODefinition getPSODefinition(LdapEntry entry) throws LdappcException {
        Attributes attributes = entry.getLdapAttributes().toAttributes();
        PSODefinition definition = null;
        for (PSODefinition psoDefinition : this.getTargetDefinition().getPsoDefinitions()) {
            String idAttrName = psoDefinition.getPsoIdentifierDefinition().getIdentifyingAttribute().getName();
            String idAttrValue = psoDefinition.getPsoIdentifierDefinition().getIdentifyingAttribute().getValue();
            Attribute attribute = attributes.get(idAttrName);
            if (attribute == null || !attribute.contains(idAttrValue)) continue;
            if (definition != null) {
                LOG.error("More than one schema entity found for " + entry.getDn());
                throw new LdappcException("More than one schema entity found for " + entry.getDn());
            }
            definition = psoDefinition;
        }
        if (definition == null) {
            LOG.error("Unable to determine schema entity for " + entry.getDn());
            throw new LdappcException("Unable to determine schema entity for " + entry.getDn());
        }
        return definition;
    }

    protected DSMLAttr getDsmlAttr(String name, Collection<String> values) throws DSMLProfileException {
        DSMLValue[] dsmlValues = null;
        DSMLAttr dsmlAttr = new DSMLAttr(name, dsmlValues);
        for (String value : values) {
            dsmlAttr.addValue(new DSMLValue(value));
        }
        return dsmlAttr;
    }

    protected List<Reference> getReferences(String name, Collection<String> values) throws Spml2Exception {
        try {
            ArrayList<Reference> references = new ArrayList<Reference>();
            for (String value : values) {
                Reference reference = new Reference();
                PSOIdentifier toPSOId = new PSOIdentifier();
                toPSOId.setID(LdapUtil.canonicalizeDn(value));
                toPSOId.setTargetID(this.getTargetDefinition().getId());
                reference.setToPsoID(toPSOId);
                reference.setTypeOfReference(name);
                references.add(reference);
            }
            return references;
        }
        catch (InvalidNameException e) {
            LOG.error("Unable to canonicalize name", (Throwable)e);
            throw new Spml2Exception((Throwable)e);
        }
    }

    protected List<ModificationItem> getDsmlMods(Modification modification) {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        for (Object object : modification.getOpenContentElements(DSMLModification.class)) {
            DSMLValue[] dsmlValues;
            DSMLModification dsmlModification = (DSMLModification)object;
            BasicAttribute attribute = new BasicAttribute(dsmlModification.getName());
            for (DSMLValue dsmlValue : dsmlValues = dsmlModification.getValues()) {
                attribute.add(dsmlValue.getValue());
            }
            int op = -1;
            if (dsmlModification.getOperation().equals(ModificationMode.ADD)) {
                op = 1;
            } else if (dsmlModification.getOperation().equals(ModificationMode.DELETE)) {
                op = 3;
            } else if (dsmlModification.getOperation().equals(ModificationMode.REPLACE)) {
                op = 2;
            } else {
                throw new LdappcException("Unknown dsml modification operation : " + dsmlModification.getOperation());
            }
            mods.add(new ModificationItem(op, attribute));
        }
        return mods;
    }

    protected List<ModificationItem> getReferenceMods(Modification modification) {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        Map<String, List<Reference>> references = PSP.getReferences(modification.getCapabilityData());
        if (references.isEmpty()) {
            return mods;
        }
        for (String typeOfReference : references.keySet()) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Reference reference : references.get(typeOfReference)) {
                if (!reference.getToPsoID().getTargetID().equals(this.getTargetDefinition().getId())) continue;
                String id = reference.getToPsoID().getID();
                if (id == null) {
                    id = "";
                }
                ids.add(id);
            }
            BasicAttribute attribute = new BasicAttribute(typeOfReference);
            for (String id : ids) {
                attribute.add(id);
            }
            int op = -1;
            if (modification.getModificationMode().equals(ModificationMode.ADD)) {
                op = 1;
            } else if (modification.getModificationMode().equals(ModificationMode.DELETE)) {
                op = 3;
            } else if (modification.getModificationMode().equals(ModificationMode.REPLACE)) {
                op = 2;
            } else {
                throw new LdappcException("Unknown modification operation : " + modification.getModificationMode());
            }
            mods.add(new ModificationItem(op, attribute));
        }
        return mods;
    }

    protected void handleEmptyReferences(AddRequest addRequest) throws DSMLProfileException {
        if (!addRequest.getReturnData().equals(ReturnData.DATA)) {
            return;
        }
        LOG.trace("add request before:\n{}", (Object)this.toXML((Marshallable)addRequest));
        String entityName = addRequest.findOpenContentAttrValueByName("entityName");
        if (entityName == null) {
            LOG.debug("TODO");
            return;
        }
        PSODefinition psoDefinition = this.getTargetDefinition().getPSODefinition(entityName);
        if (psoDefinition == null) {
            LOG.debug("TODO");
            return;
        }
        Map<String, DSMLAttr> dsmlAttrs = PSP.getDSMLAttrMap(addRequest.getData());
        for (PSOReferencesDefinition refsDef : psoDefinition.getReferenceDefinitions()) {
            DSMLAttr member;
            String emptyValue = refsDef.getEmptyValue();
            if (emptyValue == null || (member = dsmlAttrs.get(refsDef.getName())) != null && member.getValues().length != 0) continue;
            LOG.debug("TODO");
            addRequest.getData().addOpenContentElement((OpenContentElement)new DSMLAttr(refsDef.getName(), refsDef.getEmptyValue()));
        }
        LOG.trace("add request after:\n{}", (Object)this.toXML((Marshallable)addRequest));
    }

    public boolean isValidTargetId(PSOIdentifier psoID, Response response) {
        if (!psoID.getTargetID().equals(this.getTargetDefinition().getId())) {
            this.fail(response, ErrorCode.INVALID_IDENTIFIER, new String[0]);
            return false;
        }
        return true;
    }
}

