/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.provider;

import edu.internet2.middleware.ldappc.spml.provider.SpmlProvider;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.config.BaseReloadableService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.XMLUnmarshaller;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSpmlProvider
extends BaseReloadableService
implements SpmlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BaseSpmlProvider.class);
    private String id;
    public static final String methodName = "execute";
    private XMLMarshaller xmlMarshaller;
    private XMLUnmarshaller xmlUnmarshaller;

    public Response execute(Request request) {
        Response response = new Response();
        response.setRequestID(this.getOrGenerateRequestID(request));
        try {
            if (request.getExecutionMode() == ExecutionMode.ASYNCHRONOUS) {
                this.fail(response, ErrorCode.UNSUPPORTED_EXECUTION_MODE, new String[0]);
                LOG.error(PSPUtil.toString(response));
                LOG.trace("response:\n{}", (Object)this.toXML((Marshallable)response));
            } else {
                Method method = this.getClass().getMethod(methodName, request.getClass());
                response = (Response)method.invoke((Object)this, request);
                if (response.getRequestID() == null) {
                    response.setRequestID(this.getOrGenerateRequestID(request));
                }
            }
        }
        catch (NoSuchMethodException e) {
            this.fail(response, ErrorCode.UNSUPPORTED_OPERATION, e);
            LOG.error(PSPUtil.toString(response), (Throwable)e);
            LOG.trace("response:\n{}", (Object)this.toXML((Marshallable)response));
        }
        catch (IllegalAccessException e) {
            this.fail(response, ErrorCode.UNSUPPORTED_OPERATION, e);
            LOG.error(PSPUtil.toString(response), (Throwable)e);
            LOG.trace("response:\n{}", (Object)this.toXML((Marshallable)response));
        }
        catch (InvocationTargetException e) {
            this.fail(response, ErrorCode.UNSUPPORTED_OPERATION, e);
            LOG.error(PSPUtil.toString(response), (Throwable)e);
            LOG.trace("response:\n{}", (Object)this.toXML((Marshallable)response));
        }
        return response;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public XMLMarshaller getXMLMarshaller() {
        if (this.xmlMarshaller == null) {
            this.xmlMarshaller = new ReflectiveXMLMarshaller();
        }
        return this.xmlMarshaller;
    }

    public void setXMLMarshaller(XMLMarshaller xmlMarshaller) {
        this.xmlMarshaller = xmlMarshaller;
    }

    public XMLUnmarshaller getXmlUnmarshaller() {
        if (this.xmlUnmarshaller == null) {
            this.xmlUnmarshaller = new ReflectiveDOMXMLUnmarshaller();
        }
        return this.xmlUnmarshaller;
    }

    public void setXmlUnmarshaller(XMLUnmarshaller xmlUnmarshaller) {
        this.xmlUnmarshaller = xmlUnmarshaller;
    }

    public Response fail(Response response, ErrorCode errorCode, Exception e) {
        return this.fail(response, errorCode, e.getMessage());
    }

    public Response fail(Response response, ErrorCode errorCode, String ... messages) {
        response.setStatus(StatusCode.FAILURE);
        response.setError(errorCode);
        if (messages != null) {
            for (String message : messages) {
                if (message == null) continue;
                message = message.replace('\u0000', '_');
                response.addErrorMessage(message);
            }
        }
        return response;
    }

    public String generateRequestID() {
        return PSPUtil.uniqueRequestId();
    }

    public String getOrGenerateRequestID(Request request) {
        if (request.getRequestID() != null) {
            return request.getRequestID();
        }
        return this.generateRequestID();
    }

    public String toXML(Marshallable marshallable) {
        try {
            return marshallable.toXML(this.getXMLMarshaller());
        }
        catch (Spml2Exception e) {
            LOG.error("Unable to marshal xml", (Throwable)e);
            return null;
        }
    }
}

