/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.definitions;

import edu.internet2.middleware.grouper.shibboleth.util.OnNotFound;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSPContext;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.request.CalcRequest;
import edu.internet2.middleware.ldappc.spml.request.CalcResponse;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlref.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSOReferenceDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PSOReferenceDefinition.class);
    private String ref;
    private PSODefinition toPSODefinition;
    private OnNotFound onNotFound;
    public static String REFERENCE_NOT_FOUND = "REFERENCE_NOT_FOUND";
    private boolean multipleResults;
    public static String ERROR_MULTIPLE_RESULTS = "ERROR_MULTIPLE_RESULTS";

    public boolean isMultipleResults() {
        return this.multipleResults;
    }

    public void setMultipleResults(boolean multipleResults) {
        this.multipleResults = multipleResults;
    }

    public OnNotFound getOnNotFound() {
        return this.onNotFound;
    }

    public void setOnNotFound(OnNotFound onNotFound) {
        this.onNotFound = onNotFound;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public PSODefinition getToPSODefinition() {
        return this.toPSODefinition;
    }

    public void setToPSODefinition(PSODefinition toPSODefinition) {
        this.toPSODefinition = toPSODefinition;
    }

    public List<Reference> getReferences(PSPContext context, String typeOfReference) throws LdappcException {
        String msg = "get references for '" + context.getProvisioningRequest().getId() + "' ref '" + this.ref + "'";
        LOG.debug("{}", (Object)msg);
        ArrayList<Reference> references = new ArrayList<Reference>();
        Map<String, BaseAttribute<?>> attributes = context.getAttributes();
        if (!attributes.containsKey(this.ref)) {
            LOG.debug("{} source attribute does not exist", (Object)msg);
            return references;
        }
        BaseAttribute<?> referenceAttribute = attributes.get(this.ref);
        for (Object id : referenceAttribute.getValues()) {
            CalcRequest calcRequest = new CalcRequest();
            calcRequest.setReturnData(ReturnData.IDENTIFIER);
            calcRequest.setId(id.toString());
            SchemaEntityRef schemaEntityRef = new SchemaEntityRef();
            schemaEntityRef.setTargetID(this.getToPSODefinition().getPsoIdentifierDefinition().getTargetDefinition().getId());
            schemaEntityRef.setEntityName(this.getToPSODefinition().getId());
            calcRequest.addSchemaEntity(schemaEntityRef);
            CalcResponse calcResponse = (CalcResponse)context.getProvisioningServiceProvider().execute((Request)calcRequest);
            List<PSO> psos = calcResponse.getPSOs();
            if (calcResponse.getStatus().equals(StatusCode.FAILURE) || calcResponse.getStatus().equals(StatusCode.SUCCESS) && psos.isEmpty()) {
                if (this.onNotFound.equals((Object)OnNotFound.warn)) {
                    LOG.warn("{} unable to resolve identifier '{}'", (Object)msg, id);
                } else if (this.onNotFound.equals((Object)OnNotFound.fail)) {
                    LOG.error("{} unable to resolve identifier '{}'", (Object)msg, id);
                    throw new LdappcException(REFERENCE_NOT_FOUND);
                }
            }
            if (calcResponse.getStatus().equals(StatusCode.SUCCESS)) {
                if (!this.multipleResults && psos.size() > 1) {
                    LOG.error("Unable to resolve {} : {} results found", (Object)msg, (Object)psos.size());
                    throw new LdappcException(ERROR_MULTIPLE_RESULTS);
                }
                for (PSO pso : psos) {
                    Reference reference = new Reference();
                    reference.setToPsoID(pso.getPsoID());
                    reference.setTypeOfReference(typeOfReference);
                    references.add(reference);
                }
            }
            if (!calcResponse.getStatus().equals(StatusCode.PENDING)) continue;
            LOG.error("Unable to resolve {} identifier {} " + ErrorCode.UNSUPPORTED_EXECUTION_MODE, (Object)msg, id);
            throw new LdappcException(ErrorCode.UNSUPPORTED_EXECUTION_MODE.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} found {} references", (Object)msg, (Object)references.size());
            for (Reference reference : references) {
                LOG.debug("{} reference : '{}'", (Object)msg, (Object)PSPUtil.getString(reference));
            }
        }
        return references;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("ref", (Object)this.ref);
        toStringBuilder.append("toPSODefinition", (Object)this.toPSODefinition.getId());
        toStringBuilder.append("onNotFound", (Object)this.onNotFound);
        toStringBuilder.append("multipleResults", this.multipleResults);
        return toStringBuilder.toString();
    }
}

