/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.definitions;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSPContext;
import edu.internet2.middleware.ldappc.spml.definitions.PSOAttributeDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOIdentifierDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferenceDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferencesDefinition;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.util.Spml2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSODefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PSODefinition.class);
    private String id;
    private List<PSOAttributeDefinition> psoAttributeDefinitions;
    private PSOIdentifierDefinition psoIdentifierDefinition;
    private List<PSOReferencesDefinition> psoReferencesDefinitions;
    private boolean authoritative;
    public static final String ENTITY_NAME_ATTRIBUTE = "entityName";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public void setAuthoritative(boolean authoritative) {
        this.authoritative = authoritative;
    }

    public PSOAttributeDefinition getAttributeDefinition(String name) {
        for (PSOAttributeDefinition psoAttributeDefinition : this.psoAttributeDefinitions) {
            if (!psoAttributeDefinition.getName().equals(name)) continue;
            return psoAttributeDefinition;
        }
        return null;
    }

    public List<PSOAttributeDefinition> getAttributeDefinitions() {
        return this.psoAttributeDefinitions;
    }

    public void setAttributeDefinitions(List<PSOAttributeDefinition> attributeDefinitions) {
        this.psoAttributeDefinitions = attributeDefinitions;
    }

    public PSOIdentifierDefinition getPsoIdentifierDefinition() {
        return this.psoIdentifierDefinition;
    }

    public void setPsoIdentifierDefinition(PSOIdentifierDefinition identifierDefinition) {
        this.psoIdentifierDefinition = identifierDefinition;
    }

    public PSOReferencesDefinition getReferencesDefinition(String name) {
        for (PSOReferencesDefinition r : this.psoReferencesDefinitions) {
            if (!r.getName().endsWith(name)) continue;
            return r;
        }
        return null;
    }

    public List<PSOReferencesDefinition> getReferenceDefinitions() {
        return this.psoReferencesDefinitions;
    }

    public void setReferenceDefinitions(List<PSOReferencesDefinition> referenceDefinitions) {
        this.psoReferencesDefinitions = referenceDefinitions;
    }

    public Set<String> getAttributeNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PSOAttributeDefinition psoAttributeDefinition : this.psoAttributeDefinitions) {
            names.add(psoAttributeDefinition.getName());
        }
        return names;
    }

    public Set<String> getAttributeSourceIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (PSOAttributeDefinition psoAttributeDefinition : this.psoAttributeDefinitions) {
            ids.add(psoAttributeDefinition.getRef());
        }
        return ids;
    }

    public Set<String> getReferenceNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PSOReferencesDefinition psoReferencesDefinition : this.psoReferencesDefinitions) {
            names.add(psoReferencesDefinition.getName());
        }
        return names;
    }

    public Set<String> getReferenceSourceIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (PSOReferencesDefinition psoReferencesDefinition : this.psoReferencesDefinitions) {
            for (PSOReferenceDefinition psoReferenceDefinition : psoReferencesDefinition.getPsoReferenceDefinitions()) {
                ids.add(psoReferenceDefinition.getRef());
            }
        }
        return ids;
    }

    public Set<String> getSourceIds(ReturnData returnData) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.getPsoIdentifierDefinition().getRef());
        if (returnData.equals(ReturnData.DATA) || returnData.equals(ReturnData.EVERYTHING)) {
            set.addAll(this.getAttributeSourceIds());
        }
        if (returnData.equals(ReturnData.EVERYTHING)) {
            set.addAll(this.getReferenceSourceIds());
        }
        return set;
    }

    public List<PSO> getPSO(PSPContext context) throws LdappcException, Spml2Exception {
        String msg = "get pso '" + context.getProvisioningRequest().getId() + "' object '" + this.id + "' return '" + context.getProvisioningRequest().getReturnData() + "'";
        LOG.debug("{}", (Object)msg);
        ArrayList<PSO> psos = new ArrayList<PSO>();
        List<PSOIdentifier> psoIdentifiers = this.getPsoIdentifierDefinition().getPSOIdentifier(context);
        if (psoIdentifiers.isEmpty()) {
            LOG.debug("{} identifier is empty", (Object)msg);
            return psos;
        }
        Extensible data = null;
        ReturnData returnData = context.getProvisioningRequest().getReturnData();
        if (returnData.equals(ReturnData.DATA) || returnData.equals(ReturnData.EVERYTHING)) {
            for (PSOAttributeDefinition psoAttributeDefinition : this.getAttributeDefinitions()) {
                DSMLAttr dsmlAttr = psoAttributeDefinition.getAttribute(context.getAttributes());
                if (dsmlAttr == null) continue;
                if (data == null) {
                    data = new Extensible();
                }
                data.addOpenContentElement((OpenContentElement)dsmlAttr);
            }
        }
        ArrayList<Reference> references = null;
        if (returnData.equals(ReturnData.EVERYTHING)) {
            references = new ArrayList<Reference>();
            for (PSOReferencesDefinition psoReferenceDefinition : this.getReferenceDefinitions()) {
                references.addAll(psoReferenceDefinition.getReferences(context));
            }
        }
        for (PSOIdentifier psoIdentifier : psoIdentifiers) {
            PSO pso = new PSO();
            pso.setPsoID(psoIdentifier);
            pso.addOpenContentAttr(ENTITY_NAME_ATTRIBUTE, this.id);
            if (data != null) {
                pso.setData(data);
            }
            if (references != null && !references.isEmpty()) {
                PSPUtil.setReferences(pso, references);
            }
            psos.add(pso);
        }
        LOG.debug("{} returned {}", (Object)msg, (Object)psos.size());
        return psos;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("id", (Object)this.id);
        toStringBuilder.append("authoritative", this.authoritative);
        return toStringBuilder.toString();
    }
}

