/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.config;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.config.PSOAttributeDefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.config.PSOIdentifierDefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.config.PSOReferencesDefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PSODefinitionBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(PSODefinitionBeanDefinitionParser.class);
    public static final QName TYPE_NAME = new QName("http://grouper.internet2.edu/ldappc", "object");

    protected Class getBeanClass(Element element) {
        return PSODefinition.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        String id = element.getAttributeNS(null, "id");
        LOG.debug("Setting id of element '{}' to '{}'", (Object)element.getLocalName(), (Object)id);
        builder.addPropertyValue("id", (Object)id);
        String authoritative = element.getAttributeNS(null, "authoritative");
        LOG.debug("Setting authoritative of element '{}' to '{}'", (Object)element.getLocalName(), (Object)authoritative);
        builder.addPropertyValue("authoritative", (Object)authoritative);
        Map configChildren = XMLHelper.getChildElements((Element)element);
        builder.addPropertyValue("psoIdentifierDefinition", (Object)SpringConfigurationUtils.parseInnerCustomElement((Element)((Element)((List)configChildren.get(PSOIdentifierDefinitionBeanDefinitionParser.TYPE_NAME)).get(0)), (ParserContext)parserContext));
        builder.addPropertyValue("attributeDefinitions", (Object)SpringConfigurationUtils.parseInnerCustomElements((List)((List)configChildren.get(PSOAttributeDefinitionBeanDefinitionParser.TYPE_NAME)), (ParserContext)parserContext));
        builder.addPropertyValue("referenceDefinitions", (Object)SpringConfigurationUtils.parseInnerCustomElements((List)((List)configChildren.get(PSOReferencesDefinitionBeanDefinitionParser.TYPE_NAME)), (ParserContext)parserContext));
    }

    protected static String resolveId(Element element) {
        String id = element.getAttributeNS(null, "id");
        if (!element.hasAttributeNS(null, "targetId")) {
            LOG.error("Object element '{}' must have a targetId", (Object)id);
            throw new LdappcException("Object element must have a targetId");
        }
        String targetId = element.getAttributeNS(null, "targetId");
        return targetId + ":" + id;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return PSODefinitionBeanDefinitionParser.resolveId(element);
    }
}

