/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.config;

import edu.internet2.middleware.ldappc.spml.config.PSODefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.definitions.PSOAttributeDefinition;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PSOAttributeDefinitionBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(PSOAttributeDefinitionBeanDefinitionParser.class);
    public static final QName TYPE_NAME = new QName("http://grouper.internet2.edu/ldappc", "attribute");

    protected Class getBeanClass(Element element) {
        return PSOAttributeDefinition.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        String name = element.getAttributeNS(null, "name");
        LOG.debug("Setting name of element '{}' to '{}'", (Object)element.getLocalName(), (Object)name);
        builder.addPropertyValue("name", (Object)name);
        String ref = element.getAttributeNS(null, "ref");
        if (ref.equals("")) {
            ref = name;
        }
        LOG.debug("Setting ref of element '{}' to '{}'", (Object)element.getLocalName(), (Object)ref);
        builder.addPropertyValue("ref", (Object)ref);
        String isMultiValued = element.getAttributeNS(null, "isMultiValued");
        LOG.debug("Setting isMultiValued of element '{}' to: '{}'", (Object)element.getLocalName(), (Object)isMultiValued);
        builder.addPropertyValue("isMultiValued", (Object)isMultiValued);
        String retainAll = element.getAttributeNS(null, "retainAll");
        LOG.debug("Setting retainAll of element '{}' to: '{}'", (Object)element.getLocalName(), (Object)retainAll);
        builder.addPropertyValue("retainAll", (Object)retainAll);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = element.getAttributeNS(null, "name");
        Element objectElement = (Element)element.getParentNode();
        return PSODefinitionBeanDefinitionParser.resolveId(objectElement) + ":" + name;
    }
}

