/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.config;

import edu.internet2.middleware.ldappc.spml.config.PSODefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.config.PSOIdentifierDefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.config.TargetDefinitionBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigBeanDefinitionParser.class);
    public static final QName TYPE_NAME = new QName("http://grouper.internet2.edu/ldappc", "ldappc");
    public static final String TARGET_TOK = "${target}";
    public static final String ID_DELIMITER = ":";

    public BeanDefinition parse(Element config, ParserContext context) {
        Element newConfig = this.rewriteConfig(config);
        List targetsElements = XMLHelper.getChildElementsByTagNameNS((Element)newConfig, (String)"http://grouper.internet2.edu/ldappc", (String)"targets");
        for (Element targetsElement : targetsElements) {
            Map configChildren = XMLHelper.getChildElements((Element)targetsElement);
            List targets = (List)configChildren.get(TargetDefinitionBeanDefinitionParser.TYPE_NAME);
            SpringConfigurationUtils.parseInnerCustomElements((List)targets, (ParserContext)context);
        }
        return null;
    }

    public Element rewriteConfig(Element config) {
        LOG.trace("original config :\n{}", (Object)XMLHelper.prettyPrintXML((Node)config));
        Element newConfig = (Element)config.cloneNode(true);
        List targetsElements = XMLHelper.getChildElementsByTagNameNS((Element)newConfig, (String)"http://grouper.internet2.edu/ldappc", (String)"targets");
        for (Element targetsElement : targetsElements) {
            List targets = XMLHelper.getChildElementsByTagNameNS((Element)targetsElement, (String)"http://grouper.internet2.edu/ldappc", (String)TargetDefinitionBeanDefinitionParser.TYPE_NAME.getLocalPart());
            List oldObjects = XMLHelper.getChildElementsByTagNameNS((Element)targetsElement, (String)"http://grouper.internet2.edu/ldappc", (String)PSODefinitionBeanDefinitionParser.TYPE_NAME.getLocalPart());
            for (Element target : targets) {
                String targetId = target.getAttributeNS(null, "id");
                for (Element oldObject : oldObjects) {
                    Element newObject = (Element)oldObject.cloneNode(true);
                    newObject.setAttribute("targetId", targetId);
                    LOG.debug("rewrote object '{}' with targetId '{}'", (Object)newObject.getAttributeNS(null, "id"), (Object)targetId);
                    Element identifier = (Element)XMLHelper.getChildElementsByTagNameNS((Element)newObject, (String)"http://grouper.internet2.edu/ldappc", (String)PSOIdentifierDefinitionBeanDefinitionParser.TYPE_NAME.getLocalPart()).get(0);
                    String ref = identifier.getAttribute("ref");
                    if (ref.contains(TARGET_TOK)) {
                        String rewrittenId = ref.replace(TARGET_TOK, targetId);
                        LOG.debug("rewrote ref '{}' as '{}'", (Object)ref, (Object)rewrittenId);
                        identifier.setAttribute("ref", rewrittenId);
                    }
                    target.appendChild(newObject);
                }
            }
            for (int i = 0; i < oldObjects.size(); ++i) {
                Element object = (Element)oldObjects.get(i);
                Node parent = object.getParentNode();
                parent.removeChild(object);
            }
        }
        LOG.trace("rewritten config :\n{}", (Object)XMLHelper.prettyPrintXML((Node)newConfig));
        return newConfig;
    }
}

