/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml;

import edu.internet2.middleware.ldappc.spml.request.BulkCalcRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkDiffRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkProvisioningRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkSyncRequest;
import edu.internet2.middleware.ldappc.spml.request.CalcRequest;
import edu.internet2.middleware.ldappc.spml.request.DiffRequest;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningRequest;
import edu.internet2.middleware.ldappc.spml.request.SyncRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.SchemaEntityRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSPOptions {
    public static final String NAME = "ldappc-ng";
    private String[] args;
    private String beanName;
    private String confDir;
    private int interval = 0;
    private Date lastModifyTime;
    private boolean logSpml;
    private Options options;
    private String outputFile;
    private boolean printRequests;
    private List<ProvisioningRequest> requests;

    public PSPOptions(String[] args) {
        this.args = args;
        this.initOptions();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getConfDir() {
        return this.confDir;
    }

    public int getInterval() {
        return this.interval;
    }

    public Date getLastModifyTime() {
        return this.lastModifyTime;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public List<ProvisioningRequest> getRequests() {
        return this.requests;
    }

    private void initOptions() {
        this.options = new Options();
        OptionGroup requestOp = new OptionGroup();
        requestOp.setRequired(true);
        requestOp.addOption(Mode.calc.getOption());
        requestOp.addOption(Mode.diff.getOption());
        requestOp.addOption(Mode.sync.getOption());
        requestOp.addOption(Mode.bulkCalc.getOption());
        requestOp.addOption(Mode.bulkDiff.getOption());
        requestOp.addOption(Mode.bulkSync.getOption());
        this.options.addOptionGroup(requestOp);
        OptionGroup returnData = new OptionGroup();
        returnData.addOption(Opts.returnData.getOption());
        returnData.addOption(Opts.returnEverything.getOption());
        returnData.addOption(Opts.returnIdentifier.getOption());
        returnData.setRequired(false);
        this.options.addOptionGroup(returnData);
        this.options.addOption(Opts.conf.getOption());
        this.options.addOption(Opts.entityName.getOption());
        this.options.addOption(Opts.interval.getOption());
        this.options.addOption(Opts.lastModifyTime.getOption());
        this.options.addOption(Opts.logSpml.getOption());
        this.options.addOption(Opts.output.getOption());
        this.options.addOption(Opts.requestID.getOption());
        this.options.addOption(Opts.printRequests.getOption());
        this.options.addOption(Opts.targetID.getOption());
    }

    public boolean isLogSpml() {
        return this.logSpml;
    }

    public boolean isPrintRequests() {
        return this.printRequests;
    }

    public void parseCommandLineOptions() throws ParseException {
        GnuParser parser = new GnuParser();
        CommandLine line = parser.parse(this.options, this.args);
        this.requests = new ArrayList<ProvisioningRequest>();
        for (Mode mode : Mode.values()) {
            if (!line.hasOption(mode.getOpt())) continue;
            this.requests.addAll(mode.getRequests(line));
        }
        for (Enum enum_ : Opts.values()) {
            if (!line.hasOption(((Opts)enum_).getOpt())) continue;
            ((Opts)enum_).handle(this, line);
        }
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(NAME, this.options, true);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setConfDir(String confDir) {
        this.confDir = confDir;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setLastModifyTime(Date lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public void setLogSpml(boolean logSpml) {
        this.logSpml = logSpml;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setPrintRequests(boolean printRequests) {
        this.printRequests = printRequests;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("args", (Object[])this.args);
        toStringBuilder.append("beanName", (Object)this.beanName);
        toStringBuilder.append("confDir", (Object)this.confDir);
        toStringBuilder.append("interval", this.interval);
        toStringBuilder.append("logSpml", this.logSpml);
        toStringBuilder.append("outputFile", (Object)this.outputFile);
        toStringBuilder.append("printRequests", this.printRequests);
        return toStringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Opts {
        conf{

            public Option getOption() {
                Option option = new Option("conf", true, "Configuration directory.");
                option.setArgName("dir");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                pspOptions.setConfDir(line.getOptionValue(this.getOpt()));
            }
        }
        ,
        entityName{

            public Option getOption() {
                Option option = new Option("entityName", true, "Entity name or provisioned object ID.");
                option.setArgName("id");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                String entityName = line.getOptionValue(this.getOpt());
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    if (request.getSchemaEntities().isEmpty()) {
                        request.addSchemaEntity(new SchemaEntityRef());
                    }
                    if (request.getSchemaEntities().size() > 1) {
                        throw new IllegalArgumentException("Only one schema entity is supported.");
                    }
                    request.getSchemaEntities().get(0).setEntityName(entityName);
                }
            }
        }
        ,
        interval{

            public Option getOption() {
                Option option = new Option("interval", true, "Number of seconds between provisioning cycles. If omitted, only one provisioning cycle is performed.");
                option.setArgName("seconds");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                pspOptions.setInterval(Integer.parseInt(line.getOptionValue(this.getOpt())));
            }
        }
        ,
        lastModifyTime{

            public Option getOption() {
                Option option = new Option("lastModifyTime", true, "Select objects changed since this time.");
                option.setArgName("yyyy-MM-dd[_hh:mm:ss]");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    if (!(request instanceof BulkProvisioningRequest)) continue;
                    try {
                        ((BulkProvisioningRequest)request).setUpdatedSince(line.getOptionValue(this.getOpt()));
                        if (pspOptions.getLastModifyTime() != null) continue;
                        pspOptions.setLastModifyTime(((BulkProvisioningRequest)request).getUpdatedSinceAsDate());
                    }
                    catch (java.text.ParseException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        ,
        logSpml{

            public Option getOption() {
                return new Option("logSpml", "Log SPML requests and responses.");
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                if (line.hasOption(this.getOpt())) {
                    pspOptions.setLogSpml(true);
                }
            }
        }
        ,
        output{

            public Option getOption() {
                Option option = new Option("output", true, "Output file.");
                option.setArgName("file");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                pspOptions.setOutputFile(line.getOptionValue(this.getOpt()));
            }
        }
        ,
        printRequests{

            public Option getOption() {
                Option option = new Option("printRequests", "Print SPML requests as well as responses.");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                pspOptions.setPrintRequests(true);
            }
        }
        ,
        requestID{

            public Option getOption() {
                Option option = new Option("requestID", true, "Request ID.");
                option.setArgName("id");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    request.setRequestID(line.getOptionValue(this.getOpt()));
                }
            }
        }
        ,
        returnData{

            public Option getOption() {
                Option option = new Option("returnData", "Return data.");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    request.setReturnData(ReturnData.DATA);
                }
            }
        }
        ,
        returnEverything{

            public Option getOption() {
                Option option = new Option("returnEverything", "Return everything.");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    request.setReturnData(ReturnData.EVERYTHING);
                }
            }
        }
        ,
        returnIdentifier{

            public Option getOption() {
                Option option = new Option("returnIdentifier", "Return identifier.");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    request.setReturnData(ReturnData.IDENTIFIER);
                }
            }
        }
        ,
        targetID{

            public Option getOption() {
                Option option = new Option("targetID", true, "Target ID.");
                option.setArgName("id");
                return option;
            }

            public void handle(PSPOptions pspOptions, CommandLine line) {
                String targetId = line.getOptionValue(this.getOpt());
                for (ProvisioningRequest request : pspOptions.getRequests()) {
                    if (request.getSchemaEntities().isEmpty()) {
                        request.addSchemaEntity(new SchemaEntityRef());
                    }
                    if (request.getSchemaEntities().size() > 1) {
                        throw new IllegalArgumentException("Only one schema entity is supported.");
                    }
                    request.getSchemaEntities().get(0).setTargetID(targetId);
                }
            }
        };


        public String getOpt() {
            return this.getOption().getOpt();
        }

        public abstract Option getOption();

        public abstract void handle(PSPOptions var1, CommandLine var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        bulkCalc{

            public ProvisioningRequest getNewProvisioningRequest() {
                return new BulkCalcRequest();
            }

            public Option getOption() {
                return new Option("bulkCalc", "Calculate provisioning for all identifiers.");
            }
        }
        ,
        bulkDiff{

            public ProvisioningRequest getNewProvisioningRequest() {
                return new BulkDiffRequest();
            }

            public Option getOption() {
                return new Option("bulkDiff", "Determine provisioning difference for all identifiers.");
            }
        }
        ,
        bulkSync{

            public ProvisioningRequest getNewProvisioningRequest() {
                return new BulkSyncRequest();
            }

            public Option getOption() {
                return new Option("bulkSync", "Synchronize provisioning for all identifiers.");
            }
        }
        ,
        calc{

            public ProvisioningRequest getNewProvisioningRequest() {
                return new CalcRequest();
            }

            public Option getOption() {
                Option option = new Option("calc", "Calculate provisioning for an identifier.");
                option.setArgs(-2);
                option.setArgName("id");
                return option;
            }
        }
        ,
        diff{

            public ProvisioningRequest getNewProvisioningRequest() {
                return new DiffRequest();
            }

            public Option getOption() {
                Option option = new Option("diff", "Determine provisioning difference for an identifier.");
                option.setArgs(-2);
                option.setArgName("id");
                return option;
            }
        }
        ,
        sync{

            public ProvisioningRequest getNewProvisioningRequest() {
                return new SyncRequest();
            }

            public Option getOption() {
                Option option = new Option("sync", "Synchronize provisioning for an identifier.");
                option.setArgs(-2);
                option.setArgName("id");
                return option;
            }
        };


        public abstract ProvisioningRequest getNewProvisioningRequest();

        public String getOpt() {
            return this.getOption().getOpt();
        }

        public abstract Option getOption();

        public List<ProvisioningRequest> getRequests(CommandLine line) {
            ArrayList<ProvisioningRequest> requests = new ArrayList<ProvisioningRequest>();
            if (this.getOption().hasArg()) {
                for (String id : line.getOptionValues(this.getOpt())) {
                    ProvisioningRequest request = this.getNewProvisioningRequest();
                    request.setId(id);
                    requests.add(request);
                }
            } else {
                requests.add(this.getNewProvisioningRequest());
            }
            return requests;
        }
    }
}

