/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.definitions.PSOAttributeDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.definitions.TargetDefinition;
import edu.internet2.middleware.ldappc.spml.request.CalcRequest;
import edu.internet2.middleware.ldappc.spml.request.CalcResponse;
import edu.internet2.middleware.ldappc.spml.request.DiffRequest;
import edu.internet2.middleware.ldappc.spml.request.DiffResponse;
import edu.internet2.middleware.ldappc.spml.request.SynchronizedResponse;
import edu.internet2.middleware.ldappc.synchronize.AttributeModifier;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.CapabilityData;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.util.Spml2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSPDiffer {
    private static final Logger LOG = LoggerFactory.getLogger(PSPDiffer.class);
    private PSP psp;
    private DiffRequest diffRequest;
    private DiffResponse diffResponse;

    public PSPDiffer(PSP psp, DiffRequest diffRequest, DiffResponse diffResponse) {
        this.psp = psp;
        this.diffRequest = diffRequest;
        this.diffResponse = diffResponse;
    }

    public void diff() {
        this.diffResponse.setId(this.diffRequest.getId());
        CalcRequest calcRequest = new CalcRequest();
        calcRequest.setId(this.diffRequest.getId());
        calcRequest.setRequestID(this.psp.generateRequestID());
        calcRequest.setReturnData(this.diffRequest.getReturnData());
        calcRequest.setSchemaEntities(this.diffRequest.getSchemaEntities());
        CalcResponse calcResponse = this.psp.execute(calcRequest);
        if (calcResponse.getStatus().equals(StatusCode.FAILURE)) {
            this.psp.fail((Response)this.diffResponse, calcResponse.getError(), calcResponse.getErrorMessages());
            return;
        }
        for (PSO correctPSO : calcResponse.getPSOs()) {
            LookupRequest lookupRequest = new LookupRequest();
            lookupRequest.setPsoID(correctPSO.getPsoID());
            lookupRequest.setRequestID(this.psp.generateRequestID());
            lookupRequest.setReturnData(this.diffRequest.getReturnData());
            LookupResponse lookupResponse = this.psp.execute(lookupRequest);
            if (lookupResponse.getStatus().equals(StatusCode.FAILURE) && lookupResponse.getError().equals(ErrorCode.NO_SUCH_IDENTIFIER)) {
                this.diffResponse.addRequest(this.psp.add(correctPSO, this.diffRequest.getReturnData()));
                continue;
            }
            if (lookupResponse.getStatus().equals(StatusCode.FAILURE)) {
                this.psp.fail((Response)this.diffResponse, lookupResponse.getError(), "Lookup request failed.");
                return;
            }
            try {
                PSO currentPSO = lookupResponse.getPso();
                List<ModifyRequest> modifyRequests = this.diff(correctPSO, currentPSO);
                if (modifyRequests.isEmpty()) {
                    SynchronizedResponse synchronizedResponse = new SynchronizedResponse();
                    synchronizedResponse.setPsoID(currentPSO.getPsoID());
                    this.diffResponse.addResponse(synchronizedResponse);
                    continue;
                }
                for (ModifyRequest modifyRequest : modifyRequests) {
                    modifyRequest.setReturnData(this.diffRequest.getReturnData());
                    this.diffResponse.addRequest(modifyRequest);
                }
            }
            catch (LdappcException e) {
                this.psp.fail((Response)this.diffResponse, ErrorCode.CUSTOM_ERROR, e);
            }
            catch (Spml2Exception e) {
                this.psp.fail((Response)this.diffResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
            }
        }
    }

    private List<ModifyRequest> diff(PSO correctPSO, PSO currentPSO) throws LdappcException, Spml2Exception {
        String currentEntityName;
        ArrayList<ModifyRequest> modifyRequests = new ArrayList<ModifyRequest>();
        if (!correctPSO.getPsoID().equals((Object)currentPSO.getPsoID())) {
            LOG.error("Unable to diff objects with different identifiers : '{}' and '{}'", (Object)PSPUtil.getString(correctPSO.getPsoID()), (Object)PSPUtil.toString(currentPSO.getPsoID()));
            throw new LdappcException("Unable to diff objects with different identifiers.");
        }
        String correctEntityName = correctPSO.findOpenContentAttrValueByName("entityName");
        if (!correctEntityName.equals(currentEntityName = currentPSO.findOpenContentAttrValueByName("entityName"))) {
            LOG.error("Unable to diff objects with different entityNames : '{}' and '{}'", (Object)correctEntityName, (Object)currentEntityName);
            throw new LdappcException("Unable to diff objects with different entityNames.");
        }
        List<Modification> dataMods = this.diffData(correctPSO, currentPSO);
        List<Modification> referenceMods = this.diffReferences(correctPSO, currentPSO);
        if (dataMods.isEmpty() && referenceMods.isEmpty()) {
            return modifyRequests;
        }
        if (this.psp.getTargetDefinitions().get(correctPSO.getPsoID().getTargetID()).isBundleModifications()) {
            ModifyRequest modifyRequest = new ModifyRequest();
            modifyRequest.setRequestID(this.psp.generateRequestID());
            modifyRequest.setPsoID(correctPSO.getPsoID());
            if (correctEntityName != null) {
                modifyRequest.addOpenContentAttr("entityName", correctEntityName);
            }
            for (Modification modification : dataMods) {
                modifyRequest.addModification(modification);
            }
            for (Modification modification : referenceMods) {
                modifyRequest.addModification(modification);
            }
            modifyRequests.add(modifyRequest);
        } else {
            modifyRequests.addAll(this.unbundleDataModifications(dataMods, correctPSO.getPsoID(), correctEntityName));
            modifyRequests.addAll(this.unbundleReferenceModifications(referenceMods, correctPSO.getPsoID(), correctEntityName));
        }
        return modifyRequests;
    }

    private List<Modification> diffData(PSO correctPSO, PSO currentPSO) throws DSMLProfileException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        if (!this.diffRequest.getReturnData().equals(ReturnData.DATA) && !this.diffRequest.getReturnData().equals(ReturnData.EVERYTHING)) {
            return modifications;
        }
        Map<String, DSMLAttr> currentDsmlAttrs = PSP.getDSMLAttrMap(currentPSO.getData());
        Map<String, DSMLAttr> correctDsmlAttrs = PSP.getDSMLAttrMap(correctPSO.getData());
        LinkedHashSet<String> attrNames = new LinkedHashSet<String>();
        attrNames.addAll(correctDsmlAttrs.keySet());
        attrNames.addAll(currentDsmlAttrs.keySet());
        String targetId = currentPSO.getPsoID().getTargetID();
        TargetDefinition targetDefinition = this.psp.getTargetDefinitions().get(targetId);
        String entityName = currentPSO.findOpenContentAttrValueByName("entityName");
        PSODefinition psoDefinition = targetDefinition.getPSODefinition(entityName);
        for (String attrName : attrNames) {
            PSOAttributeDefinition psoAttributeDefinition = psoDefinition.getAttributeDefinition(attrName);
            if (psoAttributeDefinition != null) continue;
            LOG.error("Unknown psoAttributeDefinition '" + attrName + "'");
            throw new LdappcException("Unknown psoAttributeDefinition '" + attrName + "'");
        }
        for (String attrName : attrNames) {
            DSMLAttr currentDsmlAttr = currentDsmlAttrs.get(attrName);
            DSMLAttr correctDsmlAttr = correctDsmlAttrs.get(attrName);
            AttributeModifier attributeModifier = new AttributeModifier(attrName, true);
            if (currentDsmlAttr != null) {
                attributeModifier.initDSML(currentDsmlAttr.getValues());
                PSOAttributeDefinition psoAttributeDefinition = psoDefinition.getAttributeDefinition(attrName);
                if (psoAttributeDefinition.isRetainAll()) {
                    attributeModifier.retainAll();
                }
            }
            if (correctDsmlAttr != null) {
                attributeModifier.store(correctDsmlAttr.getValues());
            }
            modifications.addAll(attributeModifier.getDSMLModification());
        }
        return modifications;
    }

    private List<Modification> diffReferences(PSO correctPSO, PSO currentPSO) throws Spml2Exception {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        if (!this.diffRequest.getReturnData().equals(ReturnData.EVERYTHING)) {
            return modifications;
        }
        Map<String, List<Reference>> correctReferenceMap = PSP.getReferences(correctPSO.getCapabilityData());
        Map<String, List<Reference>> currentReferenceMap = PSP.getReferences(currentPSO.getCapabilityData());
        LinkedHashSet<String> typeOfReferences = new LinkedHashSet<String>();
        typeOfReferences.addAll(correctReferenceMap.keySet());
        typeOfReferences.addAll(currentReferenceMap.keySet());
        for (String typeOfReference : typeOfReferences) {
            List<Reference> currentReferences = currentReferenceMap.get(typeOfReference);
            List<Reference> correctReferences = correctReferenceMap.get(typeOfReference);
            AttributeModifier attributeModifier = new AttributeModifier(typeOfReference, true);
            if (currentReferences != null) {
                attributeModifier.initReference(currentReferences);
            }
            if (correctReferences != null) {
                attributeModifier.store(correctReferences);
            }
            modifications.addAll(attributeModifier.getReferenceModification());
        }
        return modifications;
    }

    private List<ModifyRequest> unbundleDataModifications(List<Modification> dataMods, PSOIdentifier psoID, String entityName) throws Spml2Exception {
        ArrayList<ModifyRequest> unbundledModifyRequests = new ArrayList<ModifyRequest>();
        for (Modification modification : dataMods) {
            for (Object object : modification.getOpenContentElements(DSMLModification.class)) {
                DSMLValue[] dsmlValues;
                DSMLModification dsmlModification = (DSMLModification)object;
                for (DSMLValue dsmlValue : dsmlValues = dsmlModification.getValues()) {
                    ModifyRequest unbundledModifyRequest = new ModifyRequest();
                    unbundledModifyRequest.setRequestID(this.psp.generateRequestID());
                    unbundledModifyRequest.setPsoID(psoID);
                    if (entityName != null) {
                        unbundledModifyRequest.addOpenContentAttr("entityName", entityName);
                    }
                    DSMLModification dsmlMod = new DSMLModification(dsmlModification.getName(), new DSMLValue[]{dsmlValue}, dsmlModification.getOperation());
                    Modification unbundledModification = new Modification();
                    unbundledModification.setModificationMode(modification.getModificationMode());
                    unbundledModification.addOpenContentElement((OpenContentElement)dsmlMod);
                    unbundledModifyRequest.addModification(unbundledModification);
                    unbundledModifyRequests.add(unbundledModifyRequest);
                }
            }
        }
        return unbundledModifyRequests;
    }

    private List<ModifyRequest> unbundleReferenceModifications(List<Modification> referenceMods, PSOIdentifier psoID, String entityName) throws Spml2Exception {
        ArrayList<ModifyRequest> unbundledModifyRequests = new ArrayList<ModifyRequest>();
        for (Modification modification : referenceMods) {
            Map<String, List<Reference>> references = PSP.getReferences(modification.getCapabilityData());
            for (String typeOfReference : references.keySet()) {
                for (Reference reference : references.get(typeOfReference)) {
                    ModifyRequest unbundledModifyRequest = new ModifyRequest();
                    unbundledModifyRequest.setRequestID(this.psp.generateRequestID());
                    unbundledModifyRequest.setPsoID(psoID);
                    if (entityName != null) {
                        unbundledModifyRequest.addOpenContentAttr("entityName", entityName);
                    }
                    CapabilityData capabilityData = PSPUtil.fromReferences(Arrays.asList(reference));
                    Modification unbundledModification = new Modification();
                    unbundledModification.addCapabilityData(capabilityData);
                    unbundledModification.setModificationMode(modification.getModificationMode());
                    unbundledModifyRequest.addModification(unbundledModification);
                    unbundledModifyRequests.add(unbundledModifyRequest);
                }
            }
        }
        return unbundledModifyRequests;
    }
}

