/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml;

import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.PSPOptions;
import edu.internet2.middleware.ldappc.spml.request.BulkProvisioningRequest;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningRequest;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.opensaml.util.resource.ResourceException;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSPCLI
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(PSPCLI.class);
    private PSP psp;
    private Timer timer;

    public static void main(String[] args) {
        PSPOptions options = new PSPOptions(args);
        try {
            if (args.length == 0) {
                options.printUsage();
                return;
            }
            options.parseCommandLineOptions();
            PSPCLI pspCLI = new PSPCLI(options);
            if (options.getInterval() == 0) {
                pspCLI.run();
            } else {
                pspCLI.schedule();
            }
        }
        catch (ParseException e) {
            options.printUsage();
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ResourceException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public PSPCLI(PSPOptions options) throws ResourceException {
        this.psp = PSP.getPSP(options);
    }

    public void run() {
        try {
            LOG.info("Starting {}", (Object)"ldappc-ng");
            LOG.debug("Starting {} with options {}", (Object)"ldappc-ng", (Object)this.psp.getPspOptions());
            PrintStream printStream = null;
            printStream = GrouperUtil.isBlank((String)this.psp.getPspOptions().getOutputFile()) ? System.out : new PrintStream(FileUtils.openOutputStream((File)new File(this.psp.getPspOptions().getOutputFile())));
            Date now = new Date();
            StopWatch sw = new StopWatch();
            sw.start();
            for (ProvisioningRequest request : this.psp.getPspOptions().getRequests()) {
                if (request instanceof BulkProvisioningRequest && this.psp.getPspOptions().getLastModifyTime() != null) {
                    ((BulkProvisioningRequest)request).setUpdatedSince(this.psp.getPspOptions().getLastModifyTime());
                }
                if (this.psp.getPspOptions().isPrintRequests()) {
                    printStream.print(this.psp.toXML((Marshallable)request));
                }
                Response response = this.psp.execute((Request)request);
                printStream.print(this.psp.toXML((Marshallable)response));
            }
            printStream.flush();
            if (!printStream.equals(System.out)) {
                printStream.close();
            }
            sw.stop();
            LOG.info("End of {} execution : {} ms", (Object)"ldappc-ng", (Object)sw.getTime());
            for (ProvisioningRequest request : this.psp.getPspOptions().getRequests()) {
                if (!(request instanceof BulkProvisioningRequest) || this.psp.getPspOptions().getLastModifyTime() == null) continue;
                this.psp.getPspOptions().setLastModifyTime(now);
                break;
            }
        }
        catch (IOException e) {
            LOG.error("Unable to write SPML.", (Throwable)e);
            this.cancel();
        }
    }

    public void schedule() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, (long)(1000 * this.psp.getPspOptions().getInterval()));
    }

    public Timer getTimer() {
        return this.timer;
    }
}

