/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml;

import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSPContext;
import edu.internet2.middleware.ldappc.spml.PSPDiffer;
import edu.internet2.middleware.ldappc.spml.PSPOptions;
import edu.internet2.middleware.ldappc.spml.definitions.IdentifyingAttribute;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferencesDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.TargetDefinition;
import edu.internet2.middleware.ldappc.spml.provider.BaseSpmlProvider;
import edu.internet2.middleware.ldappc.spml.request.BulkCalcRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkCalcResponse;
import edu.internet2.middleware.ldappc.spml.request.BulkDiffRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkDiffResponse;
import edu.internet2.middleware.ldappc.spml.request.BulkProvisioningRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkProvisioningRequestHandler;
import edu.internet2.middleware.ldappc.spml.request.BulkSyncRequest;
import edu.internet2.middleware.ldappc.spml.request.BulkSyncResponse;
import edu.internet2.middleware.ldappc.spml.request.CalcRequest;
import edu.internet2.middleware.ldappc.spml.request.CalcResponse;
import edu.internet2.middleware.ldappc.spml.request.DiffRequest;
import edu.internet2.middleware.ldappc.spml.request.DiffResponse;
import edu.internet2.middleware.ldappc.spml.request.LdapFilterQueryClause;
import edu.internet2.middleware.ldappc.spml.request.LdappcMarshallableCreator;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningRequest;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningResponse;
import edu.internet2.middleware.ldappc.spml.request.SyncRequest;
import edu.internet2.middleware.ldappc.spml.request.SyncResponse;
import edu.internet2.middleware.ldappc.spml.request.SynchronizedResponse;
import edu.internet2.middleware.ldappc.util.MDCHelper;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestContext;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensaml.util.resource.ResourceException;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.CapabilityData;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.DeleteResponse;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.ListTargetsRequest;
import org.openspml.v2.msg.spml.ListTargetsResponse;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.QueryClause;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlbatch.OnError;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLUnmarshaller;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSP
extends BaseSpmlProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PSP.class);
    public static final String DEFAULT_BEAN_NAME = "ldappc";
    private static String[] CONFIG_FILES = new String[]{"ldappc-internal.xml", "ldappc-services.xml"};
    private String id;
    private AttributeAuthority attributeAuthority;
    private Map<String, TargetDefinition> targetDefinitions;
    private PSPOptions pspOptions;

    public void initialize() throws ServiceException {
        super.initialize();
        ObjectFactory.getInstance().addCreator((ObjectFactory.MarshallableCreator)new LdappcMarshallableCreator());
        ObjectFactory.getInstance().addOCEUnmarshaller((ObjectFactory.OCEUnmarshaller)new DSMLUnmarshaller());
    }

    public static PSP getPSP(PSPOptions pspOptions) throws ResourceException {
        String confDir = pspOptions != null ? pspOptions.getConfDir() : null;
        String beanName = pspOptions.getBeanName() != null ? pspOptions.getBeanName() : DEFAULT_BEAN_NAME;
        LOG.info("Loading PSP from configuration directory '{}' with bean name '{}'", (Object)confDir, (Object)beanName);
        GenericApplicationContext context = PSPUtil.createSpringContext(PSPUtil.getResources(confDir, CONFIG_FILES));
        PSP psp = (PSP)context.getBean(beanName);
        psp.setPspOptions(pspOptions);
        return psp;
    }

    public PSPOptions getPspOptions() {
        return this.pspOptions;
    }

    public void setPspOptions(PSPOptions pspOptions) {
        this.pspOptions = pspOptions;
    }

    public CalcResponse execute(CalcRequest calcRequest) {
        MDCHelper mdc = new MDCHelper((Request)calcRequest).start();
        LOG.info("{}", (Object)calcRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)calcRequest));
        }
        CalcResponse calcResponse = new CalcResponse();
        calcResponse.setStatus(StatusCode.SUCCESS);
        calcResponse.setRequestID(this.getOrGenerateRequestID((Request)calcRequest));
        if (this.isValid(calcRequest, (ProvisioningResponse)calcResponse)) {
            calcResponse.setId(calcRequest.getId());
            try {
                PSPContext context = this.getProvisioningContext(calcRequest);
                Map<TargetDefinition, List<PSODefinition>> map = context.getTargetAndObjectDefinitions();
                for (TargetDefinition targetDefinition : map.keySet()) {
                    for (PSODefinition psoDefinition : map.get(targetDefinition)) {
                        for (PSO pso : psoDefinition.getPSO(context)) {
                            calcResponse.addPSO(pso);
                        }
                    }
                }
                if (calcResponse.getPSOs().isEmpty()) {
                    this.fail((Response)calcResponse, ErrorCode.NO_SUCH_IDENTIFIER, "Unable to calculate provisioned object.");
                }
            }
            catch (LdappcException e) {
                this.fail((Response)calcResponse, ErrorCode.CUSTOM_ERROR, e);
            }
            catch (AttributeRequestException e) {
                this.fail((Response)calcResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
            }
            catch (Spml2Exception e) {
                this.fail((Response)calcResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
            }
        }
        if (calcResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info("{}", (Object)calcResponse);
        } else {
            LOG.error("{}", (Object)calcResponse);
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)calcResponse));
        }
        mdc.stop();
        return calcResponse;
    }

    public DiffResponse execute(DiffRequest diffRequest) {
        MDCHelper mdc = new MDCHelper((Request)diffRequest).start();
        LOG.info("{}", (Object)diffRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)diffRequest));
        }
        DiffResponse diffResponse = new DiffResponse();
        diffResponse.setStatus(StatusCode.SUCCESS);
        diffResponse.setRequestID(this.getOrGenerateRequestID((Request)diffRequest));
        if (this.isValid(diffRequest, (ProvisioningResponse)diffResponse)) {
            new PSPDiffer(this, diffRequest, diffResponse).diff();
        }
        if (diffResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info("{}", (Object)diffResponse);
        } else {
            LOG.error("{}", (Object)diffResponse);
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)diffResponse));
        }
        mdc.stop();
        return diffResponse;
    }

    public SyncResponse execute(SyncRequest syncRequest) {
        MDCHelper mdc = new MDCHelper((Request)syncRequest).start();
        LOG.info("{}", (Object)syncRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)syncRequest));
        }
        SyncResponse syncResponse = new SyncResponse();
        syncResponse.setStatus(StatusCode.SUCCESS);
        syncResponse.setRequestID(this.getOrGenerateRequestID((Request)syncRequest));
        if (!this.isValid(syncRequest, (ProvisioningResponse)syncResponse)) {
            this.fail((Response)syncResponse, ErrorCode.MALFORMED_REQUEST, "An id is required.");
            LOG.error("{}", (Object)syncResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)syncResponse));
            }
            mdc.stop();
            return syncResponse;
        }
        syncResponse.setId(syncRequest.getId());
        DiffRequest diffRequest = new DiffRequest();
        diffRequest.setId(syncRequest.getId());
        diffRequest.setRequestID(this.generateRequestID());
        diffRequest.setReturnData(syncRequest.getReturnData());
        diffRequest.setSchemaEntities(syncRequest.getSchemaEntities());
        DiffResponse diffResponse = this.execute(diffRequest);
        if (diffResponse.getStatus().equals(StatusCode.FAILURE)) {
            this.fail((Response)syncResponse, diffResponse.getError(), diffResponse.getErrorMessages());
            LOG.error("{}", (Object)syncResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)syncResponse));
            }
            mdc.stop();
            return syncResponse;
        }
        for (Request request : diffResponse.getRequests()) {
            Response response = this.execute(request);
            syncResponse.addResponse(response);
            if (!response.getStatus().equals(StatusCode.FAILURE)) continue;
            this.fail((Response)syncResponse, response.getError(), response.getErrorMessages());
            LOG.error("{}", (Object)syncResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)syncResponse));
            }
            mdc.stop();
            return syncResponse;
        }
        if (syncResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info("{}", (Object)syncResponse);
        } else {
            LOG.error("{}", (Object)syncResponse);
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)syncResponse));
        }
        mdc.stop();
        return syncResponse;
    }

    public LookupResponse execute(LookupRequest lookupRequest) {
        MDCHelper mdc = new MDCHelper((Request)lookupRequest).start();
        LOG.info(PSPUtil.toString(lookupRequest));
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupRequest));
        }
        LookupResponse lookupResponse = new LookupResponse();
        lookupResponse.setStatus(StatusCode.SUCCESS);
        lookupResponse.setRequestID(this.getOrGenerateRequestID((Request)lookupRequest));
        if (this.isValid(lookupRequest.getPsoID(), (Response)lookupResponse)) {
            TargetDefinition targetDefinition = this.targetDefinitions.get(lookupRequest.getPsoID().getTargetID());
            Response targetProviderResponse = targetDefinition.getProvider().execute((Request)lookupRequest);
            if (!(targetProviderResponse instanceof LookupResponse)) {
                this.fail((Response)lookupResponse, ErrorCode.CUSTOM_ERROR, "Target did not return a lookup response.");
            } else {
                lookupResponse = (LookupResponse)targetProviderResponse;
            }
        }
        this.isValid((Response)lookupResponse);
        if (lookupResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info(PSPUtil.toString(lookupResponse));
        } else {
            LOG.error(PSPUtil.toString(lookupResponse));
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)lookupResponse));
        }
        mdc.stop();
        return lookupResponse;
    }

    public SearchResponse execute(SearchRequest searchRequest) {
        MDCHelper mdc = new MDCHelper((Request)searchRequest).start();
        LOG.info("{}", (Object)PSPUtil.toString(searchRequest));
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)searchRequest));
        }
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setStatus(StatusCode.SUCCESS);
        searchResponse.setRequestID(this.getOrGenerateRequestID((Request)searchRequest));
        if (this.isValid(searchRequest, searchResponse)) {
            TargetDefinition targetDefinition;
            Response targetProviderResponse;
            if (searchRequest.getReturnData() == null) {
                searchRequest.setReturnData(ReturnData.EVERYTHING);
            }
            if (!((targetProviderResponse = (targetDefinition = this.targetDefinitions.get(searchRequest.getQuery().getTargetID())).getProvider().execute((Request)searchRequest)) instanceof SearchResponse)) {
                this.fail((Response)searchResponse, ErrorCode.CUSTOM_ERROR, "Target did not return a SearchResponse.");
            } else {
                searchResponse = (SearchResponse)targetProviderResponse;
            }
        }
        if (searchResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info(PSPUtil.toString(searchResponse));
        } else {
            LOG.error(PSPUtil.toString(searchResponse));
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)searchResponse));
        }
        mdc.stop();
        return searchResponse;
    }

    public AddResponse execute(AddRequest addRequest) {
        MDCHelper mdc = new MDCHelper((Request)addRequest).start();
        LOG.info(PSPUtil.toString(addRequest));
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)addRequest));
        }
        AddResponse addResponse = new AddResponse();
        addResponse.setRequestID(this.getOrGenerateRequestID((Request)addRequest));
        if (this.isValid(addRequest, addResponse)) {
            TargetDefinition targetDefinition = this.targetDefinitions.get(addRequest.getPsoID().getTargetID());
            Response targetProviderResponse = targetDefinition.getProvider().execute((Request)addRequest);
            if (!(targetProviderResponse instanceof AddResponse)) {
                this.fail((Response)addResponse, ErrorCode.CUSTOM_ERROR, "Target did not return a AddResponse.");
            } else {
                addResponse = (AddResponse)targetProviderResponse;
            }
        }
        this.isValid((Response)addResponse);
        if (addResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info(PSPUtil.toString(addResponse));
        } else {
            LOG.error(PSPUtil.toString(addResponse));
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)addResponse));
        }
        mdc.stop();
        return addResponse;
    }

    public DeleteResponse execute(DeleteRequest deleteRequest) {
        MDCHelper mdc = new MDCHelper((Request)deleteRequest).start();
        LOG.info(PSPUtil.toString(deleteRequest));
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteRequest));
        }
        DeleteResponse deleteResponse = new DeleteResponse();
        deleteResponse.setRequestID(this.getOrGenerateRequestID((Request)deleteRequest));
        if (this.isValid(deleteRequest.getPsoID(), (Response)deleteResponse)) {
            TargetDefinition targetDefinition = this.targetDefinitions.get(deleteRequest.getPsoID().getTargetID());
            Response targetProviderResponse = targetDefinition.getProvider().execute((Request)deleteRequest);
            if (!(targetProviderResponse instanceof DeleteResponse)) {
                this.fail((Response)deleteResponse, ErrorCode.CUSTOM_ERROR, "Target did not return a DeleteResponse.");
            } else {
                deleteResponse = (DeleteResponse)targetProviderResponse;
            }
        }
        this.isValid((Response)deleteResponse);
        if (deleteResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info(PSPUtil.toString((Response)deleteResponse));
        } else {
            LOG.error(PSPUtil.toString((Response)deleteResponse));
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
        }
        mdc.stop();
        return deleteResponse;
    }

    public ModifyResponse execute(ModifyRequest modifyRequest) {
        MDCHelper mdc = new MDCHelper((Request)modifyRequest).start();
        LOG.info(PSPUtil.toString(modifyRequest));
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)modifyRequest));
        }
        ModifyResponse modifyResponse = new ModifyResponse();
        modifyResponse.setRequestID(this.getOrGenerateRequestID((Request)modifyRequest));
        if (this.isValid(modifyRequest, modifyResponse)) {
            TargetDefinition targetDefinition = this.targetDefinitions.get(modifyRequest.getPsoID().getTargetID());
            Response targetProviderResponse = targetDefinition.getProvider().execute((Request)modifyRequest);
            if (!(targetProviderResponse instanceof ModifyResponse)) {
                this.fail((Response)modifyResponse, ErrorCode.CUSTOM_ERROR, "Target did not return a ModifyResponse.");
            } else {
                modifyResponse = (ModifyResponse)targetProviderResponse;
            }
        }
        this.isValid((Response)modifyResponse);
        if (modifyResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info(PSPUtil.toString(modifyResponse));
        } else {
            LOG.error(PSPUtil.toString(modifyResponse));
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)modifyResponse));
        }
        mdc.stop();
        return modifyResponse;
    }

    public ListTargetsResponse execute(ListTargetsRequest listTargetsRequest) {
        MDCHelper mdc = new MDCHelper((Request)listTargetsRequest).start();
        LOG.info("{}", (Object)listTargetsRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)listTargetsRequest));
        }
        ListTargetsResponse listTargetsResponse = new ListTargetsResponse();
        listTargetsResponse.setStatus(StatusCode.SUCCESS);
        listTargetsResponse.setRequestID(this.getOrGenerateRequestID((Request)listTargetsRequest));
        try {
            for (TargetDefinition psoTargetDefinition : this.targetDefinitions.values()) {
                listTargetsResponse.addTarget(psoTargetDefinition.getTarget());
            }
        }
        catch (Spml2Exception e) {
            this.fail((Response)listTargetsResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
        }
        if (listTargetsResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info(PSPUtil.toString((Response)listTargetsResponse));
        } else {
            LOG.error(PSPUtil.toString((Response)listTargetsResponse));
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)listTargetsResponse));
        }
        mdc.stop();
        return listTargetsResponse;
    }

    public BulkCalcResponse execute(BulkCalcRequest bulkCalcRequest) {
        MDCHelper mdc = new MDCHelper((Request)bulkCalcRequest).start();
        LOG.info("{}", (Object)bulkCalcRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkCalcRequest));
        }
        BulkCalcResponse bulkCalcResponse = new BulkCalcResponse();
        bulkCalcResponse.setStatus(StatusCode.SUCCESS);
        bulkCalcResponse.setRequestID(this.getOrGenerateRequestID((Request)bulkCalcRequest));
        if (!this.isValid(bulkCalcRequest, (ProvisioningResponse)bulkCalcResponse)) {
            LOG.error("{}", (Object)bulkCalcResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkCalcResponse));
            }
            mdc.stop();
            return bulkCalcResponse;
        }
        BulkProvisioningRequestHandler handler = new BulkProvisioningRequestHandler(this, bulkCalcRequest);
        Set<String> identifiers = handler.getAllIdentifiers();
        for (String identifier : identifiers) {
            CalcRequest calcRequest = new CalcRequest();
            calcRequest.setId(identifier);
            calcRequest.setRequestID(this.generateRequestID());
            calcRequest.setReturnData(bulkCalcRequest.getReturnData());
            calcRequest.setSchemaEntities(bulkCalcRequest.getSchemaEntities());
            CalcResponse calcResponse = this.execute(calcRequest);
            bulkCalcResponse.addResponse(calcResponse);
            if (calcResponse.getStatus() == StatusCode.SUCCESS || bulkCalcResponse.getStatus() == StatusCode.FAILURE) continue;
            bulkCalcResponse.setStatus(StatusCode.FAILURE);
            if (!bulkCalcRequest.getOnError().equals(OnError.EXIT)) continue;
            LOG.error("{}", (Object)bulkCalcResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkCalcResponse));
            }
            mdc.stop();
            return bulkCalcResponse;
        }
        if (bulkCalcResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info("{}", (Object)bulkCalcResponse);
        } else {
            LOG.error("{}", (Object)bulkCalcResponse);
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkCalcResponse));
        }
        mdc.stop();
        return bulkCalcResponse;
    }

    public BulkDiffResponse execute(BulkDiffRequest bulkDiffRequest) {
        MDCHelper mdc = new MDCHelper((Request)bulkDiffRequest).start();
        LOG.info("{}", (Object)bulkDiffRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkDiffRequest));
        }
        BulkDiffResponse bulkDiffResponse = new BulkDiffResponse();
        bulkDiffResponse.setStatus(StatusCode.SUCCESS);
        bulkDiffResponse.setRequestID(this.getOrGenerateRequestID((Request)bulkDiffRequest));
        if (!this.isValid(bulkDiffRequest, (ProvisioningResponse)bulkDiffResponse)) {
            LOG.error("{}", (Object)bulkDiffResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkDiffResponse));
            }
            mdc.stop();
            return bulkDiffResponse;
        }
        LinkedHashSet<PSOIdentifier> correctPsoIds = new LinkedHashSet<PSOIdentifier>();
        BulkProvisioningRequestHandler handler = new BulkProvisioningRequestHandler(this, bulkDiffRequest);
        Set<String> identifiers = handler.getAllIdentifiers();
        for (String identifier : identifiers) {
            DiffRequest diffRequest = new DiffRequest();
            diffRequest.setId(identifier);
            diffRequest.setRequestID(this.generateRequestID());
            diffRequest.setReturnData(bulkDiffRequest.getReturnData());
            diffRequest.setSchemaEntities(bulkDiffRequest.getSchemaEntities());
            DiffResponse diffResponse = this.execute(diffRequest);
            bulkDiffResponse.addResponse(diffResponse);
            if (diffResponse.getStatus() != StatusCode.SUCCESS && bulkDiffResponse.getStatus() != StatusCode.FAILURE) {
                bulkDiffResponse.setStatus(StatusCode.FAILURE);
                if (bulkDiffRequest.getOnError().equals(OnError.EXIT)) {
                    LOG.error("{}", (Object)bulkDiffResponse);
                    if (this.pspOptions.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkDiffResponse));
                    }
                    mdc.stop();
                    return bulkDiffResponse;
                }
            }
            if (!diffResponse.getStatus().equals(StatusCode.SUCCESS)) continue;
            correctPsoIds.addAll(diffResponse.getPsoIds());
        }
        Set<PSOIdentifier> currentPsoIds = this.searchForPsoIds(this.getTargetAndObjectDefinitions(bulkDiffRequest));
        if (currentPsoIds == null) {
            this.fail((Response)bulkDiffResponse, ErrorCode.CUSTOM_ERROR, "An error occured while searching.");
            LOG.error("{}", (Object)bulkDiffResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkDiffResponse));
            }
            mdc.stop();
            return bulkDiffResponse;
        }
        for (PSOIdentifier psoId : currentPsoIds) {
            if (correctPsoIds.contains(psoId)) continue;
            DeleteRequest deleteRequest = new DeleteRequest();
            deleteRequest.setPsoID(psoId);
            deleteRequest.setRequestID(this.generateRequestID());
            DiffResponse diffResponse = new DiffResponse();
            diffResponse.setId(psoId.getID());
            diffResponse.addRequest(deleteRequest);
            bulkDiffResponse.addResponse(diffResponse);
        }
        if (bulkDiffResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info("{}", (Object)bulkDiffResponse);
        } else {
            LOG.error("{}", (Object)bulkDiffResponse);
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkDiffResponse));
        }
        mdc.stop();
        return bulkDiffResponse;
    }

    public BulkSyncResponse execute(BulkSyncRequest bulkSyncRequest) {
        MDCHelper mdc = new MDCHelper((Request)bulkSyncRequest).start();
        LOG.info("{}", (Object)bulkSyncRequest);
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncRequest));
        }
        BulkSyncResponse bulkSyncResponse = new BulkSyncResponse();
        bulkSyncResponse.setStatus(StatusCode.SUCCESS);
        bulkSyncResponse.setRequestID(this.getOrGenerateRequestID((Request)bulkSyncRequest));
        if (!this.isValid(bulkSyncRequest, (ProvisioningResponse)bulkSyncResponse)) {
            LOG.error("{}", (Object)bulkSyncResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncResponse));
            }
            mdc.stop();
            return bulkSyncResponse;
        }
        BulkDiffRequest bulkDiffRequest = new BulkDiffRequest();
        bulkDiffRequest.setOnError(bulkSyncRequest.getOnError());
        bulkDiffRequest.setRequestID(this.generateRequestID());
        bulkDiffRequest.setReturnData(bulkSyncRequest.getReturnData());
        bulkDiffRequest.setSchemaEntities(bulkSyncRequest.getSchemaEntities());
        bulkDiffRequest.setUpdatedSince(bulkSyncRequest.getUpdatedSinceAsDate());
        BulkDiffResponse bulkDiffResponse = this.execute(bulkDiffRequest);
        if (bulkDiffResponse.getStatus() != StatusCode.SUCCESS && bulkSyncRequest.getOnError().equals(OnError.EXIT)) {
            this.fail((Response)bulkSyncResponse, bulkDiffResponse.getError(), bulkDiffResponse.getErrorMessages());
            LOG.error("{}", (Object)bulkSyncResponse);
            if (this.pspOptions.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncResponse));
            }
            mdc.stop();
            return bulkSyncResponse;
        }
        for (DiffResponse diffResponse : bulkDiffResponse.getResponses()) {
            for (Request request : diffResponse.getRequests()) {
                String targetId = null;
                if (request instanceof AddRequest) {
                    targetId = ((AddRequest)request).getTargetId();
                } else if (request instanceof ModifyRequest) {
                    targetId = ((ModifyRequest)request).getPsoID().getTargetID();
                } else if (request instanceof DeleteRequest) {
                    targetId = ((DeleteRequest)request).getPsoID().getTargetID();
                } else {
                    this.fail((Response)bulkSyncResponse, ErrorCode.UNSUPPORTED_OPERATION, "Unsupported request " + request.getClass());
                    LOG.error("{}", (Object)bulkSyncResponse);
                    if (this.pspOptions.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncResponse));
                    }
                    mdc.stop();
                    return bulkSyncResponse;
                }
                TargetDefinition targetDefinition = this.targetDefinitions.get(targetId);
                if (GrouperUtil.isBlank((Object)targetDefinition)) {
                    this.fail((Response)bulkSyncResponse, ErrorCode.NO_SUCH_IDENTIFIER, "Unknown target id '" + targetId + "'");
                    LOG.error("{}", (Object)bulkSyncResponse);
                    if (this.pspOptions.isLogSpml()) {
                        LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncResponse));
                    }
                    mdc.stop();
                    return bulkSyncResponse;
                }
                Response response = targetDefinition.getProvider().execute(request);
                SyncResponse syncResponse = new SyncResponse();
                syncResponse.setId(diffResponse.getId());
                syncResponse.addResponse(response);
                bulkSyncResponse.addResponse(syncResponse);
                if (response.getStatus() == StatusCode.SUCCESS || bulkSyncResponse.getStatus() == StatusCode.FAILURE) continue;
                bulkSyncResponse.setStatus(StatusCode.FAILURE);
                if (!bulkSyncRequest.getOnError().equals(OnError.EXIT)) continue;
                LOG.error("{}", (Object)bulkSyncResponse);
                if (this.pspOptions.isLogSpml()) {
                    LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncResponse));
                }
                mdc.stop();
                return bulkSyncResponse;
            }
            for (SynchronizedResponse synchronizedResponse : diffResponse.getSynchronizedResponses()) {
                SyncResponse syncResponse = new SyncResponse();
                syncResponse.setId(diffResponse.getId());
                syncResponse.addResponse(synchronizedResponse);
                bulkSyncResponse.addResponse(syncResponse);
            }
        }
        if (bulkSyncResponse.getStatus().equals(StatusCode.SUCCESS)) {
            LOG.info("{}", (Object)bulkSyncResponse);
        } else {
            LOG.error("{}", (Object)bulkSyncResponse);
        }
        if (this.pspOptions.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)bulkSyncResponse));
        }
        mdc.stop();
        return bulkSyncResponse;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public AttributeAuthority getAttributeAuthority() {
        return this.attributeAuthority;
    }

    public void setAttributeAuthority(AttributeAuthority attributeAuthority) {
        this.attributeAuthority = attributeAuthority;
    }

    public PSPContext getProvisioningContext(ProvisioningRequest provisioningRequest) throws AttributeRequestException, Spml2Exception, LdappcException {
        PSPContext provContext = new PSPContext();
        provContext.setProvisioningServiceProvider(this);
        provContext.setProvisioningRequest(provisioningRequest);
        BaseSAMLProfileRequestContext attributeRequestContext = new BaseSAMLProfileRequestContext();
        attributeRequestContext.setPrincipalName(provisioningRequest.getId());
        Map<TargetDefinition, List<PSODefinition>> map = this.getTargetAndObjectDefinitions(provisioningRequest);
        provContext.setTargetAndObjectDefinitions(map);
        LinkedHashSet<String> attributeIds = new LinkedHashSet<String>();
        for (TargetDefinition psoTargetDefinition : map.keySet()) {
            for (PSODefinition psoDefinition : map.get(psoTargetDefinition)) {
                attributeIds.addAll(psoDefinition.getSourceIds(provisioningRequest.getReturnData()));
            }
        }
        attributeRequestContext.setRequestedAttributes(attributeIds);
        LOG.debug("{} resolving attributes {}", (Object)provisioningRequest, attributeIds);
        Map attributes = this.getAttributeAuthority().getAttributes((AttributeRequestContext)attributeRequestContext);
        LOG.debug("{} resolved attributes {}", (Object)provisioningRequest, attributes.keySet());
        provContext.setAttributes(attributes);
        return provContext;
    }

    public Map<String, TargetDefinition> getTargetDefinitions() {
        return this.targetDefinitions;
    }

    public Map<TargetDefinition, List<PSODefinition>> getTargetAndObjectDefinitions(ProvisioningRequest request) throws LdappcException {
        LinkedHashMap<TargetDefinition, List<PSODefinition>> map = new LinkedHashMap<TargetDefinition, List<PSODefinition>>();
        if (request.getSchemaEntities().isEmpty()) {
            map.putAll(this.getTargetAndObjectDefinitions(new SchemaEntityRef()));
        } else {
            for (SchemaEntityRef schemaEntityRef : request.getSchemaEntities()) {
                map.putAll(this.getTargetAndObjectDefinitions(schemaEntityRef));
            }
        }
        return map;
    }

    public Map<TargetDefinition, List<PSODefinition>> getTargetAndObjectDefinitions(SchemaEntityRef schemaEntityRef) throws LdappcException {
        String objectId;
        String msg = "get target and object definitions for " + PSPUtil.toString(schemaEntityRef);
        LOG.debug(msg);
        LinkedHashMap<TargetDefinition, List<PSODefinition>> map = new LinkedHashMap<TargetDefinition, List<PSODefinition>>();
        String targetId = schemaEntityRef == null ? null : schemaEntityRef.getTargetID();
        String string = objectId = schemaEntityRef == null ? null : schemaEntityRef.getEntityName();
        if (GrouperUtil.isBlank((String)targetId) && GrouperUtil.isBlank((String)objectId)) {
            for (TargetDefinition targetDefinition : this.targetDefinitions.values()) {
                map.put(targetDefinition, targetDefinition.getPsoDefinitions());
            }
        } else if (GrouperUtil.isBlank((String)targetId)) {
            for (TargetDefinition targetDefinition : this.targetDefinitions.values()) {
                PSODefinition psoDefinition = targetDefinition.getPSODefinition(objectId);
                if (psoDefinition == null) {
                    LOG.error("Unknown object id '" + objectId + "'");
                    throw new LdappcException("Unknown object id '" + objectId + "'");
                }
                map.put(targetDefinition, new ArrayList());
                ((List)map.get(targetDefinition)).add(psoDefinition);
            }
        } else if (GrouperUtil.isBlank((String)objectId)) {
            TargetDefinition targetDefinition = this.targetDefinitions.get(targetId);
            if (targetDefinition == null) {
                LOG.error("Unknown target id '" + targetId + "'");
                throw new LdappcException("Unknown target id '" + targetId + "'");
            }
            map.put(targetDefinition, targetDefinition.getPsoDefinitions());
        } else {
            TargetDefinition targetDefinition = this.targetDefinitions.get(targetId);
            if (targetDefinition == null) {
                LOG.error("Unknown target id '" + targetId + "'");
                throw new LdappcException("Unknown target id '" + targetId + "'");
            }
            PSODefinition psoDefinition = targetDefinition.getPSODefinition(objectId);
            if (psoDefinition == null) {
                LOG.error("Unknown object id '" + objectId + "'");
                throw new LdappcException("Unknown object id '" + objectId + "'");
            }
            map.put(targetDefinition, new ArrayList());
            ((List)map.get(targetDefinition)).add(psoDefinition);
        }
        LOG.debug("{} found {}", (Object)msg, map);
        return map;
    }

    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        Map<String, TargetDefinition> oldTargetDefinitions = this.targetDefinitions;
        try {
            String[] beanNames = newServiceContext.getBeanNamesForType(TargetDefinition.class);
            LOG.debug("Loading {} target definitions {}", (Object)beanNames.length, Arrays.asList(beanNames));
            this.targetDefinitions = new LinkedHashMap<String, TargetDefinition>(beanNames.length);
            for (String beanName : beanNames) {
                TargetDefinition targetDefinition = (TargetDefinition)newServiceContext.getBean(beanName);
                this.targetDefinitions.put(targetDefinition.getId(), targetDefinition);
                targetDefinition.getProvider().setTargetDefinition(targetDefinition);
                targetDefinition.getProvider().setPSP(this);
            }
        }
        catch (Exception e) {
            this.targetDefinitions = oldTargetDefinitions;
            LOG.error(this.getId() + " configuration is not valid, retaining old configuration", (Throwable)e);
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", e);
        }
    }

    public static Map<String, DSMLAttr> getDSMLAttrMap(Extensible data) {
        LinkedHashMap<String, DSMLAttr> dsmlAttrs = new LinkedHashMap<String, DSMLAttr>();
        if (data == null) {
            return dsmlAttrs;
        }
        for (Object object : data.getOpenContentElements(DSMLAttr.class)) {
            DSMLAttr dsmlAttr = (DSMLAttr)object;
            dsmlAttrs.put(dsmlAttr.getName(), dsmlAttr);
        }
        return dsmlAttrs;
    }

    public static Map<String, List<Reference>> getReferences(CapabilityData[] capabilityDataArray) throws LdappcException {
        LinkedHashMap<String, List<Reference>> references = new LinkedHashMap<String, List<Reference>>();
        for (CapabilityData capabilityData : capabilityDataArray) {
            if (capabilityData.getCapabilityURI().equals(PSOReferencesDefinition.REFERENCE_URI)) {
                for (Object object : capabilityData.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
                    Object adaptedObject = ((OCEtoMarshallableAdapter)object).getAdaptedObject();
                    if (!(adaptedObject instanceof Reference)) continue;
                    Reference reference = (Reference)adaptedObject;
                    if (!references.containsKey(reference.getTypeOfReference())) {
                        references.put(reference.getTypeOfReference(), new ArrayList());
                    }
                    ((List)references.get(reference.getTypeOfReference())).add(reference);
                }
                continue;
            }
            LOG.warn("Encountered unhandled capability data '{}'", (Object)capabilityData.getCapabilityURI());
            if (!capabilityData.isMustUnderstand()) continue;
            LOG.error("Encountered unhandled capability data '{}' which must be understood.", (Object)capabilityData.getCapabilityURI());
            throw new LdappcException("Encountered unhandled capability data which must be understood.");
        }
        return references;
    }

    public AddRequest add(PSO pso, ReturnData returnData) {
        AddRequest addRequest = new AddRequest();
        addRequest.setRequestID(this.generateRequestID());
        addRequest.setReturnData(returnData);
        String entityName = pso.findOpenContentAttrValueByName("entityName");
        if (entityName != null) {
            addRequest.addOpenContentAttr("entityName", entityName);
        }
        addRequest.setPsoID(pso.getPsoID());
        addRequest.setTargetId(pso.getPsoID().getTargetID());
        if (pso.getPsoID().getContainerID() != null) {
            addRequest.setContainerID(pso.getPsoID().getContainerID());
        }
        if (returnData.equals(ReturnData.DATA) || returnData.equals(ReturnData.EVERYTHING)) {
            addRequest.setData(pso.getData());
        }
        if (returnData.equals(ReturnData.EVERYTHING)) {
            for (CapabilityData capabilityData : pso.getCapabilityData()) {
                addRequest.addCapabilityData(capabilityData);
            }
        }
        return addRequest;
    }

    public Set<PSOIdentifier> searchForPsoIds(Map<TargetDefinition, List<PSODefinition>> map) {
        LinkedHashSet<PSOIdentifier> psoIds = new LinkedHashSet<PSOIdentifier>();
        for (TargetDefinition targetDefinition : map.keySet()) {
            for (PSODefinition psoDef : map.get(targetDefinition)) {
                if (!psoDef.isAuthoritative()) continue;
                PSOIdentifier basePsoId = new PSOIdentifier();
                basePsoId.setID(psoDef.getPsoIdentifierDefinition().getBaseId());
                IdentifyingAttribute ia = psoDef.getPsoIdentifierDefinition().getIdentifyingAttribute();
                LdapFilterQueryClause filterQueryClause = new LdapFilterQueryClause();
                String filter = ia.getName() + "=" + ia.getValue();
                filterQueryClause.setFilter(filter);
                Query query = new Query();
                query.setTargetID(targetDefinition.getId());
                query.setBasePsoID(basePsoId);
                query.addQueryClause((QueryClause)filterQueryClause);
                query.setScope(Scope.SUBTREE);
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.setReturnData(ReturnData.IDENTIFIER);
                searchRequest.setQuery(query);
                SearchResponse response = this.execute(searchRequest);
                if (response.getStatus() == StatusCode.SUCCESS) {
                    for (PSO pso : response.getPSOs()) {
                        psoIds.add(pso.getPsoID());
                    }
                    continue;
                }
                LOG.error("An error occurred while searching.");
                return null;
            }
        }
        LOG.debug("found {} pso ids", (Object)psoIds.size());
        return psoIds;
    }

    public boolean isValid(AddRequest addRequest, AddResponse addResponse) {
        if (!this.isValid(addRequest.getPsoID(), (Response)addResponse)) {
            return false;
        }
        if (addRequest.getData() == null) {
            this.fail((Response)addResponse, ErrorCode.MALFORMED_REQUEST, "Data is required.");
            return false;
        }
        String entityName = addRequest.findOpenContentAttrValueByName("entityName");
        if (GrouperUtil.isBlank((String)entityName)) {
            this.fail((Response)addResponse, ErrorCode.MALFORMED_REQUEST, "Invalid entity name.");
            return false;
        }
        TargetDefinition targetDefinition = this.targetDefinitions.get(addRequest.getPsoID().getTargetID());
        PSODefinition psoDefinition = targetDefinition.getPSODefinition(entityName);
        if (psoDefinition == null) {
            this.fail((Response)addResponse, ErrorCode.MALFORMED_REQUEST, "Invalid entity name.");
            return false;
        }
        Map<String, DSMLAttr> dsmlAttrs = PSP.getDSMLAttrMap(addRequest.getData());
        for (String attrName : dsmlAttrs.keySet()) {
            if (psoDefinition.getAttributeDefinition(attrName) != null) continue;
            this.fail((Response)addResponse, ErrorCode.MALFORMED_REQUEST, "Invalid attribute.");
            return false;
        }
        return true;
    }

    public boolean isValid(BulkProvisioningRequest provisioningRequest, ProvisioningResponse provisioningResponse) {
        try {
            this.getTargetAndObjectDefinitions(provisioningRequest);
        }
        catch (LdappcException e) {
            this.fail((Response)provisioningResponse, ErrorCode.NO_SUCH_IDENTIFIER, e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isValid(ModifyRequest modifyRequest, ModifyResponse modifyResponse) {
        if (!this.isValid(modifyRequest.getPsoID(), (Response)modifyResponse)) {
            return false;
        }
        if (modifyRequest.getModifications().length == 0) {
            this.fail((Response)modifyResponse, ErrorCode.MALFORMED_REQUEST, "A modification is required.");
            return false;
        }
        for (Modification modification : modifyRequest.getModifications()) {
            if (GrouperUtil.isBlank((Object)modification.getModificationMode())) {
                this.fail((Response)modifyResponse, ErrorCode.MALFORMED_REQUEST, "A modification mode is required.");
                return false;
            }
            if (modification.getModificationMode().equals(ModificationMode.ADD) || modification.getModificationMode().equals(ModificationMode.DELETE) || modification.getModificationMode().equals(ModificationMode.REPLACE)) continue;
            this.fail((Response)modifyResponse, ErrorCode.MALFORMED_REQUEST, "Unsupported modification mode.");
            return false;
        }
        return true;
    }

    public boolean isValid(ProvisioningRequest provisioningRequest, ProvisioningResponse provisioningResponse) {
        if (GrouperUtil.isBlank((String)provisioningRequest.getId())) {
            this.fail((Response)provisioningResponse, ErrorCode.MALFORMED_REQUEST, "An id is required.");
            return false;
        }
        try {
            this.getTargetAndObjectDefinitions(provisioningRequest);
        }
        catch (LdappcException e) {
            this.fail((Response)provisioningResponse, ErrorCode.NO_SUCH_IDENTIFIER, e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isValid(PSOIdentifier psoID, Response response) {
        if (GrouperUtil.isBlank((Object)psoID) || GrouperUtil.isBlank((String)psoID.getID())) {
            this.fail(response, ErrorCode.MALFORMED_REQUEST, "A psoID is required.");
            return false;
        }
        if (GrouperUtil.isBlank((String)psoID.getTargetID())) {
            this.fail(response, ErrorCode.MALFORMED_REQUEST, "A targetID is required.");
            return false;
        }
        TargetDefinition targetDefinition = this.targetDefinitions.get(psoID.getTargetID());
        if (targetDefinition == null) {
            this.fail(response, ErrorCode.NO_SUCH_IDENTIFIER, "Unknown target id '" + psoID.getTargetID() + "'");
            return false;
        }
        return true;
    }

    public boolean isValid(Response response) {
        if (response.getStatus() == null) {
            this.fail(response, ErrorCode.MALFORMED_REQUEST, "A status code is required.");
            return false;
        }
        if (!(response.getStatus().equals(StatusCode.SUCCESS) || response.getStatus().equals(StatusCode.FAILURE) || response.getStatus().equals(StatusCode.PENDING))) {
            this.fail(response, ErrorCode.MALFORMED_REQUEST, "Unsupported status code.");
            return false;
        }
        return true;
    }

    public boolean isValid(SearchRequest searchRequest, SearchResponse searchResponse) {
        Query query = searchRequest.getQuery();
        if (query == null) {
            this.fail((Response)searchResponse, ErrorCode.MALFORMED_REQUEST, "A query is required.");
            return false;
        }
        String targetId = query.getTargetID();
        if (GrouperUtil.isBlank((String)targetId)) {
            this.fail((Response)searchResponse, ErrorCode.MALFORMED_REQUEST, "A targetID is required.");
            return false;
        }
        TargetDefinition targetDefinition = this.targetDefinitions.get(targetId);
        if (targetDefinition == null) {
            this.fail((Response)searchResponse, ErrorCode.NO_SUCH_IDENTIFIER, "Unknown target id '" + targetId + "'");
            return false;
        }
        return true;
    }
}

