/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.config;

import edu.internet2.middleware.grouper.shibboleth.dataConnector.config.SPMLDataConnectorFactoryBean;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorBeanDefinitionParser;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.util.BasicStringEnumConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPMLDataConnectorBeanDefinitionParser
extends BaseDataConnectorBeanDefinitionParser {
    private final Logger LOG = LoggerFactory.getLogger(SPMLDataConnectorBeanDefinitionParser.class);
    public static final QName TYPE_NAME = new QName("http://grouper.internet2.edu/ldappc", "SPMLDataConnector");
    public static final QName FILTER_ELEMENT_NAME = new QName("http://grouper.internet2.edu/ldappc", "FilterTemplate");

    protected Class<?> getBeanClass(Element element) {
        return SPMLDataConnectorFactoryBean.class;
    }

    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        String base = pluginConfig.getAttributeNS(null, "base");
        this.LOG.debug("Data connector {} base: {}", (Object)pluginId, (Object)base);
        pluginBuilder.addPropertyValue("base", (Object)base);
        String returnDataString = pluginConfig.getAttributeNS(null, "returnData");
        this.LOG.debug("Data connector {} returnData: {}", (Object)pluginId, (Object)returnDataString);
        ReturnData returnData = (ReturnData)BasicStringEnumConstant.getConstant(ReturnData.class, (String)returnDataString);
        pluginBuilder.addPropertyValue("returnData", (Object)returnData);
        String scopeString = pluginConfig.getAttributeNS(null, "scope");
        this.LOG.debug("Data connector {} scope: {}", (Object)pluginId, (Object)scopeString);
        Scope scope = (Scope)BasicStringEnumConstant.getConstant(Scope.class, (String)scopeString);
        pluginBuilder.addPropertyValue("scope", (Object)scope);
        String provider = pluginConfig.getAttributeNS(null, "provider");
        this.LOG.debug("Data connector {} provider: {}", (Object)pluginId, (Object)provider);
        pluginBuilder.addPropertyReference("provider", provider);
        String filterTemplate = pluginConfigChildren.get(FILTER_ELEMENT_NAME).get(0).getTextContent();
        filterTemplate = DatatypeHelper.safeTrimOrNullString((String)filterTemplate);
        this.LOG.debug("Data connector {} LDAP filter template: {}", (Object)pluginId, (Object)filterTemplate);
        pluginBuilder.addPropertyValue("filterTemplate", (Object)filterTemplate);
        String templateEngineRef = pluginConfig.getAttributeNS(null, "templateEngine");
        pluginBuilder.addPropertyReference("templateEngine", templateEngineRef);
    }
}

