/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.attributeDefinition;

import edu.internet2.middleware.ldappc.LdappcConfig;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDnPSOIdentifierAttributeDefinition
extends BaseAttributeDefinition {
    private static Logger LOG = LoggerFactory.getLogger(LdapDnPSOIdentifierAttributeDefinition.class);
    public static final String STEM_RDN_ATTRIBUTE = "ou";
    private String base;
    private String rdnAttributeName;
    private LdappcConfig.GroupDNStructure structure;

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getRdnAttributeName() {
        return this.rdnAttributeName;
    }

    public void setRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeName = rdnAttributeName;
    }

    public LdappcConfig.GroupDNStructure getStructure() {
        return this.structure;
    }

    public void setStructure(LdappcConfig.GroupDNStructure structure) {
        this.structure = structure;
    }

    public List<Rdn> getRdnsFromStemName(String stemName) throws AttributeResolutionException {
        ArrayList<Rdn> rdns = new ArrayList<Rdn>();
        StringTokenizer stemTokens = new StringTokenizer(stemName, ":");
        while (stemTokens.hasMoreTokens()) {
            try {
                rdns.add(new Rdn(STEM_RDN_ATTRIBUTE, stemTokens.nextToken()));
            }
            catch (InvalidNameException e) {
                LOG.error("An error occurred creating an rdn.", (Throwable)e);
                throw new AttributeResolutionException("An error occurred creating an rdn.", (Exception)e);
            }
        }
        return rdns;
    }

    protected BaseAttribute<PSOIdentifier> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
        String msg = "resolve '" + principalName + "' ad '" + this.getId() + "'";
        LOG.debug("{}", (Object)msg);
        BasicAttribute attribute = new BasicAttribute(this.getId());
        Collection rdnValues = this.getValuesFromAllDependencies(resolutionContext, this.getSourceAttributeID());
        LOG.debug("{} dependency '{}' : {}", new Object[]{msg, this.getSourceAttributeID(), rdnValues});
        Collection stemValues = this.getValuesFromAllDependencies(resolutionContext, "parentStemName");
        LOG.debug("{} dependency '{}' : {}", new Object[]{msg, "parentStemName", stemValues});
        if (rdnValues.isEmpty()) {
            LOG.debug("{} no dependency values", (Object)msg);
            return attribute;
        }
        if (rdnValues.size() > 1) {
            LOG.warn("{} Unable to resolve identifier, dependency '{}' has more than one value", (Object)msg, (Object)this.getSourceAttributeID());
            throw new AttributeResolutionException("Unable to resolve identifier, dependency has more than one value");
        }
        if (stemValues.size() > 1) {
            LOG.warn("{} Unable to resolve identifier, dependency '{}' has more than one value", (Object)msg, (Object)"parentStemName");
            throw new AttributeResolutionException("Unable to resolve identifier, dependency has more than one value");
        }
        ArrayList<Rdn> rdns = new ArrayList<Rdn>();
        try {
            LdapName baseDn = new LdapName(this.base);
            rdns.addAll(baseDn.getRdns());
            if (this.getStructure().equals((Object)LdappcConfig.GroupDNStructure.bushy) && stemValues.size() == 1) {
                String stemValue = stemValues.iterator().next().toString();
                rdns.addAll(this.getRdnsFromStemName(stemValue));
            }
            String rdnAttributeValue = rdnValues.iterator().next().toString();
            rdns.add(new Rdn(this.rdnAttributeName, rdnAttributeValue));
        }
        catch (InvalidNameException e) {
            LOG.error("{} Unable to resolve identifier, an error occurred {}", (Object)msg, (Object)e.getMessage());
            throw new AttributeResolutionException("Unable to resolve identifier", (Exception)e);
        }
        PSOIdentifier psoIdentifier = new PSOIdentifier();
        LdapName dn = new LdapName(rdns);
        try {
            psoIdentifier.setID(LdapUtil.canonicalizeDn(dn.toString()));
        }
        catch (InvalidNameException e) {
            LOG.error("{} Unable to canonicalize identifier, an error occurred {}", (Object)msg, (Object)e.getMessage());
            throw new AttributeResolutionException("Unable to canonicalize identifier", (Exception)e);
        }
        attribute.setValues(Arrays.asList(psoIdentifier));
        if (LOG.isDebugEnabled()) {
            for (PSOIdentifier value : attribute.getValues()) {
                LOG.debug("{} value '{}'", (Object)msg, (Object)PSPUtil.getString(value));
            }
        }
        return attribute;
    }

    public void validate() throws AttributeResolutionException {
    }
}

