/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.codec;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.codec.stateful.EncoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class Asn1CodecEncoder
implements ProtocolEncoder {
    private final StatefulEncoder encoder;
    private final EncoderCallbackImpl callback = new EncoderCallbackImpl();

    public Asn1CodecEncoder(StatefulEncoder encoder) {
        encoder.setCallback((EncoderCallback)this.callback);
        this.encoder = encoder;
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws EncoderException {
        this.callback.encOut = out;
        this.encoder.encode(message);
    }

    public void dispose(IoSession session) throws Exception {
    }

    private class EncoderCallbackImpl
    implements EncoderCallback {
        private ProtocolEncoderOutput encOut;

        private EncoderCallbackImpl() {
        }

        public void encodeOccurred(StatefulEncoder codec, Object encoded) {
            if (encoded instanceof ByteBuffer) {
                ByteBuffer buf = (ByteBuffer)encoded;
                IoBuffer wrappedBuf = IoBuffer.wrap((ByteBuffer)buf);
                this.encOut.write((Object)wrappedBuf);
            } else if (encoded instanceof Object[]) {
                Object[] bufArray;
                for (Object buf : bufArray = (Object[])encoded) {
                    this.encodeOccurred(codec, buf);
                }
                this.encOut.mergeAll();
            } else if (encoded instanceof Iterator) {
                Iterator it = (Iterator)encoded;
                while (it.hasNext()) {
                    this.encodeOccurred(codec, it.next());
                }
                this.encOut.mergeAll();
            } else if (encoded instanceof Collection) {
                for (Object o : (Collection)encoded) {
                    this.encodeOccurred(codec, o);
                }
                this.encOut.mergeAll();
            } else if (encoded instanceof Enumeration) {
                Enumeration e = (Enumeration)encoded;
                while (e.hasMoreElements()) {
                    this.encodeOccurred(codec, e.nextElement());
                }
                this.encOut.mergeAll();
            } else {
                throw new IllegalArgumentException("Encoded result is not a ByteBuffer: " + encoded.getClass());
            }
        }
    }
}

