/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.relyingparty.provider;

import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.CryptoOperationRequirementLevel;
import java.util.Collection;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.LazySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSAMLProfileConfiguration
implements ProfileConfiguration {
    private Collection<String> assertionAudiences = new LazySet();
    private long assertionLifetime;
    private byte[] outboundArtifactType;
    private SecurityPolicy profileSecurityPolicy;
    private CryptoOperationRequirementLevel signAssertions;
    private Credential signingCredential;
    private CryptoOperationRequirementLevel signRequests;
    private CryptoOperationRequirementLevel signResponses;

    protected AbstractSAMLProfileConfiguration() {
    }

    public Collection<String> getAssertionAudiences() {
        return this.assertionAudiences;
    }

    public long getAssertionLifetime() {
        return this.assertionLifetime;
    }

    public byte[] getOutboundArtifactType() {
        return this.outboundArtifactType;
    }

    @Override
    public SecurityPolicy getSecurityPolicy() {
        return this.profileSecurityPolicy;
    }

    public CryptoOperationRequirementLevel getSignAssertions() {
        return this.signAssertions;
    }

    public Credential getSigningCredential() {
        return this.signingCredential;
    }

    public CryptoOperationRequirementLevel getSignRequests() {
        return this.signRequests;
    }

    public CryptoOperationRequirementLevel getSignResponses() {
        return this.signResponses;
    }

    public void setAssertionAudiences(Collection<String> audiences) {
        this.assertionAudiences = audiences;
    }

    public void setAssertionLifetime(long lifetime) {
        this.assertionLifetime = lifetime;
    }

    public void setOutboundArtifactType(byte[] type) {
        this.outboundArtifactType = type;
    }

    public void setSecurityPolicy(SecurityPolicy policy) {
        this.profileSecurityPolicy = policy;
    }

    public void setSignAssertions(CryptoOperationRequirementLevel sign) {
        this.signAssertions = sign;
    }

    public void setSigningCredential(Credential credential) {
        if (credential != null && credential.getPrivateKey() == null) {
            throw new IllegalArgumentException("Credential does not contain a private key");
        }
        this.signingCredential = credential;
    }

    public void setSignRequests(CryptoOperationRequirementLevel sign) {
        this.signRequests = sign;
    }

    public void setSignResponses(CryptoOperationRequirementLevel sign) {
        this.signResponses = sign;
    }
}

