/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.log;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditLogEntry {
    public static final String AUDIT_LOGGER_NAME = "Shibboleth-Audit";
    private static DateTimeFormatter dateFormatter = ISODateTimeFormat.basicDateTimeNoMillis();
    private DateTime auditEventTime = new DateTime();
    private String assertingPartyId;
    private String relyingPartyId;
    private String requestBinding;
    private String responseBinding;
    private String messageProfile;
    private String requestId;
    private String responseId;
    private String principalName;
    private String principalAuthenticationMethod;
    private List<String> releasedAttributes = new ArrayList<String>();

    public String getMessageProfile() {
        return this.messageProfile;
    }

    public void setMessageProfile(String profileURI) {
        this.messageProfile = profileURI;
    }

    public String getPrincipalAuthenticationMethod() {
        return this.principalAuthenticationMethod;
    }

    public void setPrincipalAuthenticationMethod(String method) {
        this.principalAuthenticationMethod = method;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String id) {
        this.principalName = id;
    }

    public String getAssertingPartyId() {
        return this.assertingPartyId;
    }

    public void setAssertingPartyId(String id) {
        this.assertingPartyId = id;
    }

    public List<String> getReleasedAttributes() {
        return this.releasedAttributes;
    }

    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    public void setRelyingPartyId(String entityId) {
        this.relyingPartyId = entityId;
    }

    public String getRequestBinding() {
        return this.requestBinding;
    }

    public void setRequestBinding(String bindingURI) {
        this.requestBinding = bindingURI;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    public String getResponseBinding() {
        return this.responseBinding;
    }

    public void setResponseBinding(String bindingURI) {
        this.responseBinding = bindingURI;
    }

    public String getResponseId() {
        return this.responseId;
    }

    public void setResponseId(String id) {
        this.responseId = id;
    }

    public DateTime getAuditEventTime() {
        return this.auditEventTime;
    }

    public String toString() {
        StringBuilder entryString = new StringBuilder();
        entryString.append(this.getAuditEventTime().toString(dateFormatter.withZone(DateTimeZone.UTC)));
        entryString.append("|");
        if (this.getRequestBinding() != null) {
            entryString.append(this.getRequestBinding());
        }
        entryString.append("|");
        if (this.getRequestId() != null) {
            entryString.append(this.getRequestId());
        }
        entryString.append("|");
        entryString.append(this.getRelyingPartyId());
        entryString.append("|");
        entryString.append(this.getMessageProfile());
        entryString.append("|");
        entryString.append(this.getAssertingPartyId());
        entryString.append("|");
        entryString.append(this.getResponseBinding());
        entryString.append("|");
        entryString.append(this.getResponseId());
        entryString.append("|");
        if (this.getPrincipalName() != null) {
            entryString.append(this.getPrincipalName());
        }
        entryString.append("|");
        if (this.getPrincipalAuthenticationMethod() != null) {
            entryString.append(this.getPrincipalAuthenticationMethod());
        }
        entryString.append("|");
        for (String attribute : this.getReleasedAttributes()) {
            entryString.append(attribute);
            entryString.append(",");
        }
        entryString.append("|");
        return entryString.toString();
    }
}

