/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.security.AbstractCredentialFactoryBean;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CredentialFactoryBean
extends AbstractCredentialFactoryBean {
    private final Logger log = LoggerFactory.getLogger(X509CredentialFactoryBean.class);
    private PrivateKey privateKey;
    private X509Certificate entityCertificate;
    private List<X509Certificate> certificates;
    private List<X509CRL> x509crls;

    protected Object createInstance() throws Exception {
        BasicX509Credential credential = new BasicX509Credential();
        credential.setUsageType(this.getUsageType());
        credential.setEntityId(this.getEntityID());
        if (this.getKeyNames() != null) {
            credential.getKeyNames().addAll(this.getKeyNames());
        }
        if (this.certificates != null) {
            credential.setEntityCertificateChain(new ArrayList<X509Certificate>(this.certificates));
            if (this.entityCertificate != null) {
                credential.setEntityCertificate(this.entityCertificate);
            } else {
                credential.setEntityCertificate(this.certificates.get(0));
            }
        }
        if (this.x509crls != null) {
            credential.setCRLs(new ArrayList<X509CRL>(this.x509crls));
        }
        credential.setPrivateKey(this.privateKey);
        credential.setPublicKey(credential.getEntityCertificate().getPublicKey());
        if (credential.getPublicKey() != null && credential.getPrivateKey() != null) {
            boolean matched = false;
            try {
                matched = SecurityHelper.matchKeyPair((PublicKey)credential.getPublicKey(), (PrivateKey)credential.getPrivateKey());
            }
            catch (SecurityException e) {
                this.log.warn("Could not perform sanity check against credential public and private key: {}", (Object)e.getMessage());
            }
            if (!matched) {
                this.log.error("Mismatch detected between credential's public and private key");
                throw new SecurityException("Mismatch between credential public and private key");
            }
        }
        return credential;
    }

    public Class getObjectType() {
        return X509Credential.class;
    }

    public X509Certificate getEntityCertificate() {
        return this.entityCertificate;
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public List<X509CRL> getCrls() {
        return this.x509crls;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setEntityCertificate(X509Certificate newCert) {
        this.entityCertificate = newCert;
    }

    public void setCertificates(List<X509Certificate> certs) {
        this.certificates = certs;
    }

    public void setCrls(List<X509CRL> crls) {
        this.x509crls = crls;
    }

    public void setPrivateKey(PrivateKey key) {
        this.privateKey = key;
    }
}

