/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition.BaseAttributeDefinitionBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition.TemplateAttributeDefinitionFactoryBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateAttributeDefinitionBeanDefinitionParser
extends BaseAttributeDefinitionBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Template");
    public static final QName TEMPLATE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "Template");
    public static final QName SOURCE_ATTRIBUTE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver:ad", "SourceAttribute");
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinitionBeanDefinitionParser.class);

    protected Class getBeanClass(Element arg0) {
        return TemplateAttributeDefinitionFactoryBean.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        if (pluginConfigChildren.containsKey(TEMPLATE_ELEMENT_NAME)) {
            Element templateElement = pluginConfigChildren.get(TEMPLATE_ELEMENT_NAME).get(0);
            String attributeTemplate = DatatypeHelper.safeTrimOrNullString((String)templateElement.getTextContent());
            pluginBuilder.addPropertyValue("attributeTemplate", (Object)attributeTemplate);
        }
        ArrayList<String> sourceAttributes = new ArrayList<String>();
        for (Element element : pluginConfigChildren.get(SOURCE_ATTRIBUTE_ELEMENT_NAME)) {
            sourceAttributes.add(DatatypeHelper.safeTrimOrNullString((String)element.getTextContent()));
        }
        pluginBuilder.addPropertyValue("sourceAttributes", sourceAttributes);
        String velocityEngineRef = pluginConfig.getAttributeNS(null, "velocityEngine");
        pluginBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
    }
}

