/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.opensaml.xml.parse.ClasspathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SpringDocumentLoader
implements DocumentLoader {
    private final Logger log = LoggerFactory.getLogger(SpringDocumentLoader.class);

    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setCoalescing(true);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new LoggingErrorHandler(this.log));
        builder.setEntityResolver((EntityResolver)new ClasspathResolver());
        return builder.parse(inputSource);
    }

    public class LoggingErrorHandler
    implements ErrorHandler {
        private Logger log;

        public LoggingErrorHandler(Logger logger) {
            this.log = logger;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.log.trace("Error parsing XML", (Throwable)exception);
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.log.trace("Fatal XML parsing XML error", (Throwable)exception);
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.log.trace("XML parsing warning", (Throwable)exception);
            throw exception;
        }
    }
}

