/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedIDDataConnector
extends BaseDataConnector {
    private final Logger log = LoggerFactory.getLogger(ComputedIDDataConnector.class);
    private String generatedAttribute;
    private String sourceAttribute;
    private byte[] salt;

    public ComputedIDDataConnector(String generatedAttributeId, String sourceAttributeId, byte[] idSalt) {
        this.log.warn("This data connector is deprecated.  The StoredID data connector should be used in its place.");
        if (DatatypeHelper.isEmpty((String)generatedAttributeId)) {
            throw new IllegalArgumentException("Provided generated attribute ID must not be empty");
        }
        this.generatedAttribute = generatedAttributeId;
        if (DatatypeHelper.isEmpty((String)sourceAttributeId)) {
            throw new IllegalArgumentException("Provided source attribute ID must not be empty");
        }
        this.sourceAttribute = sourceAttributeId;
        if (idSalt.length < 16) {
            throw new IllegalArgumentException("Provided salt must be at least 16 bytes in size.");
        }
        this.salt = idSalt;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSourceAttributeId() {
        return this.sourceAttribute;
    }

    public String getGeneratedAttributeId() {
        return this.generatedAttribute;
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String inboundMessageIssuer = resolutionContext.getAttributeRequestContext().getInboundMessageIssuer();
        if (inboundMessageIssuer == null) {
            this.log.error("No inbound message issuer identified, unable to compute ID");
            throw new AttributeResolutionException("No inbound message issuer identified");
        }
        Collection<Object> sourceIdValues = this.getValuesFromAllDependencies(resolutionContext, this.getSourceAttributeId());
        if (sourceIdValues == null || sourceIdValues.isEmpty()) {
            this.log.debug("Source attribute {} for connector {} provide no values", (Object)this.getSourceAttributeId(), (Object)this.getId());
            return Collections.EMPTY_MAP;
        }
        if (sourceIdValues.size() > 1) {
            this.log.warn("Source attribute {} for connector {} has more than one value, only the first value is used", (Object)this.getSourceAttributeId(), (Object)this.getId());
        }
        String sourceId = sourceIdValues.iterator().next().toString();
        BasicAttribute computedIdAttrib = new BasicAttribute();
        computedIdAttrib.setId(this.getGeneratedAttributeId());
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(inboundMessageIssuer.getBytes());
            md.update((byte)33);
            md.update(sourceId.getBytes());
            md.update((byte)33);
            computedIdAttrib.getValues().add(Base64.encodeBytes((byte[])md.digest(this.salt)));
            LazyMap attribtues = new LazyMap();
            attribtues.put((Object)this.getGeneratedAttributeId(), computedIdAttrib);
            return attribtues;
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("JVM error, SHA-1 hash is not supported.");
            throw new AttributeResolutionException("SHA-1A is not supported, unable to compute ID");
        }
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.getDependencyIds() == null || this.getDependencyIds().size() != 1) {
            this.log.error("Computed ID " + this.getId() + " data connectore requires exactly one dependency");
            throw new AttributeResolutionException("Computed ID " + this.getId() + " data connectore requires exactly one dependency");
        }
    }
}

