/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolver;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.ContextualAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.ContextualDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.DataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector.ContextualPrincipalConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector.PrincipalConnector;
import edu.internet2.middleware.shibboleth.common.config.BaseReloadableService;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml2.core.NameID;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShibbolethAttributeResolver
extends BaseReloadableService
implements AttributeResolver<SAMLProfileRequestContext> {
    public static final Collection<Class> PLUGIN_TYPES = Arrays.asList(DataConnector.class, AttributeDefinition.class, PrincipalConnector.class);
    private final Logger log = LoggerFactory.getLogger((String)ShibbolethAttributeResolver.class.getName());
    private Map<String, DataConnector> dataConnectors = new HashMap<String, DataConnector>();
    private Map<String, AttributeDefinition> definitions = new HashMap<String, AttributeDefinition>();
    private Map<String, PrincipalConnector> principalConnectors = new HashMap<String, PrincipalConnector>();

    public Map<String, AttributeDefinition> getAttributeDefinitions() {
        return this.definitions;
    }

    public Map<String, DataConnector> getDataConnectors() {
        return this.dataConnectors;
    }

    public Map<String, PrincipalConnector> getPrincipalConnectors() {
        return this.principalConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, BaseAttribute> resolveAttributes(SAMLProfileRequestContext attributeRequestContext) throws AttributeResolutionException {
        ShibbolethResolutionContext resolutionContext = new ShibbolethResolutionContext(attributeRequestContext);
        this.log.debug("{} resolving attributes for principal {}", (Object)this.getId(), (Object)attributeRequestContext.getPrincipalName());
        if (this.getAttributeDefinitions().size() == 0) {
            this.log.debug("No attribute definitions loaded in {} so no attributes can be resolved for principal {}", (Object)this.getId(), (Object)attributeRequestContext.getPrincipalName());
            return new HashMap<String, BaseAttribute>();
        }
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        Map<String, BaseAttribute> resolvedAttributes = null;
        try {
            resolvedAttributes = this.resolveAttributes(resolutionContext);
            this.cleanResolvedAttributes(resolvedAttributes, resolutionContext);
        }
        finally {
            readLock.unlock();
        }
        this.log.debug(this.getId() + " resolved, for principal {}, the attributes: {}", (Object)attributeRequestContext.getPrincipalName(), resolvedAttributes.keySet());
        return resolvedAttributes;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        for (DataConnector dataConnector : this.dataConnectors.values()) {
            if (dataConnector == null) continue;
            dataConnector.validate();
        }
        for (AttributeDefinition attributeDefinition : this.definitions.values()) {
            if (attributeDefinition == null) continue;
            attributeDefinition.validate();
        }
        for (PrincipalConnector principalConnector : this.principalConnectors.values()) {
            if (principalConnector == null) continue;
            principalConnector.validate();
        }
    }

    public String resolvePrincipalName(SAMLProfileRequestContext requestContext) throws AttributeResolutionException {
        String nameIdFormat = this.getNameIdentifierFormat(requestContext.getSubjectNameIdentifier());
        this.log.debug("Resolving principal name from name identifier of format: {}", (Object)nameIdFormat);
        ResolutionPlugIn effectiveConnector = null;
        for (PrincipalConnector connector : this.principalConnectors.values()) {
            if (!connector.getFormat().equals(nameIdFormat)) continue;
            if (connector.getRelyingParties().contains(requestContext.getInboundMessageIssuer())) {
                effectiveConnector = connector;
                break;
            }
            if (!connector.getRelyingParties().isEmpty()) continue;
            effectiveConnector = connector;
        }
        if (effectiveConnector == null) {
            throw new AttributeResolutionException("No principal connector available to resolve a subject name with format " + nameIdFormat + " for relying party " + requestContext.getInboundMessageIssuer());
        }
        this.log.debug("Using principal connector {} to resolve principal name.", (Object)effectiveConnector.getId());
        effectiveConnector = new ContextualPrincipalConnector((PrincipalConnector)effectiveConnector);
        ShibbolethResolutionContext resolutionContext = new ShibbolethResolutionContext(requestContext);
        this.resolveDependencies(effectiveConnector, resolutionContext);
        return (String)effectiveConnector.resolve(resolutionContext);
    }

    protected String getNameIdentifierFormat(SAMLObject nameIdentifier) {
        String subjectNameFormat = null;
        if (nameIdentifier instanceof NameIdentifier) {
            NameIdentifier identifier = (NameIdentifier)nameIdentifier;
            subjectNameFormat = identifier.getFormat();
        } else if (nameIdentifier instanceof NameID) {
            NameID identifier = (NameID)nameIdentifier;
            subjectNameFormat = identifier.getFormat();
        }
        if (DatatypeHelper.isEmpty(subjectNameFormat)) {
            subjectNameFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        return subjectNameFormat;
    }

    @Override
    protected Map<String, BaseAttribute> resolveAttributes(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        Set<String> attributeIDs = resolutionContext.getAttributeRequestContext().getRequestedAttributesIds();
        HashMap<String, BaseAttribute> resolvedAttributes = new HashMap<String, BaseAttribute>();
        if (attributeIDs == null || attributeIDs.isEmpty()) {
            this.log.debug("Specific attributes for principal {} were not requested, resolving all attributes.", (Object)resolutionContext.getAttributeRequestContext().getPrincipalName());
            attributeIDs = this.getAttributeDefinitions().keySet();
        }
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        for (String attributeID : attributeIDs) {
            BaseAttribute resolvedAttribute = this.resolveAttribute(attributeID, resolutionContext);
            if (resolvedAttribute == null) continue;
            resolvedAttributes.put(resolvedAttribute.getId(), resolvedAttribute);
        }
        readLock.unlock();
        return resolvedAttributes;
    }

    protected BaseAttribute resolveAttribute(String attributeID, ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        AttributeDefinition definition = resolutionContext.getResolvedAttributeDefinitions().get(attributeID);
        if (definition == null) {
            this.log.debug("Resolving attribute {} for principal {}", (Object)attributeID, (Object)resolutionContext.getAttributeRequestContext().getPrincipalName());
            definition = this.getAttributeDefinitions().get(attributeID);
            if (definition == null) {
                this.log.warn("{} requested attribute {} but no attribute definition exists for that attribute", (Object)resolutionContext.getAttributeRequestContext().getInboundMessageIssuer(), (Object)attributeID);
                return null;
            }
            definition = new ContextualAttributeDefinition(definition);
            resolutionContext.getResolvedPlugins().put(attributeID, definition);
        }
        this.resolveDependencies(definition, resolutionContext);
        BaseAttribute attribute = (BaseAttribute)definition.resolve(resolutionContext);
        this.log.debug("Resolved attribute {} containing {} values", (Object)attributeID, (Object)attribute.getValues().size());
        return attribute;
    }

    protected void resolveDataConnector(String connectorID, ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        DataConnector dataConnector = resolutionContext.getResolvedDataConnectors().get(connectorID);
        if (dataConnector == null) {
            this.log.debug("Resolving data connector {} for principal {}", (Object)connectorID, (Object)resolutionContext.getAttributeRequestContext().getPrincipalName());
            dataConnector = this.getDataConnectors().get(connectorID);
            if (dataConnector == null) {
                this.log.warn("{} requested to resolve data connector {} but does not have such a data connector", (Object)this.getId(), (Object)connectorID);
            } else {
                dataConnector = new ContextualDataConnector(dataConnector);
                resolutionContext.getResolvedPlugins().put(connectorID, dataConnector);
            }
        }
        this.resolveDependencies(dataConnector, resolutionContext);
        try {
            dataConnector.resolve(resolutionContext);
        }
        catch (AttributeResolutionException e) {
            String failoverDataConnectorId = dataConnector.getFailoverDependencyId();
            if (DatatypeHelper.isEmpty((String)failoverDataConnectorId)) {
                throw e;
            }
            this.log.error("Received the following error from data connector " + dataConnector.getId() + ", trying its failover connector " + failoverDataConnectorId, (Throwable)e);
            this.resolveDataConnector(failoverDataConnectorId, resolutionContext);
            DataConnector failoverConnector = resolutionContext.getResolvedDataConnectors().get(failoverDataConnectorId);
            this.log.debug("Using failover connector {} in place of {} for the remainder of this resolution", (Object)failoverConnector.getId(), (Object)connectorID);
            resolutionContext.getResolvedPlugins().put(connectorID, failoverConnector);
        }
    }

    protected void resolveDependencies(ResolutionPlugIn<?> plugin, ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        for (String dependency : plugin.getDependencyIds()) {
            if (this.dataConnectors.containsKey(dependency)) {
                this.resolveDataConnector(dependency, resolutionContext);
                continue;
            }
            if (!this.definitions.containsKey(dependency)) continue;
            this.resolveAttribute(dependency, resolutionContext);
        }
    }

    protected void cleanResolvedAttributes(Map<String, BaseAttribute> resolvedAttributes, ShibbolethResolutionContext resolutionContext) {
        Iterator<Map.Entry<String, BaseAttribute>> attributeItr = resolvedAttributes.entrySet().iterator();
        while (attributeItr.hasNext()) {
            BaseAttribute resolvedAttribute = attributeItr.next().getValue();
            if (resolvedAttribute == null) {
                attributeItr.remove();
                continue;
            }
            AttributeDefinition attributeDefinition = this.getAttributeDefinitions().get(resolvedAttribute.getId());
            if (attributeDefinition.isDependencyOnly()) {
                this.log.debug("Removing dependency-only attribute {} from resolution result for principal {}.", (Object)resolvedAttribute.getId(), (Object)resolutionContext.getAttributeRequestContext().getPrincipalName());
                attributeItr.remove();
                continue;
            }
            if (resolvedAttribute.getValues().size() == 0) {
                this.log.debug("Removing attribute {} from resolution result for principal {}.  It contains no values.", (Object)resolvedAttribute.getId(), (Object)resolutionContext.getAttributeRequestContext().getPrincipalName());
                attributeItr.remove();
                continue;
            }
            Iterator valueItr = resolvedAttribute.getValues().iterator();
            HashSet values = new HashSet();
            while (valueItr.hasNext()) {
                Object value = valueItr.next();
                if (values.add(value)) continue;
                this.log.debug("Removing duplicate value {} of attribute {} from resolution result", value, (Object)resolvedAttribute.getId());
                valueItr.remove();
            }
        }
    }

    protected void addVertex(DirectedGraph<ResolutionPlugIn, DefaultEdge> graph, ResolutionPlugIn<?> plugin) {
        graph.addVertex(plugin);
        ResolutionPlugIn dependency = null;
        for (String id : plugin.getDependencyIds()) {
            if (this.dataConnectors.containsKey(id)) {
                dependency = this.dataConnectors.get(id);
            } else if (this.definitions.containsKey(id)) {
                dependency = this.definitions.get(id);
            }
            if (dependency == null) continue;
            graph.addVertex((Object)dependency);
            graph.addEdge(plugin, (Object)dependency);
        }
    }

    @Override
    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        Map<String, DataConnector> oldDataConnectors = this.dataConnectors;
        HashMap<String, DataConnector> newDataConnectors = new HashMap<String, DataConnector>();
        String[] beanNames = newServiceContext.getBeanNamesForType(DataConnector.class);
        this.log.debug("Loading {} data connectors", (Object)beanNames.length);
        for (String beanName : beanNames) {
            DataConnector dConnector = (DataConnector)newServiceContext.getBean(beanName);
            newDataConnectors.put(dConnector.getId(), dConnector);
        }
        Map<String, AttributeDefinition> oldAttributeDefinitions = this.definitions;
        HashMap<String, AttributeDefinition> newAttributeDefinitions = new HashMap<String, AttributeDefinition>();
        beanNames = newServiceContext.getBeanNamesForType(AttributeDefinition.class);
        this.log.debug("Loading {} attribute definitions", (Object)beanNames.length);
        for (String beanName : beanNames) {
            AttributeDefinition aDefinition = (AttributeDefinition)newServiceContext.getBean(beanName);
            newAttributeDefinitions.put(aDefinition.getId(), aDefinition);
        }
        Map<String, PrincipalConnector> oldPrincipalConnectors = this.principalConnectors;
        HashMap<String, PrincipalConnector> newPrincipalConnectors = new HashMap<String, PrincipalConnector>();
        beanNames = newServiceContext.getBeanNamesForType(PrincipalConnector.class);
        this.log.debug("Loading {} principal connectors", (Object)beanNames.length);
        for (String beanName : beanNames) {
            PrincipalConnector pConnector = (PrincipalConnector)newServiceContext.getBean(beanName);
            newPrincipalConnectors.put(pConnector.getId(), pConnector);
        }
        try {
            this.dataConnectors = newDataConnectors;
            this.definitions = newAttributeDefinitions;
            this.principalConnectors = newPrincipalConnectors;
            this.validate();
        }
        catch (AttributeResolutionException e) {
            this.dataConnectors = oldDataConnectors;
            this.definitions = oldAttributeDefinitions;
            this.principalConnectors = oldPrincipalConnectors;
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", e);
        }
    }
}

