/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.MatchFunctor;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndMatchFunctor
extends AbstractMatchFunctor {
    private List<MatchFunctor> targetRules;

    public AndMatchFunctor(List<MatchFunctor> rules) {
        this.targetRules = rules;
    }

    public List<MatchFunctor> getTargetRules() {
        return this.targetRules;
    }

    @Override
    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        if (this.targetRules == null || this.targetRules.isEmpty()) {
            return false;
        }
        for (MatchFunctor child : this.targetRules) {
            if (child.evaluatePolicyRequirement(filterContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        if (this.targetRules == null || this.targetRules.isEmpty()) {
            return false;
        }
        for (MatchFunctor child : this.targetRules) {
            if (child.evaluatePermitValue(filterContext, attributeId, attributeValue)) continue;
            return false;
        }
        return true;
    }
}

